/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import eu.lundegaard.commons.util.ValidateUtil;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtil {
    private RandomUtil() {
    }

    public static int getRandomInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static int getRandomInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static int getRandomInt(int origin, int bound) {
        return ThreadLocalRandom.current().nextInt(origin, bound);
    }

    public static long getRandomLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static long getRandomLong(long bound) {
        return ThreadLocalRandom.current().nextLong(bound);
    }

    public static long getRandomLong(long origin, long bound) {
        return ThreadLocalRandom.current().nextLong(origin, bound);
    }

    public static boolean getRandomBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static <T> T getRandomFromList(List<T> objects) {
        ValidateUtil.validateNotEmpty(objects, "Input list must not be empty or null.");
        return objects.get(RandomUtil.getRandomInt(objects.size()));
    }
}

