/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import eu.lundegaard.commons.iface.Identifiable;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class IdentifiableUtil {
    private IdentifiableUtil() {
    }

    public static <I extends Serializable> List<I> getIds(List<? extends Identifiable<I>> itemsList) {
        return itemsList.stream().map(Identifiable::getId).collect(Collectors.toList());
    }

    public static <I extends Serializable, T extends Identifiable<I>> Optional<T> findInList(List<T> list, I id) {
        return list.stream().filter(item -> item.getId().equals(id)).findFirst();
    }
}

