/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.scope;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.TimestampScopeFinder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DetachedTimestampScopeFinder
extends AbstractSignatureScopeFinder
implements TimestampScopeFinder {
    protected DSSDocument timestampedData;

    public void setTimestampedData(DSSDocument timestampedData) {
        this.timestampedData = timestampedData;
    }

    @Override
    public List<SignatureScope> findTimestampScope(TimestampToken timestampToken) {
        if (timestampToken.isMessageImprintDataIntact()) {
            return this.getTimestampSignatureScopeForDocument(this.timestampedData);
        }
        return Collections.emptyList();
    }

    protected List<SignatureScope> getTimestampSignatureScopeForDocument(DSSDocument document) {
        String documentName = document.getName();
        if (document instanceof DigestDocument) {
            return Arrays.asList(new SignatureScope[]{new DigestSignatureScope(Utils.isStringNotEmpty((String)documentName) ? documentName : "Digest document", document)});
        }
        return Arrays.asList(new SignatureScope[]{new FullSignatureScope(Utils.isStringNotEmpty((String)documentName) ? documentName : "Full document", document)});
    }
}

