package eu.cedarsoft.wicket.breadcrumb;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.model.IModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/**
 *
 */
public class BreadCrumbDataView extends DataView {
  private static final long serialVersionUID = 6397694806947919322L;

  public BreadCrumbDataView( @NotNull @NonNls String id, @NotNull PageStructureProvider pageStructureProvider, @NotNull IModel /*Path*/ pathModel ) {
    super( id, new BreadCrumbElementProvider( pageStructureProvider, pathModel ) );
  }

  @Override
  protected void populateItem( @NotNull Item item ) {
    BreadCrumbElement element = ( BreadCrumbElement ) item.getModelObject();

    item.add( new Label( BreadCrumbBar.ID_SEPARATOR, BreadCrumbBar.SEPARATOR ).setEscapeModelStrings( false ) );

    BookmarkablePageLink link = new BookmarkablePageLink( BreadCrumbBar.ID_LINK, element.getPageClass() );
    item.add( link );
    link.add( new Label( BreadCrumbBar.ID_ELEMENT, element.getName() ) );
  }
}
