package eu.cedarsoft.wicket.attachments;

import eu.cedarsoft.wicket.FriendsOnly;
import eu.cedarsoft.wicket.WicketConstants;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.StyleSheetReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.util.List;

/**
 * <p/>
 * Date: Jun 7, 2007<br>
 * Time: 2:44:20 PM<br>
 */
@FriendsOnly
public class AttachmentsComponent extends Panel {
  public AttachmentsComponent( @NotNull @NonNls String id, @NotNull List<? extends File> resourceFiles ) {
    super( id );
    add( new StyleSheetReference( WicketConstants.ID_STYLE_SHEET, AttachmentsComponent.class, "AttachmentsComponent.css" ) );
    add( new ListView( "attachments", resourceFiles ) {
      @Override
      protected void populateItem( ListItem item ) {
        final File file = ( File ) item.getModelObject();
        Link link = new DownloadLink( "downloadLink", file );
        item.add( link );
        link.add( new Label( "label", file.getName() ) );
      }
    } );
  }
}
