/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZipExtractor {
    private static final int BUFFER_LENGTH = 1024;
    private final File zipFile;
    private Condition condition;

    public ZipExtractor(@NotNull File zipFile) throws FileNotFoundException {
        if (!zipFile.exists()) {
            throw new FileNotFoundException("File not found " + zipFile.getAbsolutePath());
        }
        this.zipFile = zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(@NotNull File destination) throws IOException {
        if (!destination.exists() || !destination.isDirectory()) {
            throw new IllegalArgumentException("Invalid destination: " + destination.getCanonicalPath());
        }
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(this.zipFile));
            byte[] buf = new byte[1024];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (this.condition == null || this.condition.shallExtract(zipEntry)) {
                    String entryName = zipEntry.getName();
                    File newFile = new File(destination, entryName);
                    if (zipEntry.isDirectory()) {
                        newFile.mkdirs();
                    } else {
                        newFile.getParentFile().mkdirs();
                        FileOutputStream fileoutputstream = null;
                        try {
                            int n;
                            fileoutputstream = new FileOutputStream(newFile);
                            while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                                fileoutputstream.write(buf, 0, n);
                            }
                        }
                        finally {
                            if (fileoutputstream != null) {
                                fileoutputstream.close();
                            }
                        }
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
    }

    @Nullable
    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(@Nullable Condition condition) {
        this.condition = condition;
    }

    public static class InvertedCondition
    implements Condition {
        private final Condition condition;

        public InvertedCondition(@NotNull Condition condition) {
            this.condition = condition;
        }

        public boolean shallExtract(@NotNull ZipEntry zipEntry) {
            return !this.condition.shallExtract(zipEntry);
        }
    }

    public static interface Condition {
        public boolean shallExtract(@NotNull ZipEntry var1);
    }
}

