/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class ZipCreator {
    static final int BUFFER_SIZE = 2048;
    private final File zipFile;

    public ZipCreator(@NotNull File zipFile) {
        this.zipFile = zipFile;
    }

    @NotNull
    public File getZipFile() {
        return this.zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File zip(File ... directories) throws IOException {
        ZipOutputStream outStream = null;
        try {
            outStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipFile)));
            for (File directory : directories) {
                String baseName = directory.getCanonicalPath();
                this.addFiles(baseName, outStream, directory);
            }
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
        return this.zipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFiles(@NotNull String baseName, @NotNull ZipOutputStream outStream, @NotNull File directory) throws IOException {
        byte[] data = new byte[2048];
        for (File file : directory.listFiles()) {
            String relativeName = ZipCreator.getRelativePath(baseName, file);
            ZipEntry entry = new ZipEntry(relativeName);
            try {
                outStream.putNextEntry(entry);
            }
            catch (ZipException ignore) {
                System.out.println("Ignoring " + ignore.getMessage());
            }
            if (file.isDirectory()) {
                this.addFiles(baseName, outStream, file);
                continue;
            }
            FileInputStream fileInputStream = null;
            BufferedInputStream origin = null;
            try {
                int count;
                fileInputStream = new FileInputStream(file);
                origin = new BufferedInputStream(fileInputStream, 2048);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    outStream.write(data, 0, count);
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (origin != null) {
                    origin.close();
                }
            }
        }
    }

    @NotNull
    protected static String getRelativePath(@NotNull String baseName, @NotNull File file) throws IOException {
        String name = file.getCanonicalPath().substring(baseName.length() + 1);
        if (file.isDirectory()) {
            name = name + '/';
        }
        return name.replaceAll("\\\\", "/");
    }
}

