/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer.metadata;

import es.webbeta.serializer.metadata.IMetadataProperty;
import es.webbeta.serializer.metadata.Metadata;
import es.webbeta.serializer.metadata.MetadataProperty;
import es.webbeta.serializer.metadata.MetadataPropertyAccessor;
import es.webbeta.serializer.metadata.MetadataVirtualProperty;
import es.webbeta.serializer.type.FieldAccessType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetadataConstructor {
    private static final String KEY_VIRTUAL_PROPERTIES = "virtual_properties";
    private static final String KEY_PROPERTIES = "properties";
    private static final String KEY_ACCESS_TYPE = "access_type";
    private static final String KEY_ACCESSOR = "accessor";
    private static final String KEY_SERIALIZED_NAME = "serialized_name";
    private static final String KEY_GROUPS = "groups";
    private static final String KEY_GETTER = "getter";

    public static Metadata build(Map map) {
        if (map == null) {
            return null;
        }
        Map.Entry root = map.entrySet().iterator().next();
        String canonicalName = (String)root.getKey();
        Map modifiers = (Map)root.getValue();
        Metadata metadata = new Metadata(canonicalName);
        for (Map.Entry modifierEntry : modifiers.entrySet()) {
            String key;
            switch (key = (String)modifierEntry.getKey()) {
                case "properties": {
                    List<MetadataProperty> properties = MetadataConstructor.buildProperties((Map)modifierEntry.getValue(), false);
                    metadata.setProperties(properties);
                    break;
                }
                case "access_type": {
                    metadata.setAccessType(FieldAccessType.fromString((String)modifierEntry.getValue()));
                    break;
                }
                case "virtual_properties": {
                    List<MetadataProperty> properties = MetadataConstructor.buildProperties((Map)modifierEntry.getValue(), true);
                    metadata.setVirtualProperties(properties);
                    break;
                }
            }
        }
        return metadata;
    }

    private static <T extends IMetadataProperty> List<T> buildProperties(Map<String, Map<String, Object>> map, Boolean asVirtualProperties) {
        ArrayList<MetadataProperty> properties = new ArrayList<MetadataProperty>();
        for (Map.Entry<String, Map<String, Object>> propertyEntry : map.entrySet()) {
            String propertyName = propertyEntry.getKey();
            Map<String, Object> args = propertyEntry.getValue();
            MetadataProperty metadataProperty = asVirtualProperties != false ? new MetadataVirtualProperty(propertyName) : new MetadataProperty(propertyName);
            for (Map.Entry<String, Object> argEntry : args.entrySet()) {
                String key;
                switch (key = argEntry.getKey()) {
                    case "groups": {
                        ArrayList<String> groups = new ArrayList<String>();
                        for (Object rawGroup : (List)argEntry.getValue()) {
                            String group = (String)rawGroup;
                            groups.add(group);
                        }
                        metadataProperty.setGroups(groups);
                        break;
                    }
                    case "serialized_name": {
                        metadataProperty.setSerializedName((String)argEntry.getValue());
                    }
                }
                if (asVirtualProperties.booleanValue()) continue;
                switch (key) {
                    case "access_type": {
                        metadataProperty.setAccessType(FieldAccessType.fromString((String)argEntry.getValue()));
                        break;
                    }
                    case "accessor": {
                        MetadataPropertyAccessor accessor = MetadataConstructor.buildPropertyAccessor(metadataProperty, (Map)argEntry.getValue());
                        metadataProperty.setAccessor(accessor);
                    }
                }
            }
            properties.add(metadataProperty);
        }
        return properties;
    }

    private static MetadataPropertyAccessor buildPropertyAccessor(IMetadataProperty metadataProperty, Map<String, String> map) {
        if (metadataProperty.getAccessType() != FieldAccessType.PUBLIC_METHOD) {
            return null;
        }
        String getter = null;
        for (Map.Entry<String, String> argEntry : map.entrySet()) {
            String key = argEntry.getKey();
            if (!key.equals(KEY_GETTER)) continue;
            getter = argEntry.getValue();
        }
        return getter == null ? null : new MetadataPropertyAccessor(getter);
    }
}

