/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer.metadata;

import es.webbeta.serializer.metadata.IMetadataProperty;
import es.webbeta.serializer.metadata.MetadataProperty;
import es.webbeta.serializer.metadata.MetadataVirtualProperty;
import es.webbeta.serializer.type.FieldAccessType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Metadata {
    private String canonicalName;
    private FieldAccessType accessType;
    private List<MetadataVirtualProperty> virtualProperties = new ArrayList<MetadataVirtualProperty>();
    private List<MetadataProperty> properties = new ArrayList<MetadataProperty>();

    Metadata(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public Boolean appliesTo(String canonicalName) {
        return this.canonicalName.equals(canonicalName);
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public Boolean hasAccessType() {
        return this.accessType != null;
    }

    public FieldAccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(FieldAccessType accessType) {
        this.accessType = accessType;
    }

    public Boolean hasVirtualProperties() {
        return this.virtualProperties.size() > 0;
    }

    public List<MetadataVirtualProperty> getVirtualProperties() {
        return this.virtualProperties;
    }

    public Boolean hasVirtualProperty(String name) {
        return this.getVirtualProperty(name) != null;
    }

    public MetadataVirtualProperty getVirtualProperty(String name) {
        List props = this.virtualProperties.stream().filter(prop -> prop.getPropertyName().equals(name)).collect(Collectors.toList());
        if (props.size() == 0) {
            return null;
        }
        return (MetadataVirtualProperty)props.get(0);
    }

    public void setVirtualProperties(List<MetadataVirtualProperty> virtualProperties) {
        this.virtualProperties = virtualProperties;
    }

    public Boolean hasProperties() {
        return this.properties.size() > 0;
    }

    public List<MetadataProperty> getProperties() {
        return this.properties;
    }

    public Boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public MetadataProperty getProperty(String name) {
        List props = this.properties.stream().filter(prop -> prop.getPropertyName().equals(name)).collect(Collectors.toList());
        if (props.size() == 0) {
            return null;
        }
        return (MetadataProperty)props.get(0);
    }

    public void setProperties(List<MetadataProperty> properties) {
        this.properties = properties;
    }

    public Boolean hasMixedProperties() {
        return this.hasProperties() != false || this.hasVirtualProperties() != false;
    }

    public List<IMetadataProperty> getMixedProperties() {
        return Stream.concat(this.properties.stream(), this.virtualProperties.stream()).collect(Collectors.toList());
    }

    public Boolean hasMixedProperty(String name) {
        return this.getMixedProperty(name) != null;
    }

    public IMetadataProperty getMixedProperty(String name) {
        List<IMetadataProperty> mixedProps = this.getMixedProperties();
        List props = mixedProps.stream().filter(prop -> prop.getPropertyName().equals(name)).collect(Collectors.toList());
        if (props.size() == 0) {
            return null;
        }
        return (IMetadataProperty)props.get(0);
    }
}

