/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer;

import es.webbeta.serializer.base.SerializerMetadataProvider;
import es.webbeta.serializer.base.TypeCallback;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class TypeChecker {
    private SerializerMetadataProvider provider;

    public TypeChecker(SerializerMetadataProvider provider) {
        this.provider = provider;
    }

    public <T> Boolean isByte(T value) {
        return value instanceof Byte;
    }

    public <T> Boolean isShort(T value) {
        return value instanceof Short;
    }

    public <T> Boolean isInteger(T value) {
        return value instanceof Integer;
    }

    public <T> Boolean isBigInteger(T value) {
        return value instanceof BigInteger;
    }

    public <T> Boolean isLong(T value) {
        return value instanceof Long;
    }

    public <T> Boolean isFloat(T value) {
        return value instanceof Float;
    }

    public <T> Boolean isDouble(T value) {
        return value instanceof Double;
    }

    public <T> Boolean isBigDecimal(T value) {
        return value instanceof BigDecimal;
    }

    public <T> Boolean isNumeric(T value) {
        return this.isByte(value) != false || this.isShort(value) != false || this.isInteger(value) != false || this.isBigInteger(value) != false || this.isLong(value) != false || this.isFloat(value) != false || this.isDouble(value) != false || this.isBigDecimal(value) != false;
    }

    public <T> Boolean isString(T value) {
        return value instanceof String;
    }

    public <T> Boolean isStringParseable(T value) {
        return value instanceof Enum || value instanceof UUID;
    }

    public <T> Boolean isBoolean(T value) {
        return value instanceof Boolean;
    }

    public <T> Boolean isDate(T value) {
        return value instanceof Date;
    }

    public <T> Boolean isSerializableObject(T value) {
        return !(value instanceof Iterable) && this.provider.canProvide(value.getClass()) != false;
    }

    public <T> Boolean isUnserializableObject(T value) {
        return this.isNumeric(value) == false && this.isString(value) == false && this.isStringParseable(value) == false && this.isBoolean(value) == false && this.isDate(value) == false && this.isIterable(value) == false && this.isMap(value) == false && this.provider.canProvide(value.getClass()) == false;
    }

    public <T> Boolean isIterable(T value) {
        return value instanceof Iterable;
    }

    public <T> Boolean isMap(T value) {
        return value instanceof Map;
    }

    public <T> void check(T value, TypeCallback callback) throws IOException {
        if (this.isByte(value).booleanValue()) {
            callback.itsByte((Byte)value);
            callback.itsNumeric(value);
        } else if (this.isShort(value).booleanValue()) {
            callback.itsShort((Short)value);
            callback.itsNumeric(value);
        } else if (this.isInteger(value).booleanValue()) {
            callback.itsInteger((Integer)value);
            callback.itsNumeric(value);
        } else if (this.isBigInteger(value).booleanValue()) {
            callback.itsBigInteger((BigInteger)value);
            callback.itsNumeric(value);
        } else if (this.isLong(value).booleanValue()) {
            callback.itsLong((Long)value);
            callback.itsNumeric(value);
        } else if (this.isFloat(value).booleanValue()) {
            callback.itsFloat((Float)value);
            callback.itsNumeric(value);
        } else if (this.isDouble(value).booleanValue()) {
            callback.itsDouble((Double)value);
            callback.itsNumeric(value);
        } else if (this.isBigDecimal(value).booleanValue()) {
            callback.itsBigDecimal((BigDecimal)value);
            callback.itsNumeric(value);
        } else if (this.isString(value).booleanValue()) {
            callback.itsString((String)value);
        } else if (this.isStringParseable(value).booleanValue()) {
            callback.itsStringParseable(value);
        } else if (this.isBoolean(value).booleanValue()) {
            callback.itsBoolean((Boolean)value);
        } else if (this.isDate(value).booleanValue()) {
            callback.itsDate((Date)value);
        } else if (this.isUnserializableObject(value).booleanValue()) {
            callback.itsUnserializableObject(value);
        } else if (this.isSerializableObject(value).booleanValue()) {
            callback.itsSerializableObject(value);
        } else if (this.isIterable(value).booleanValue()) {
            callback.itsIterable((Iterable)value);
        } else if (this.isMap(value).booleanValue()) {
            callback.itsMap((Map)value);
        }
    }
}

