/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer;

import es.webbeta.serializer.base.MetadataAccessor;
import es.webbeta.serializer.base.ParentFieldData;
import es.webbeta.serializer.base.SerializerMetadataProvider;
import es.webbeta.serializer.metadata.IMetadataProperty;
import es.webbeta.serializer.metadata.Metadata;
import es.webbeta.serializer.metadata.MetadataConstructor;
import es.webbeta.serializer.metadata.MetadataProperty;
import es.webbeta.serializer.metadata.MetadataPropertyAccessor;
import es.webbeta.serializer.metadata.MetadataVirtualProperty;
import es.webbeta.serializer.type.FieldAccessType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class SerializerYamlMetadataProvider
implements SerializerMetadataProvider {
    private MetadataAccessor metadataAccessor;
    private Map<String, Metadata> metadatas;

    public SerializerYamlMetadataProvider(MetadataAccessor metadataAccessor) {
        this.metadataAccessor = metadataAccessor;
        this.metadatas = new HashMap<String, Metadata>();
    }

    private void initializeMetadata(Class<?> klass) {
        if (this.metadatas.containsKey(klass.getCanonicalName())) {
            return;
        }
        Yaml yaml = new Yaml();
        if (!this.metadataAccessor.hasMetadata(klass).booleanValue()) {
            this.putNullMetadata(klass);
            return;
        }
        String yamlFileContents = this.metadataAccessor.getMetadataContent(klass);
        Metadata metadata = MetadataConstructor.build((Map)yaml.loadAs(yamlFileContents, Map.class));
        if (metadata == null || !metadata.appliesTo(klass.getCanonicalName()).booleanValue()) {
            this.putNullMetadata(klass);
            return;
        }
        this.metadatas.put(klass.getCanonicalName(), metadata);
    }

    private void putNullMetadata(Class<?> klass) {
        this.metadatas.put(klass.getCanonicalName(), null);
    }

    private Boolean containsMetadata(Class<?> klass) {
        return this.metadatas.containsKey(klass.getCanonicalName()) && this.metadatas.get(klass.getCanonicalName()) != null;
    }

    private Metadata getMetadata(Class<?> klass) {
        return this.metadatas.get(klass.getCanonicalName());
    }

    @Override
    public Boolean canProvide(Class<?> klass) {
        this.initializeMetadata(klass);
        return this.metadataAccessor.hasMetadata(klass) != false && this.containsMetadata(klass) != false;
    }

    @Override
    public String[] getPropertiesByGroup(Class<?> klass, ParentFieldData parentData, String ... group) {
        this.initializeMetadata(klass);
        if (!this.containsMetadata(klass).booleanValue()) {
            return new String[0];
        }
        ArrayList<String> properties = new ArrayList<String>();
        Metadata metadata = this.getMetadata(klass);
        if (metadata.hasProperties().booleanValue()) {
            for (MetadataProperty metadataProperty : metadata.getProperties()) {
                if (parentData != null && parentData.isRecursive(klass, metadataProperty.getPropertyName()).booleanValue() || !metadataProperty.hasGroups().booleanValue() || !metadataProperty.appliesToGroups(Arrays.asList(group)).booleanValue()) continue;
                properties.add(metadataProperty.getPropertyName());
            }
        }
        if (metadata.hasVirtualProperties().booleanValue()) {
            for (MetadataVirtualProperty metadataVirtualProperty : metadata.getVirtualProperties()) {
                if (parentData != null && parentData.isRecursive(klass, metadataVirtualProperty.getPropertyName()).booleanValue() || !metadataVirtualProperty.hasGroups().booleanValue() || !metadataVirtualProperty.appliesToGroups(Arrays.asList(group)).booleanValue()) continue;
                properties.add(metadataVirtualProperty.getPropertyName());
            }
        }
        return properties.toArray(new String[0]);
    }

    @Override
    public String[] getGroupsByFieldName(Class<?> klass, String fieldName) {
        Metadata metadata = this.getMetadata(klass);
        IMetadataProperty property = metadata.getMixedProperty(fieldName);
        return property.getGroups().toArray(new String[0]);
    }

    @Override
    public Boolean hasAccessType(Class<?> klass) {
        Metadata metadata = this.getMetadata(klass);
        return metadata.hasAccessType();
    }

    @Override
    public FieldAccessType getAccessType(Class<?> klass) {
        Metadata metadata = this.getMetadata(klass);
        return metadata.getAccessType();
    }

    @Override
    public Boolean hasPropertyAccessType(Class<?> klass, String propertyName) {
        Metadata metadata = this.getMetadata(klass);
        IMetadataProperty property = metadata.getMixedProperty(propertyName);
        return property.hasAccessType();
    }

    @Override
    public FieldAccessType getPropertyAccessType(Class<?> klass, String propertyName) {
        Metadata metadata = this.getMetadata(klass);
        IMetadataProperty property = metadata.getMixedProperty(propertyName);
        return property.getAccessType();
    }

    @Override
    public String getPropertyCustomGetterName(Class<?> klass, String propertyName) {
        Metadata metadata = this.getMetadata(klass);
        IMetadataProperty property = metadata.getMixedProperty(propertyName);
        MetadataPropertyAccessor accessor = property.getAccessor();
        if (accessor == null || !accessor.hasGetter().booleanValue()) {
            return null;
        }
        return accessor.getGetter();
    }

    @Override
    public Boolean hasPropertySerializedName(Class<?> klass, String propertyName) {
        Metadata metadata = this.getMetadata(klass);
        IMetadataProperty property = metadata.getMixedProperty(propertyName);
        return property.hasSerializedName();
    }

    @Override
    public String getPropertySerializedName(Class<?> klass, String propertyName) {
        Metadata metadata = this.getMetadata(klass);
        IMetadataProperty property = metadata.getMixedProperty(propertyName);
        return property.getSerializedName();
    }

    @Override
    public Boolean isVirtualProperty(Class<?> klass, String propertyName) {
        Metadata metadata = this.getMetadata(klass);
        IMetadataProperty property = metadata.getMixedProperty(propertyName);
        return property instanceof MetadataVirtualProperty;
    }
}

