/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer;

import es.webbeta.serializer.base.FileUtils;
import es.webbeta.serializer.base.MetadataAccessor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileMetadataAccessor
implements MetadataAccessor {
    private static final String YAML_EXT = ".yaml";
    private static final String YML_EXT = ".yml";
    protected Path metadataPath = null;

    private Path buildPath(Class klass, String extension) {
        return Paths.get(this.metadataPath.toString(), klass.getCanonicalName() + extension);
    }

    private Boolean hasYmlMetadata(Class klass) {
        return Files.exists(this.buildPath(klass, YML_EXT), new LinkOption[0]);
    }

    private Boolean hasYamlMetadata(Class klass) {
        return Files.exists(this.buildPath(klass, YAML_EXT), new LinkOption[0]);
    }

    @Override
    public void setMetadataPath(Path path) {
        this.metadataPath = path;
    }

    @Override
    public Boolean hasMetadata(Class klass) {
        return this.hasYmlMetadata(klass) != false || this.hasYamlMetadata(klass) != false;
    }

    @Override
    public String getMetadataContent(Class klass) {
        String contents = null;
        try {
            if (this.hasYmlMetadata(klass).booleanValue()) {
                contents = FileUtils.getContent(this.buildPath(klass, YML_EXT));
            } else if (this.hasYamlMetadata(klass).booleanValue()) {
                contents = FileUtils.getContent(this.buildPath(klass, YAML_EXT));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return contents;
    }
}

