/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import es.webbeta.serializer.type.FieldFormatterType;

public class FieldFormatter
implements es.webbeta.serializer.base.FieldFormatter {
    private FieldFormatterType formatterType;

    public FieldFormatter(FieldFormatterType type) {
        this.formatterType = type;
    }

    public FieldFormatter(String type) {
        this(FieldFormatterType.fromString(type));
    }

    @Override
    public String format(String name) {
        if (name.contains(" ")) {
            throw new IllegalArgumentException("A field cannot have empty spaces.");
        }
        if (this.formatterType == FieldFormatterType.INHERITED) {
            return name;
        }
        Boolean hasDashOrUnderscore = name.contains("-") || name.contains("_");
        if (hasDashOrUnderscore.booleanValue()) {
            name = name.replace("-", "_");
            name = name.toLowerCase();
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.valueOf((String)this.formatterType.getStringType().toUpperCase()), name);
        }
        name = String.valueOf(Ascii.toLowerCase((char)name.charAt(0))) + name.substring(1);
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.valueOf((String)this.formatterType.getStringType().toUpperCase()), name);
    }
}

