/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer;

import com.google.common.collect.Lists;
import es.webbeta.serializer.base.Logger;
import es.webbeta.serializer.type.FieldAccessType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class FieldAccessor
implements es.webbeta.serializer.base.FieldAccessor {
    private Boolean initialized = false;
    private Class<?> klass;
    private List<Class<?>> klassTree;
    private Object ob;
    private String fieldName;
    private FieldAccessType accessType;
    private Logger logger;
    private Boolean exists = false;
    private Object value = null;
    private Boolean ensureFieldExists = true;
    private String customGetterName;

    public FieldAccessor(Object ob, String fieldName, FieldAccessType accessType) {
        this.ob = ob;
        this.fieldName = fieldName;
        this.accessType = accessType;
        this.klass = ob.getClass();
        this.klassTree = new ArrayList();
        this.klassTree.add(this.klass);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private String[] buildGetterNames(String fieldName) {
        ArrayList<String> names = new ArrayList<String>();
        String firstLetter = fieldName.substring(0, 1);
        names.add("get" + firstLetter.toUpperCase() + fieldName.substring(1));
        names.add("is" + firstLetter.toUpperCase() + fieldName.substring(1));
        return names.toArray(new String[0]);
    }

    private void init() {
        if (this.initialized.booleanValue()) {
            return;
        }
        Class<?> superKlass = this.klass;
        while (superKlass != null && !(superKlass = superKlass.getSuperclass()).getCanonicalName().equals(Object.class.getCanonicalName())) {
            this.klassTree.add(superKlass);
        }
        this.klassTree = Lists.reverse(this.klassTree);
        if (this.accessType == FieldAccessType.PROPERTY) {
            this.buildAsProperty();
        } else if (this.accessType == FieldAccessType.PUBLIC_METHOD) {
            this.buildAsMethod();
        }
        this.initialized = true;
    }

    private void buildAsProperty() {
        for (Class<?> klass : this.klassTree) {
            try {
                Field field = klass.getDeclaredField(this.fieldName);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                this.value = field.get(this.ob);
                this.exists = true;
            }
            catch (IllegalAccessException e) {
                if (this.logger == null) continue;
                this.logger.error(String.format("Serializer cannot serialize field '%s.%s', because it is not public.", klass.getCanonicalName(), this.fieldName));
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
    }

    private void buildAsMethod() {
        if (!Modifier.isPublic(this.klass.getModifiers())) {
            throw new IllegalAccessError("Serializer cannot access \"" + this.klass.getCanonicalName() + "\" class. It can be caused because it has non public access.");
        }
        String[] names = this.customGetterName == null ? this.buildGetterNames(this.fieldName) : new String[]{this.customGetterName};
        for (String name : names) {
            try {
                Method method = this.klass.getMethod(name, new Class[0]);
                this.value = method.invoke(this.ob, new Object[0]);
                this.exists = true;
                break;
            }
            catch (NoSuchMethodException ignored) {
                this.exists = false;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (this.logger == null) continue;
                this.logger.error(String.format("Serializer cannot serialize method '%s.%s', because it %s", this.klass.getCanonicalName(), name, e instanceof IllegalAccessException ? "is not public." : "throw an exception when was called."));
            }
        }
        if (this.ensureFieldExists.booleanValue()) {
            FieldAccessor accessorAsField = new FieldAccessor(this.ob, this.fieldName, FieldAccessType.PROPERTY);
            this.exists = this.exists != false && accessorAsField.exists() != false;
            if (!this.exists.booleanValue()) {
                this.value = null;
            }
        }
    }

    public void setEnsureFieldExists(Boolean ensureFieldExists) {
        this.ensureFieldExists = ensureFieldExists;
    }

    public void setCustomGetterName(String customGetterName) {
        this.customGetterName = customGetterName;
    }

    @Override
    public Boolean exists() {
        this.init();
        return this.exists;
    }

    @Override
    public <T> T get() {
        this.init();
        return (T)this.value;
    }
}

