/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer;

import es.webbeta.serializer.CacheMetadataAccessor;
import es.webbeta.serializer.FileMetadataAccessor;
import es.webbeta.serializer.SerializerYamlMetadataProvider;
import es.webbeta.serializer.base.Cache;
import es.webbeta.serializer.base.ConfigurationProvider;
import es.webbeta.serializer.base.Environment;
import es.webbeta.serializer.base.FieldFormatter;
import es.webbeta.serializer.base.MetadataAccessor;
import es.webbeta.serializer.base.SerializerMetadataProvider;
import es.webbeta.serializer.type.DateFormatType;
import es.webbeta.serializer.type.FieldAccessType;
import es.webbeta.serializer.type.FieldFormatterType;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ConfigurationManager {
    public static final String METADATA_DIR_KEY = "serializer.metadata.dir";
    public static final String INCLUDE_NULL_VALUES_KEY = "serializer.include_null_values";
    public static final String FIELD_FORMATTING_METHOD_KEY = "serializer.field_formatting_method";
    public static final String FIELD_ACCESS_TYPE_KEY = "serializer.access_type";
    public static final String DATE_FORMAT_KEY = "serializer.date_format";
    private Path metadataPath;
    private Boolean includeNullValues;
    private FieldFormatterType formatterType;
    private FieldAccessType accessType;
    private DateFormatType dateFormatType;
    private MetadataAccessor metadataAccessor;

    public ConfigurationManager(ConfigurationProvider conf, Environment environment, Cache cache) {
        this.metadataPath = Paths.get(conf.getString(METADATA_DIR_KEY, "conf/serializer/"), new String[0]);
        this.includeNullValues = conf.getBoolean(INCLUDE_NULL_VALUES_KEY, false);
        this.formatterType = FieldFormatterType.fromString(conf.getString(FIELD_FORMATTING_METHOD_KEY, FieldFormatterType.LOWER_UNDERSCORE.toString()));
        this.accessType = FieldAccessType.fromString(conf.getString(FIELD_ACCESS_TYPE_KEY, FieldAccessType.PROPERTY.toString()));
        this.dateFormatType = DateFormatType.fromString(conf.getString(DATE_FORMAT_KEY, DateFormatType.ISO8601.toString()));
        this.metadataAccessor = environment.isProd() ? new CacheMetadataAccessor(cache) : new FileMetadataAccessor();
        this.metadataAccessor.setMetadataPath(this.metadataPath);
    }

    public Path getMetadataPath() {
        return this.metadataPath;
    }

    public Boolean getIncludeNullValues() {
        return this.includeNullValues;
    }

    public MetadataAccessor getMetadataAccessor() {
        return this.metadataAccessor;
    }

    public SerializerMetadataProvider newMetadataProvider() {
        return new SerializerYamlMetadataProvider(this.metadataAccessor);
    }

    public FieldFormatter getFieldFormatter() {
        return new es.webbeta.serializer.FieldFormatter(this.formatterType);
    }

    public FieldAccessType getAccessType() {
        return this.accessType;
    }

    public DateFormatType getDateFormatType() {
        return this.dateFormatType;
    }
}

