/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta.serializer;

import es.webbeta.serializer.FileMetadataAccessor;
import es.webbeta.serializer.base.Cache;
import es.webbeta.serializer.base.MetadataAccessor;
import java.io.File;

public class CacheMetadataAccessor
extends FileMetadataAccessor
implements MetadataAccessor {
    private static final String KEY_TPL = "serializer_metadata___%s";
    private Cache cache;

    public CacheMetadataAccessor(Cache cache) {
        this.cache = cache;
    }

    private String generateKey(Class<?> klass) {
        return this.generateKey(klass.getCanonicalName());
    }

    private String generateKey(String canonical) {
        return String.format(KEY_TPL, canonical);
    }

    private String getFilenameWithoutExtension(String fileName) {
        if (fileName.indexOf(".") > 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    @Override
    public Boolean hasMetadata(Class klass) {
        return super.hasMetadata(klass);
    }

    @Override
    public String getMetadataContent(Class klass) {
        String key = this.generateKey(klass);
        if (this.cache.get(key) != null) {
            return this.cache.get(key);
        }
        if (super.hasMetadata(klass).booleanValue()) {
            String metadata = super.getMetadataContent(klass);
            this.cache.set(key, metadata);
            return metadata;
        }
        return null;
    }

    public void clearMetadataCache() {
        File dir = this.metadataPath.toFile();
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File fileEntry : files) {
            String canonical;
            String cacheKey;
            if (!fileEntry.isFile() || this.cache.get(cacheKey = this.generateKey(canonical = this.getFilenameWithoutExtension(fileEntry.getName()))) == null) continue;
            this.cache.remove(cacheKey);
        }
    }
}

