/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta;

import es.webbeta.Serializer;
import es.webbeta.serializer.ConfigurationManager;
import es.webbeta.serializer.base.Cache;
import es.webbeta.serializer.base.ConfigurationProvider;
import es.webbeta.serializer.base.Environment;
import es.webbeta.serializer.base.Logger;

public class SerializerBuilder {
    private ConfigurationProvider configurationProvider;
    private Environment environment;
    private Cache cache;
    private Logger logger;

    public static SerializerBuilder build() {
        return new SerializerBuilder();
    }

    public SerializerBuilder withConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
        return this;
    }

    public SerializerBuilder withEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public SerializerBuilder withCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public SerializerBuilder withLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Serializer get() {
        if (this.configurationProvider == null || this.environment == null || this.cache == null) {
            throw new IllegalArgumentException("All services must be settled.");
        }
        ConfigurationManager configurationManager = new ConfigurationManager(this.configurationProvider, this.environment, this.cache);
        Serializer serializer = new Serializer(configurationManager);
        serializer.setLogger(this.logger);
        return serializer;
    }
}

