/*
 * Decompiled with CFR 0.152.
 */
package es.webbeta;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import es.webbeta.serializer.ConfigurationManager;
import es.webbeta.serializer.FieldAccessor;
import es.webbeta.serializer.TypeCallback;
import es.webbeta.serializer.TypeChecker;
import es.webbeta.serializer.base.FieldFormatter;
import es.webbeta.serializer.base.Logger;
import es.webbeta.serializer.base.ParentFieldData;
import es.webbeta.serializer.base.SerializerMetadataProvider;
import es.webbeta.serializer.type.DateFormatType;
import es.webbeta.serializer.type.FieldAccessType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Serializer {
    private final ConfigurationManager configurationManager;
    private SerializerMetadataProvider provider;
    private FieldFormatter formatter;
    private TypeChecker typeChecker;
    private JsonGenerator generator;
    private StringWriter writer;
    private Logger logger;

    Serializer(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        this.formatter = configurationManager.getFieldFormatter();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private Boolean initializeGenerator() {
        this.writer = new StringWriter();
        JsonFactory factory = new JsonFactory();
        this.provider = this.configurationManager.newMetadataProvider();
        this.typeChecker = new TypeChecker(this.provider);
        try {
            this.generator = factory.createGenerator((Writer)this.writer);
            return true;
        }
        catch (IOException e) {
            this.generator = null;
            return false;
        }
    }

    private FieldAccessor buildFieldAccessor(Object ob, String fieldName) {
        Class<?> klass = ob.getClass();
        FieldAccessType accessType = this.configurationManager.getAccessType();
        if (this.provider.hasAccessType(klass).booleanValue()) {
            accessType = this.provider.getAccessType(klass);
        }
        if (this.provider.hasPropertyAccessType(klass, fieldName).booleanValue()) {
            accessType = this.provider.getPropertyAccessType(klass, fieldName);
        }
        String customGetter = this.provider.getPropertyCustomGetterName(klass, fieldName);
        FieldAccessor fieldAccessor = new FieldAccessor(ob, fieldName, accessType);
        fieldAccessor.setCustomGetterName(customGetter);
        if (this.logger != null) {
            fieldAccessor.setLogger(this.logger);
        }
        if (this.provider.isVirtualProperty(klass, fieldName).booleanValue()) {
            fieldAccessor.setEnsureFieldExists(false);
        }
        return fieldAccessor;
    }

    private String getSerializedName(Class<?> klass, String fieldName) {
        String finalFieldName = this.formatter.format(fieldName);
        if (this.provider.hasPropertySerializedName(klass, fieldName).booleanValue()) {
            finalFieldName = this.provider.getPropertySerializedName(klass, fieldName);
        }
        return finalFieldName;
    }

    private void fillDateValue(JsonGenerator gen, Date date) throws IOException {
        if (this.configurationManager.getDateFormatType() == DateFormatType.ISO8601) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            gen.writeString(format.format(date));
        } else if (this.configurationManager.getDateFormatType() == DateFormatType.UNIX_TIMESTAMP) {
            gen.writeNumber(date.getTime());
        }
    }

    private void fillRawValue(final JsonGenerator gen, final ParentFieldData parentFieldData, Object value, final String[] group) throws IOException {
        this.typeChecker.check(value, new TypeCallback(){

            @Override
            public void itsByte(Byte value) throws IOException {
                gen.writeNumber((short)value.byteValue());
            }

            @Override
            public void itsShort(Short value) throws IOException {
                gen.writeNumber(value.shortValue());
            }

            @Override
            public void itsInteger(Integer value) throws IOException {
                gen.writeNumber(value.intValue());
            }

            @Override
            public void itsBigInteger(BigInteger value) throws IOException {
                gen.writeNumber(value);
            }

            @Override
            public void itsLong(Long value) throws IOException {
                gen.writeNumber(value.longValue());
            }

            @Override
            public void itsFloat(Float value) throws IOException {
                gen.writeNumber(value.floatValue());
            }

            @Override
            public void itsDouble(Double value) throws IOException {
                gen.writeNumber(value.doubleValue());
            }

            @Override
            public void itsBigDecimal(BigDecimal value) throws IOException {
                gen.writeNumber(value);
            }

            @Override
            public void itsString(String value) throws IOException {
                gen.writeString(value);
            }

            @Override
            public void itsStringParseable(Object value) throws IOException {
                gen.writeString(value.toString());
            }

            @Override
            public void itsBoolean(Boolean value) throws IOException {
                gen.writeBoolean(value.booleanValue());
            }

            @Override
            public void itsDate(Date value) throws IOException {
                Serializer.this.fillDateValue(gen, value);
            }

            @Override
            public void itsSerializableObject(Object value) throws IOException {
                if (parentFieldData != null && parentFieldData.getKlass() == value.getClass()) {
                    Serializer.this.fillWith(false, gen, parentFieldData, value, parentFieldData.getGroups());
                } else {
                    Serializer.this.fillWith(false, gen, parentFieldData, value, group);
                }
            }

            @Override
            public void itsIterable(Iterable<?> value) throws IOException {
                gen.writeStartArray();
                for (Object arrValue : value) {
                    String[] parentGroups = Serializer.this.provider.getGroupsByFieldName(parentFieldData.getKlass(), parentFieldData.getFieldName());
                    es.webbeta.serializer.ParentFieldData fieldData = new es.webbeta.serializer.ParentFieldData(parentFieldData.getKlass(), parentFieldData.getFieldName(), parentGroups);
                    Serializer.this.fillRawValue(gen, fieldData, arrValue, group);
                }
                gen.writeEndArray();
            }

            @Override
            public void itsMap(Map<?, ?> value) throws IOException {
                gen.writeStartObject();
                for (Map.Entry<?, ?> entry : value.entrySet()) {
                    String[] parentGroups = Serializer.this.provider.getGroupsByFieldName(parentFieldData.getKlass(), parentFieldData.getFieldName());
                    es.webbeta.serializer.ParentFieldData fieldData = new es.webbeta.serializer.ParentFieldData(parentFieldData.getKlass(), parentFieldData.getFieldName(), parentGroups);
                    gen.writeFieldName(entry.getKey().toString());
                    Serializer.this.fillRawValue(gen, fieldData, entry.getValue(), group);
                }
                gen.writeEndObject();
            }
        });
    }

    private void fillWith(Boolean asArray, JsonGenerator gen, ParentFieldData parentData, Object ob, String[] group) throws IOException {
        Class<?> klass = ob.getClass();
        String[] fields = this.provider.getPropertiesByGroup(klass, parentData, group);
        if (asArray.booleanValue()) {
            gen.writeStartArray();
        } else {
            gen.writeStartObject();
        }
        if (this.typeChecker.isSerializableObject(ob).booleanValue()) {
            for (String fieldName : fields) {
                FieldAccessor accessor = this.buildFieldAccessor(ob, fieldName);
                if (accessor.get() == null) {
                    if (!accessor.exists().booleanValue() || !this.configurationManager.getIncludeNullValues().booleanValue()) continue;
                    gen.writeFieldName(this.getSerializedName(klass, fieldName));
                    gen.writeNull();
                    continue;
                }
                if (this.typeChecker.isUnserializableObject(accessor.get()).booleanValue()) continue;
                es.webbeta.serializer.ParentFieldData fieldData = new es.webbeta.serializer.ParentFieldData(klass, fieldName, group);
                gen.writeFieldName(this.getSerializedName(klass, fieldName));
                this.fillRawValue(gen, fieldData, accessor.get(), group);
            }
        } else if (this.typeChecker.isIterable(ob).booleanValue()) {
            for (Object arrValue : (Iterable)ob) {
                es.webbeta.serializer.ParentFieldData fieldData = new es.webbeta.serializer.ParentFieldData(arrValue.getClass(), null, group);
                this.fillRawValue(gen, fieldData, arrValue, group);
            }
        }
        if (asArray.booleanValue()) {
            gen.writeEndArray();
        } else {
            gen.writeEndObject();
        }
    }

    public <T> String serialize(T ob) {
        return this.serialize(ob, new String[0]);
    }

    public <T> String serialize(T ob, String ... group) {
        if (ob == null) {
            return null;
        }
        if (!this.initializeGenerator().booleanValue()) {
            return null;
        }
        try {
            this.fillWith(this.typeChecker.isIterable(ob), this.generator, null, ob, group);
            this.generator.close();
            return this.writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

