/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.transaction;

import es.prodevelop.pui9.exceptions.PuiException;
import es.prodevelop.pui9.transaction.CheckedCallable;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PuiTransactionHandler {
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={PuiException.class})
    public void call(CheckedCallable callable) throws PuiException {
        try {
            callable.call();
        }
        catch (Exception e) {
            throw new PuiException((Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={PuiException.class})
    public <T> T call(Callable<T> callable) throws PuiException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new PuiException((Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={PuiException.class})
    public <T> T get(Supplier<T> supplier) {
        return supplier.get();
    }
}

