/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.model.dao;

import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.eventlistener.ThreadDaoEvents;
import es.prodevelop.pui9.eventlistener.event.DeleteDaoEvent;
import es.prodevelop.pui9.eventlistener.event.InsertDaoEvent;
import es.prodevelop.pui9.eventlistener.event.UpdateDaoEvent;
import es.prodevelop.pui9.exceptions.PuiDaoAttributeLengthException;
import es.prodevelop.pui9.exceptions.PuiDaoDataAccessException;
import es.prodevelop.pui9.exceptions.PuiDaoDeleteException;
import es.prodevelop.pui9.exceptions.PuiDaoDuplicatedException;
import es.prodevelop.pui9.exceptions.PuiDaoFindException;
import es.prodevelop.pui9.exceptions.PuiDaoInsertException;
import es.prodevelop.pui9.exceptions.PuiDaoIntegrityOnDeleteException;
import es.prodevelop.pui9.exceptions.PuiDaoIntegrityOnInsertException;
import es.prodevelop.pui9.exceptions.PuiDaoIntegrityOnUpdateException;
import es.prodevelop.pui9.exceptions.PuiDaoNoNumericColumnException;
import es.prodevelop.pui9.exceptions.PuiDaoNullParametersException;
import es.prodevelop.pui9.exceptions.PuiDaoSaveException;
import es.prodevelop.pui9.exceptions.PuiDaoUpdateException;
import es.prodevelop.pui9.filter.FilterBuilder;
import es.prodevelop.pui9.json.GsonSingleton;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dao.AbstractDatabaseDao;
import es.prodevelop.pui9.model.dao.interfaces.ITableDao;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.model.dto.interfaces.ITableDto;
import es.prodevelop.pui9.utils.IPuiObject;
import es.prodevelop.pui9.utils.PuiConstants;
import es.prodevelop.pui9.utils.PuiLanguage;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import es.prodevelop.pui9.utils.PuiObjectUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.jooq.DeleteConditionStep;
import org.jooq.DeleteUsingStep;
import org.jooq.Field;
import org.jooq.InsertValuesStepN;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.ObjectUtils;

public abstract class AbstractTableDao<TPK extends ITableDto, T extends TPK>
extends AbstractDatabaseDao<T>
implements ITableDao<TPK, T> {
    @Autowired
    private ThreadDaoEvents threadDaoEvents;
    private ITableDao<ITableDto, ITableDto> tableTranslationDao = null;

    @Override
    public boolean exists(TPK dtoPk) throws PuiDaoFindException {
        return this.findOne(dtoPk) != null;
    }

    @Override
    public T findOne(TPK dtoPk) throws PuiDaoFindException {
        return this.findOne(dtoPk, PuiUserSession.getSessionLanguage());
    }

    @Override
    public T findOne(TPK dtoPk, PuiLanguage language) throws PuiDaoFindException {
        if (dtoPk == null) {
            return null;
        }
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        Map mapPk = DtoRegistry.getMapFieldsFromColumnName(this.getDtoPkClass());
        FilterBuilder filterBuilder = FilterBuilder.newAndFilter();
        for (String next : pkColumnNames) {
            try {
                java.lang.reflect.Field pkField = (java.lang.reflect.Field)mapPk.get(next);
                if (pkField == null) {
                    return null;
                }
                Object val = FieldUtils.readField((java.lang.reflect.Field)pkField, dtoPk, (boolean)true);
                if (val == null) {
                    return null;
                }
                if (DtoRegistry.getStringFields((Class)this.dtoClass).contains(next)) {
                    filterBuilder.addEqualsExact(next, val.toString());
                    continue;
                }
                filterBuilder.addEquals(next, val);
            }
            catch (Exception e) {
                return null;
            }
        }
        List list = this.findWhere(filterBuilder, language);
        if (!list.isEmpty()) {
            return (T)((ITableDto)list.get(0));
        }
        return null;
    }

    @Override
    public T insert(T dto) throws PuiDaoInsertException {
        if (dto == null) {
            return null;
        }
        try {
            this.checkValues((ITableDto)dto);
        }
        catch (PuiDaoAttributeLengthException | PuiDaoNullParametersException e) {
            throw new PuiDaoInsertException(e);
        }
        List<T> dtoList = Collections.singletonList(dto);
        try {
            this.setAutoincrementableValues(dtoList);
        }
        catch (PuiDaoNoNumericColumnException e) {
            throw new PuiDaoInsertException(e);
        }
        InsertValuesStepN<Record> insert = this.createInsertStatement();
        try {
            this.doInsert(dtoList, insert);
            this.insertTranslations(dtoList);
            this.afterInsert(dtoList);
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoInsertException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnInsertException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoInsertException(new PuiDaoDataAccessException(e));
        }
        return dto;
    }

    @Override
    public List<T> bulkInsert(List<T> dtoList) throws PuiDaoInsertException {
        if (dtoList == null) {
            return Collections.emptyList();
        }
        try {
            for (ITableDto dto : dtoList) {
                this.checkValues(dto);
            }
        }
        catch (PuiDaoAttributeLengthException | PuiDaoNullParametersException e) {
            throw new PuiDaoInsertException(e);
        }
        try {
            this.setAutoincrementableValues(dtoList);
        }
        catch (PuiDaoNoNumericColumnException e) {
            throw new PuiDaoInsertException(e);
        }
        InsertValuesStepN<Record> insert = this.createInsertStatement();
        try {
            this.doInsert(dtoList, insert);
            this.insertTranslations(dtoList);
            this.afterInsert(dtoList);
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoInsertException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnInsertException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoInsertException(new PuiDaoDataAccessException(e));
        }
        return dtoList;
    }

    private InsertValuesStepN<Record> createInsertStatement() {
        Table table = DSL.table((String)this.getEntityName());
        ArrayList columnNames = new ArrayList(DtoRegistry.getColumnNames((Class)this.dtoClass));
        columnNames.removeAll(DtoRegistry.getSequenceColumns((Class)this.dtoClass));
        List columns = columnNames.stream().map(DSL::field).collect(Collectors.toList());
        List values = columnNames.stream().map(colName -> DSL.field((String)this.getParameterTextForColumnInsert((String)colName))).collect(Collectors.toList());
        InsertValuesStepN insert = this.dbHelper.getDSLContext().insertInto(table).columns(columns).values(values);
        if (this.onInsertConflictDoNothing()) {
            insert.onConflictDoNothing();
        }
        return insert;
    }

    protected String getParameterTextForColumnInsert(String columnName) {
        return this.getParameterForSql(columnName);
    }

    protected boolean onInsertConflictDoNothing() {
        return false;
    }

    protected void doInsert(final List<T> dtoList, final InsertValuesStepN<Record> insertQuery) throws DataAccessException {
        this.checkDataSource();
        final ArrayList columnNames = new ArrayList(DtoRegistry.getColumnNames((Class)this.dtoClass));
        final List sequenceColumns = DtoRegistry.getSequenceColumns((Class)this.dtoClass);
        columnNames.removeAll(sequenceColumns);
        final Map map = DtoRegistry.getMapFieldsFromColumnName((Class)this.dtoClass);
        if (dtoList.size() == 1) {
            final ITableDto dto = (ITableDto)dtoList.get(0);
            GeneratedKeyHolder holder = new GeneratedKeyHolder();
            this.jdbcTemplate.update(new PreparedStatementCreator(){

                public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                    PreparedStatement statement = sequenceColumns.isEmpty() ? con.prepareStatement(insertQuery.getSQL(), 1) : con.prepareStatement(insertQuery.getSQL(), sequenceColumns.toArray(new String[0]));
                    int nextParameter = 1;
                    for (String columnName : columnNames) {
                        Object val;
                        java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(columnName);
                        if (field == null) continue;
                        try {
                            val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        val = AbstractTableDao.this.convertPuiObjectToJsonValue(field, val);
                        val = AbstractTableDao.this.modifyInsertColumnValue(dto, columnName, val);
                        if (val instanceof Instant) {
                            val = Timestamp.from((Instant)val);
                        }
                        statement.setObject(nextParameter++, val);
                    }
                    return statement;
                }
            }, (KeyHolder)holder);
            Map keys = holder.getKeys();
            if (keys == null) {
                return;
            }
            for (String seqCol : sequenceColumns) {
                Number val;
                block15: {
                    val = null;
                    try {
                        if (holder.getKeys() != null && keys.containsKey(seqCol)) {
                            val = keys.get(seqCol);
                        }
                        if (val != null) break block15;
                        val = holder.getKey();
                    }
                    catch (InvalidDataAccessApiUsageException e) {
                        break;
                    }
                }
                if (val == null) continue;
                java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(seqCol);
                if (!field.getType().equals(val.getClass())) {
                    if (Long.class.equals(field.getType())) {
                        val = new Long(val.toString());
                    } else if (Integer.class.equals(field.getType())) {
                        val = new Integer(val.toString());
                    } else if (BigDecimal.class.equals(field.getType())) {
                        val = new BigDecimal(val.toString());
                    }
                }
                try {
                    FieldUtils.writeField((java.lang.reflect.Field)field, (Object)dto, (Object)val, (boolean)true);
                }
                catch (Exception exception) {}
            }
        } else {
            this.jdbcTemplate.batchUpdate(insertQuery.getSQL(), new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ITableDto dto = (ITableDto)dtoList.get(i);
                    int nextParameter = 1;
                    for (String columnName : columnNames) {
                        Object val;
                        java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(columnName);
                        if (field == null) continue;
                        try {
                            val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        val = AbstractTableDao.this.convertPuiObjectToJsonValue(field, val);
                        val = AbstractTableDao.this.modifyInsertColumnValue(dto, columnName, val);
                        if (val instanceof Instant) {
                            val = Timestamp.from((Instant)val);
                        }
                        ps.setObject(nextParameter++, val);
                    }
                }

                public int getBatchSize() {
                    return dtoList.size();
                }
            });
        }
    }

    protected Object modifyInsertColumnValue(T dto, String columnName, Object value) {
        return value;
    }

    private void insertTranslations(List<T> dtoList) throws PuiDaoSaveException {
        if (this.getTableTranslationDao() == null) {
            return;
        }
        Class translationClass = this.getTableTranslationDao().getDtoClass();
        java.lang.reflect.Field langField = DtoRegistry.getJavaFieldFromColumnName(translationClass, (String)"lang");
        java.lang.reflect.Field langStatusField = DtoRegistry.getJavaFieldFromColumnName(translationClass, (String)"lang_status");
        try {
            for (ITableDto dto : dtoList) {
                ITableDto translation = (ITableDto)translationClass.newInstance();
                PuiObjectUtils.copyProperties((Object)translation, (Object)dto);
                FieldUtils.writeField((java.lang.reflect.Field)langStatusField, (Object)translation, (Object)PuiConstants.TRUE_INT, (boolean)true);
                this.getTableTranslationDao().insert(translation);
                String baseLang = (String)langField.get(translation);
                Iterator it = PuiLanguageUtils.getLanguagesIterator();
                while (it.hasNext()) {
                    PuiLanguage lang = (PuiLanguage)it.next();
                    if (lang.getIsocode().equals(baseLang)) continue;
                    translation = (ITableDto)translationClass.newInstance();
                    PuiObjectUtils.copyProperties((Object)translation, (Object)dto);
                    FieldUtils.writeField((java.lang.reflect.Field)langField, (Object)translation, (Object)lang.getIsocode(), (boolean)true);
                    FieldUtils.writeField((java.lang.reflect.Field)langStatusField, (Object)translation, (Object)PuiConstants.FALSE_INT, (boolean)true);
                    this.getTableTranslationDao().insert(translation);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected void afterInsert(List<T> dtoList) {
        dtoList.forEach(dto -> {
            if (this.daoRegistry.getAllTableDaoLang().contains(this.daoRegistry.getDaoFromDto(this.dtoClass))) {
                return;
            }
            this.threadDaoEvents.addEventType(new InsertDaoEvent((ITableDto)dto));
        });
    }

    @Override
    public T update(T dto) throws PuiDaoUpdateException {
        T oldDto;
        if (dto == null) {
            return null;
        }
        PuiLanguage lang = PuiLanguageUtils.getLanguage(dto);
        try {
            oldDto = this.findOne(dto.createPk(), lang);
        }
        catch (PuiDaoFindException e) {
            throw new PuiDaoUpdateException(e);
        }
        try {
            this.checkValues((ITableDto)dto);
        }
        catch (PuiDaoAttributeLengthException | PuiDaoNullParametersException e) {
            throw new PuiDaoUpdateException(e);
        }
        List<T> dtoList = Collections.singletonList(dto);
        UpdateConditionStep<Record> update = this.createUpdateStatement();
        try {
            this.doUpdate(dtoList, update);
            this.updateTranslations(dtoList);
            this.afterUpdate(oldDto, dtoList);
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoUpdateException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnUpdateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoUpdateException(new PuiDaoDataAccessException(e));
        }
        return dto;
    }

    @Override
    public List<T> bulkUpdate(List<T> dtoList) throws PuiDaoUpdateException {
        if (dtoList == null) {
            return Collections.emptyList();
        }
        try {
            for (ITableDto dto : dtoList) {
                this.checkValues(dto);
            }
        }
        catch (PuiDaoAttributeLengthException | PuiDaoNullParametersException e) {
            throw new PuiDaoUpdateException(e);
        }
        UpdateConditionStep<Record> update = this.createUpdateStatement();
        try {
            this.doUpdate(dtoList, update);
            this.updateTranslations(dtoList);
            this.afterUpdate(null, dtoList);
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoUpdateException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnUpdateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoUpdateException(new PuiDaoDataAccessException(e));
        }
        return dtoList;
    }

    private UpdateConditionStep<Record> createUpdateStatement() {
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        ArrayList columnNames = new ArrayList(DtoRegistry.getColumnNames((Class)this.dtoClass));
        columnNames.removeAll(DtoRegistry.getSequenceColumns((Class)this.dtoClass));
        Table table = DSL.table((String)this.getEntityName());
        Map set = columnNames.stream().collect(Collectors.toMap(DSL::field, cn -> DSL.field((String)this.getParameterTextForColumnUpdate((String)cn)), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        List condition = pkColumnNames.stream().map(pkColName -> DSL.row((Field)DSL.field((String)pkColName)).equal(DSL.field((String)"?"))).collect(Collectors.toList());
        return this.dbHelper.getDSLContext().update(table).set(set).where(condition);
    }

    protected String getParameterTextForColumnUpdate(String columnName) {
        return this.getParameterForSql(columnName);
    }

    protected void doUpdate(final List<T> dtoList, UpdateConditionStep<Record> updateQuery) throws DataAccessException {
        this.checkDataSource();
        final List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        final ArrayList columnNames = new ArrayList(DtoRegistry.getColumnNames((Class)this.dtoClass));
        columnNames.removeAll(DtoRegistry.getSequenceColumns((Class)this.dtoClass));
        if (ObjectUtils.isEmpty(columnNames)) {
            return;
        }
        final Map map = DtoRegistry.getMapFieldsFromColumnName((Class)this.dtoClass);
        final Map mapPk = DtoRegistry.getMapFieldsFromColumnName(this.getDtoPkClass());
        if (dtoList.size() == 1) {
            ITableDto dto = (ITableDto)dtoList.get(0);
            ArrayList<Object> values = new ArrayList<Object>();
            for (String columnName : columnNames) {
                Object val;
                java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(columnName);
                if (field == null) continue;
                try {
                    val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                }
                catch (Exception e) {
                    continue;
                }
                val = this.convertPuiObjectToJsonValue(field, val);
                val = this.modifyUpdateColumnValue(dto, columnName, val);
                if (val instanceof Instant) {
                    val = Timestamp.from((Instant)val);
                }
                values.add(val);
            }
            ITableDto dtoPk = dto.createPk();
            for (String pkColumnName : pkColumnNames) {
                Object val;
                java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                if (field == null) continue;
                try {
                    val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                }
                catch (Exception e1) {
                    try {
                        val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                    }
                    catch (Exception e2) {
                        continue;
                    }
                }
                val = this.modifyUpdateColumnValue(dto, pkColumnName, val);
                if (val instanceof Instant) {
                    val = Timestamp.from((Instant)val);
                }
                values.add(val);
            }
            this.jdbcTemplate.update(updateQuery.getSQL(), values.toArray());
        } else {
            this.jdbcTemplate.batchUpdate(updateQuery.getSQL(), new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ITableDto dto = (ITableDto)dtoList.get(i);
                    int nextParameter = 1;
                    for (String columnName : columnNames) {
                        Object val;
                        java.lang.reflect.Field field = (java.lang.reflect.Field)map.get(columnName);
                        if (field == null) continue;
                        try {
                            val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        val = AbstractTableDao.this.convertPuiObjectToJsonValue(field, val);
                        val = AbstractTableDao.this.modifyUpdateColumnValue(dto, columnName, val);
                        if (val instanceof Instant) {
                            val = Timestamp.from((Instant)val);
                        }
                        ps.setObject(nextParameter++, val);
                    }
                    ITableDto dtoPk = dto.createPk();
                    for (String pkColumnName : pkColumnNames) {
                        Object val;
                        java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                        if (field == null) continue;
                        try {
                            val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                        }
                        catch (Exception e1) {
                            try {
                                val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dto, (boolean)true);
                            }
                            catch (Exception e2) {
                                continue;
                            }
                        }
                        val = AbstractTableDao.this.modifyUpdateColumnValue(dto, pkColumnName, val);
                        if (val instanceof Instant) {
                            val = Timestamp.from((Instant)val);
                        }
                        ps.setObject(nextParameter++, val);
                    }
                }

                public int getBatchSize() {
                    return dtoList.size();
                }
            });
        }
    }

    protected Object modifyUpdateColumnValue(T dto, String columnName, Object value) {
        return value;
    }

    private void updateTranslations(List<T> dtoList) throws PuiDaoSaveException {
        if (this.getTableTranslationDao() == null) {
            return;
        }
        Class translationClass = this.getTableTranslationDao().getDtoClass();
        try {
            for (ITableDto dto : dtoList) {
                ITableDto translation = (ITableDto)translationClass.newInstance();
                PuiObjectUtils.copyProperties((Object)translation, (Object)dto);
                this.getTableTranslationDao().update(translation);
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected void afterUpdate(T oldDto, List<T> dtoList) {
        dtoList.forEach(dto -> {
            if (this.daoRegistry.getAllTableDaoLang().contains(this.daoRegistry.getDaoFromDto(this.dtoClass))) {
                return;
            }
            this.threadDaoEvents.addEventType(new UpdateDaoEvent((ITableDto)dto, (ITableDto)oldDto));
        });
    }

    @Override
    public TPK patch(TPK dtoPk, Map<String, Object> fieldValuesMap) throws PuiDaoSaveException {
        Map<String, Object> columnValuesMap = this.convertFieldsToColumns(fieldValuesMap);
        if (columnValuesMap.isEmpty()) {
            return dtoPk;
        }
        List<TPK> dtoPkList = Collections.singletonList(dtoPk);
        UpdateConditionStep<Record> update = this.createPatchStatement(columnValuesMap);
        try {
            this.doPatch(dtoPkList, columnValuesMap, update);
            this.patchTranslations(dtoPkList, fieldValuesMap);
            this.afterPatch(dtoPkList, fieldValuesMap);
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoUpdateException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnUpdateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoUpdateException(new PuiDaoDataAccessException(e));
        }
        return dtoPk;
    }

    @Override
    public void bulkPatch(List<TPK> dtoPkList, Map<String, Object> fieldValuesMap) throws PuiDaoUpdateException {
        if (dtoPkList == null) {
            return;
        }
        Map<String, Object> columnValuesMap = this.convertFieldsToColumns(fieldValuesMap);
        if (columnValuesMap.isEmpty()) {
            return;
        }
        UpdateConditionStep<Record> update = this.createPatchStatement(columnValuesMap);
        try {
            this.doPatch(dtoPkList, columnValuesMap, update);
            this.patchTranslations(dtoPkList, fieldValuesMap);
            this.afterPatch(dtoPkList, fieldValuesMap);
        }
        catch (DuplicateKeyException e) {
            throw new PuiDaoUpdateException(new PuiDaoDuplicatedException());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnUpdateException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoUpdateException(new PuiDaoDataAccessException(e));
        }
    }

    private UpdateConditionStep<Record> createPatchStatement(Map<String, Object> columnValuesMap) {
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        Table table = DSL.table((String)this.getEntityName());
        Map set = columnValuesMap.keySet().stream().collect(Collectors.toMap(DSL::field, cn -> DSL.field((String)this.getParameterTextForColumnUpdate((String)cn)), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        List where = pkColumnNames.stream().map(pkColName -> DSL.row((Field)DSL.field((String)pkColName)).equal(DSL.field((String)"?"))).collect(Collectors.toList());
        return this.dbHelper.getDSLContext().update(table).set(set).where(where);
    }

    protected void doPatch(final List<TPK> dtoPkList, final Map<String, Object> columnValuesMap, UpdateConditionStep<Record> patchQuery) {
        this.checkDataSource();
        final List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        final Map mapPk = DtoRegistry.getMapFieldsFromColumnName(this.getDtoPkClass());
        if (dtoPkList.size() == 1) {
            ITableDto dtoPk = (ITableDto)dtoPkList.get(0);
            ArrayList<Object> values = new ArrayList<Object>();
            for (Map.Entry<String, Object> entry : columnValuesMap.entrySet()) {
                Object val = entry.getValue();
                val = this.convertPuiObjectToJsonValue(DtoRegistry.getJavaFieldFromColumnName((Class)this.dtoClass, (String)entry.getKey()), val);
                val = this.modifyPatchColumnValue(dtoPk, entry.getKey(), val);
                if (val instanceof Instant) {
                    val = Timestamp.from((Instant)val);
                }
                values.add(val);
            }
            for (String string : pkColumnNames) {
                java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(string);
                if (field == null) continue;
                try {
                    Object val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                    val = this.modifyPatchColumnValue(dtoPk, string, val);
                    if (val instanceof Instant) {
                        val = Timestamp.from((Instant)val);
                    }
                    values.add(val);
                }
                catch (Exception exception) {}
            }
            this.jdbcTemplate.update(patchQuery.getSQL(), values.toArray());
        } else {
            this.jdbcTemplate.batchUpdate(patchQuery.getSQL(), new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    int nextParameter = 1;
                    ITableDto dtoPk = (ITableDto)dtoPkList.get(i);
                    for (Map.Entry next : columnValuesMap.entrySet()) {
                        Object val = next.getValue();
                        val = AbstractTableDao.this.convertPuiObjectToJsonValue(DtoRegistry.getJavaFieldFromColumnName((Class)AbstractTableDao.this.dtoClass, (String)((String)next.getKey())), val);
                        val = AbstractTableDao.this.modifyPatchColumnValue(dtoPk, (String)next.getKey(), val);
                        if (val instanceof Instant) {
                            val = Timestamp.from((Instant)val);
                        }
                        ps.setObject(nextParameter++, val);
                    }
                    for (String pkColumnName : pkColumnNames) {
                        java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                        if (field == null) continue;
                        try {
                            Object val = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                            val = AbstractTableDao.this.modifyPatchColumnValue(dtoPk, pkColumnName, val);
                            if (val instanceof Instant) {
                                val = Timestamp.from((Instant)val);
                            }
                            ps.setObject(nextParameter++, val);
                        }
                        catch (Exception exception) {}
                    }
                }

                public int getBatchSize() {
                    return dtoPkList.size();
                }
            });
        }
    }

    protected Object modifyPatchColumnValue(TPK dtoPk, String columnName, Object value) {
        return value;
    }

    private void patchTranslations(List<TPK> dtoPkList, Map<String, Object> fieldValuesMap) throws PuiDaoSaveException {
        if (this.getTableTranslationDao() == null) {
            return;
        }
        Class translationClass = this.getTableTranslationDao().getDtoClass();
        for (ITableDto dtoPk : dtoPkList) {
            ITableDto translation;
            try {
                translation = (ITableDto)translationClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                return;
            }
            PuiObjectUtils.copyProperties((Object)translation, (Object)dtoPk);
            PuiLanguage lang = fieldValuesMap.containsKey("lang") ? new PuiLanguage(fieldValuesMap.get("lang").toString()) : PuiUserSession.getSessionLanguage();
            PuiLanguageUtils.setLanguage((IDto)translation, (PuiLanguage)lang);
            this.getTableTranslationDao().patch(translation.createPk(), fieldValuesMap);
        }
    }

    protected void afterPatch(List<TPK> dtoPkList, Map<String, Object> fieldValuesMap) {
        dtoPkList.forEach(dtoPk -> {
            if (this.daoRegistry.getAllTableDaoLang().contains(this.daoRegistry.getDaoFromDto(this.dtoClass))) {
                return;
            }
            this.threadDaoEvents.addEventType(new UpdateDaoEvent((ITableDto)dtoPk, fieldValuesMap));
        });
    }

    @Override
    public TPK delete(TPK dtoPk) throws PuiDaoDeleteException {
        List<TPK> dtoPkList = Collections.singletonList(dtoPk);
        DeleteConditionStep<Record> delete = this.createDeleteStatement();
        try {
            this.deleteTranslations(dtoPkList);
            this.doDelete(dtoPkList, delete);
            this.afterDelete(dtoPkList);
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnDeleteException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoDeleteException(new PuiDaoDataAccessException(e));
        }
        return dtoPk;
    }

    @Override
    public List<TPK> bulkDelete(List<TPK> dtoPkList) throws PuiDaoDeleteException {
        if (dtoPkList == null) {
            return Collections.emptyList();
        }
        DeleteConditionStep<Record> delete = this.createDeleteStatement();
        try {
            this.deleteTranslations(dtoPkList);
            this.doDelete(dtoPkList, delete);
            this.afterDelete(dtoPkList);
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnDeleteException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoDeleteException(new PuiDaoDataAccessException(e));
        }
        return dtoPkList;
    }

    private DeleteConditionStep<Record> createDeleteStatement() throws DataAccessException {
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        Table table = DSL.table((String)this.getEntityName());
        List where = pkColumnNames.stream().map(pkColName -> DSL.row((Field)DSL.field((String)pkColName)).equal(DSL.field((String)"?"))).collect(Collectors.toList());
        return DSL.delete((Table)table).where(where);
    }

    protected void doDelete(final List<TPK> dtoPkList, DeleteConditionStep<Record> deleteQuery) throws DataAccessException {
        this.checkDataSource();
        final List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        final Map mapPk = DtoRegistry.getMapFieldsFromColumnName(this.getDtoPkClass());
        if (dtoPkList.size() == 1) {
            ITableDto dtoPk = (ITableDto)dtoPkList.get(0);
            ArrayList<Object> values = new ArrayList<Object>();
            for (String pkColumnName : pkColumnNames) {
                java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                if (field == null) continue;
                try {
                    Object value = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                    values.add(value);
                }
                catch (Exception exception) {}
            }
            this.jdbcTemplate.update(deleteQuery.getSQL(), values.toArray());
        } else {
            this.jdbcTemplate.batchUpdate(deleteQuery.getSQL(), new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement ps, int i) throws SQLException {
                    ITableDto dtoPk = (ITableDto)dtoPkList.get(i);
                    int nextParameter = 1;
                    for (String pkColumnName : pkColumnNames) {
                        java.lang.reflect.Field field = (java.lang.reflect.Field)mapPk.get(pkColumnName);
                        if (field == null) continue;
                        try {
                            Object value = FieldUtils.readField((java.lang.reflect.Field)field, (Object)dtoPk, (boolean)true);
                            ps.setObject(nextParameter++, value);
                        }
                        catch (Exception exception) {}
                    }
                }

                public int getBatchSize() {
                    return dtoPkList.size();
                }
            });
        }
    }

    private void deleteTranslations(List<TPK> dtoPkList) throws PuiDaoDeleteException {
        if (this.getTableTranslationDao() == null) {
            return;
        }
        Class<ITableDto> translationClass = this.getTableTranslationDao().getDtoPkClass();
        try {
            FilterBuilder filter = FilterBuilder.newOrFilter();
            for (ITableDto dtoPk : dtoPkList) {
                ITableDto translation = translationClass.newInstance();
                PuiObjectUtils.copyProperties((Object)translation, (Object)dtoPk);
                FilterBuilder pkFilter = FilterBuilder.newAndFilter();
                DtoRegistry.getPkFields(this.getDtoPkClass()).forEach(pkField -> {
                    try {
                        Object value = FieldUtils.readField((java.lang.reflect.Field)DtoRegistry.getJavaFieldFromFieldName(this.getDtoPkClass(), (String)pkField), (Object)dtoPk, (boolean)true);
                        if (DtoRegistry.getStringFields(this.getDtoPkClass()).contains(pkField)) {
                            pkFilter.addEqualsExact(pkField, (String)value);
                        } else {
                            pkFilter.addEquals(pkField, value);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                });
                filter.addGroup(pkFilter);
            }
            this.getTableTranslationDao().deleteWhere(filter);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    protected void afterDelete(List<TPK> dtoPkList) {
        dtoPkList.forEach(dtoPk -> {
            if (this.daoRegistry.getAllTableDaoLang().contains(this.daoRegistry.getDaoFromDto(this.dtoClass))) {
                return;
            }
            this.threadDaoEvents.addEventType(new DeleteDaoEvent((ITableDto)dtoPk));
        });
    }

    @Override
    public void deleteAll() throws PuiDaoDeleteException {
        this.deleteWhere(null);
    }

    @Override
    public void deleteAll(PuiLanguage language) throws PuiDaoDeleteException {
        this.deleteWhere(FilterBuilder.newAndFilter().addEqualsExact("lang", language.getIsocode()));
    }

    @Override
    public void deleteWhere(FilterBuilder filterBuilder) throws PuiDaoDeleteException {
        Table table = DSL.table((String)this.getEntityName());
        DeleteUsingStep delete = DSL.delete((Table)table);
        if (filterBuilder != null) {
            String where = this.dbHelper.processFilters(this.dtoClass, filterBuilder.asFilterGroup(), false);
            delete.where(where);
        }
        this.doDeleteWhere((DeleteUsingStep<Record>)delete);
    }

    protected void doDeleteWhere(DeleteUsingStep<Record> deleteQuery) throws PuiDaoDeleteException {
        this.checkDataSource();
        try {
            this.jdbcTemplate.update(deleteQuery.getSQL());
        }
        catch (DataIntegrityViolationException e) {
            throw new PuiDaoIntegrityOnDeleteException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new PuiDaoDeleteException(new PuiDaoDataAccessException(e));
        }
    }

    @Override
    public ITableDao<ITableDto, ITableDto> getTableTranslationDao() {
        if (this.tableTranslationDao == null && this.daoRegistry.hasLanguageSupport(this)) {
            Class daoLangClass = this.daoRegistry.getDaoFromEntityName(this.daoRegistry.getTableLangName(this), false);
            this.tableTranslationDao = (ITableDao)PuiApplicationContext.getInstance().getBean(daoLangClass);
        }
        return this.tableTranslationDao;
    }

    @Override
    protected void addTranslationJoins(SelectJoinStep<? extends Record> select) {
        List pkColumnNames = DtoRegistry.getColumnNames(this.getDtoPkClass());
        Field[] masterFields = pkColumnNames.stream().map(c -> DSL.field((Name)DSL.unquotedName((String[])new String[]{"t1", c}))).collect(Collectors.toList()).toArray(new Field[0]);
        Field[] relatedFields = pkColumnNames.stream().map(c -> DSL.field((Name)DSL.unquotedName((String[])new String[]{"t2", c}))).collect(Collectors.toList()).toArray(new Field[0]);
        select.leftJoin((TableLike)DSL.table((String)this.daoRegistry.getTableLangName(this)).as(DSL.unquotedName((String)"t2"))).on(DSL.row((Field[])masterFields).equal(relatedFields));
    }

    protected String getParameterForSql(String columnName) {
        java.lang.reflect.Field field = DtoRegistry.getJavaFieldFromColumnName((Class)this.dtoClass, (String)columnName);
        boolean isPuiObject = IPuiObject.class.isAssignableFrom(field.getType());
        boolean isJson = DtoRegistry.getJsonFields((Class)this.dtoClass).contains(columnName);
        if (isPuiObject && isJson) {
            return this.dbHelper.getSqlCastToJson();
        }
        return "?";
    }

    private Object convertPuiObjectToJsonValue(java.lang.reflect.Field field, Object value) {
        if (value == null) {
            return value;
        }
        if (IPuiObject.class.isAssignableFrom(field.getType())) {
            return GsonSingleton.getSingleton().getGson().toJson(value);
        }
        return value;
    }

    @Override
    public Class<? extends ITableDao<TPK, T>> getDaoClass() {
        return super.getDaoClass();
    }

    @Override
    public Class<TPK> getDtoPkClass() {
        if (ITableDto.class.isAssignableFrom(this.dtoClass)) {
            return this.dtoClass.getSuperclass();
        }
        return this.dtoClass;
    }
}

