/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.login;

import es.prodevelop.pui9.components.PuiApplicationContext;
import es.prodevelop.pui9.enums.Pui9KnownClients;
import es.prodevelop.pui9.eventlistener.PuiEventLauncher;
import es.prodevelop.pui9.eventlistener.event.ModifySessionPropertyEvent;
import es.prodevelop.pui9.lang.LanguageThreadLocal;
import es.prodevelop.pui9.login.PasswordValidity;
import es.prodevelop.pui9.login.PuiUserInfo;
import es.prodevelop.pui9.utils.PuiLanguage;
import es.prodevelop.pui9.utils.PuiLanguageUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class PuiUserSession
implements UserDetails,
CredentialsContainer {
    private static final long serialVersionUID = 1L;
    private String usr;
    private String uuid;
    private transient String password;
    private String name;
    private PuiLanguage language;
    private String email;
    private String jwt;
    private Instant creation;
    private Instant expiration;
    private Set<String> profiles = new LinkedHashSet<String>();
    private Boolean persistent = false;
    private Boolean cached = true;
    private String ip;
    private String userAgent;
    private String client;
    private String dateformat;
    private Instant lastLoginTime;
    private String lastLoginIp;
    private PasswordValidity passwordValidity;
    private Boolean use2fa = false;
    private String secret2fa;
    private Integer attemps2fa = 0;
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    @Schema(hidden=true)
    private transient List<PuiUserSessionProfile> fullProfiles = new ArrayList<PuiUserSessionProfile>();
    @Schema(hidden=true)
    private transient List<PuiUserSessionFunctionality> fullFunctionalities = new ArrayList<PuiUserSessionFunctionality>();
    @Schema(hidden=true)
    private transient Set<String> functionalities = new LinkedHashSet<String>();
    @Schema(hidden=true)
    private transient List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
    @Schema(hidden=true)
    private transient Boolean authenticated = false;
    @Schema(hidden=true)
    private transient Boolean disabled = false;
    @Schema(hidden=true)
    private transient Boolean accountExpired = false;
    @Schema(hidden=true)
    private transient Boolean accountLocked = false;
    @Schema(hidden=true)
    private transient Boolean credentialsExpired = false;
    @Schema(hidden=true)
    private transient ZoneId zoneId;
    @Schema(hidden=true)
    private transient Instant lastUse;

    public static PuiUserSession getCurrentSession() {
        return SecurityContextHolder.getContext().getAuthentication() != null ? (PuiUserSession)SecurityContextHolder.getContext().getAuthentication().getPrincipal() : null;
    }

    public static PuiLanguage getSessionLanguage() {
        PuiLanguage sessionLang = PuiUserSession.getCurrentSession() != null ? PuiUserSession.getCurrentSession().getLanguage() : null;
        PuiLanguage threadLang = LanguageThreadLocal.getSingleton().getData();
        PuiLanguage dbDefaultLang = PuiLanguageUtils.getDefaultLanguage();
        PuiLanguage selected = null;
        if (sessionLang != null && PuiLanguageUtils.existLanguage((PuiLanguage)sessionLang)) {
            PuiLanguage puiLanguage = selected = !Objects.equals(sessionLang, threadLang) ? sessionLang : threadLang;
        }
        if (selected == null && threadLang != null && PuiLanguageUtils.existLanguage((PuiLanguage)threadLang)) {
            selected = threadLang;
        }
        if (selected == null && dbDefaultLang != null && PuiLanguageUtils.existLanguage((PuiLanguage)dbDefaultLang)) {
            selected = dbDefaultLang;
        }
        if (selected == null) {
            selected = PuiLanguage.DEFAULT_LANG;
        }
        return selected;
    }

    public static PuiUserSession createNew(String usr) {
        return new PuiUserSession().withUsr(usr);
    }

    private PuiUserSession() {
    }

    public PuiUserSession withUsr(String usr) {
        this.usr = usr;
        return this;
    }

    public PuiUserSession withName(String name) {
        this.name = name;
        return this;
    }

    public PuiUserSession withPassword(String password) {
        this.password = password;
        return this;
    }

    public PuiUserSession withLanguage(PuiLanguage language) {
        this.language = language;
        return this;
    }

    public PuiUserSession withEmail(String email) {
        this.email = email;
        return this;
    }

    public PuiUserSession withDateFormat(String dateformat) {
        this.dateformat = dateformat;
        return this;
    }

    public PuiUserSession withDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public PuiUserSession withAccountExpired(Boolean accountExpired) {
        this.accountExpired = accountExpired;
        return this;
    }

    public PuiUserSession withAccountLocked(Boolean accountLocked) {
        this.accountLocked = accountLocked;
        return this;
    }

    public PuiUserSession withCredentialsExpired(Boolean credentialsExpired) {
        this.credentialsExpired = credentialsExpired;
        return this;
    }

    public PuiUserSession withLastLoginTime(Instant lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
        return this;
    }

    public PuiUserSession withLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
        return this;
    }

    public PuiUserSession withPasswordValidity(PasswordValidity passwordValidity) {
        this.passwordValidity = passwordValidity;
        return this;
    }

    public PuiUserSession withUse2fa(Boolean use2fa) {
        this.use2fa = use2fa;
        return this;
    }

    public PuiUserSession withSecret2fa(String secret2fa) {
        this.secret2fa = secret2fa;
        return this;
    }

    public PuiUserSession withAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    public PuiUserSession withCached(Boolean cached) {
        this.cached = cached;
        return this;
    }

    public PuiUserSession withCreation(Instant creation) {
        this.creation = creation;
        return this;
    }

    public PuiUserSession withUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public PuiUserSession withJwt(String jwt) {
        this.jwt = jwt;
        return this;
    }

    public PuiUserSession withPersistent(Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public PuiUserSession withExpiration(Instant expiration) {
        this.expiration = expiration;
        return this;
    }

    public PuiUserSession withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public PuiUserSession withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public PuiUserSession withClient(String client) {
        this.client = client;
        return this;
    }

    public PuiUserSession withZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public PuiUserSession withLastUse(Instant lastUse) {
        this.lastUse = lastUse;
        return this;
    }

    public PuiUserSession withProperty(String property, Object value) {
        Object oldValue = this.properties.put(property, value);
        PuiApplicationContext.getInstance().getBean(PuiEventLauncher.class).fireSync(new ModifySessionPropertyEvent(property, oldValue, value));
        return this;
    }

    public String getUsr() {
        return this.usr;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean isPersistent() {
        return this.persistent;
    }

    public PuiLanguage getLanguage() {
        return this.language;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDateformat() {
        return this.dateformat;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    public List<PuiUserSessionProfile> getFullProfiles() {
        return this.fullProfiles;
    }

    public void setFullProfiles(List<PuiUserSessionProfile> profiles) {
        Collections.sort(profiles);
        this.fullProfiles.clear();
        this.fullProfiles.addAll(profiles);
        this.setProfiles(profiles);
    }

    public List<PuiUserSessionFunctionality> getFullFunctionalities() {
        return this.fullFunctionalities;
    }

    public void setFullFunctionalities(List<PuiUserSessionFunctionality> functionalities) {
        Collections.sort(functionalities);
        this.fullFunctionalities.clear();
        this.fullFunctionalities.addAll(functionalities);
        this.setFunctionalities(functionalities);
    }

    public Set<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<PuiUserSessionProfile> profiles) {
        Collections.sort(profiles);
        this.profiles.clear();
        profiles.forEach(p -> this.profiles.add(p.getProfile()));
    }

    public Set<String> getFunctionalities() {
        return this.functionalities;
    }

    public void setFunctionalities(List<PuiUserSessionFunctionality> functionalities) {
        Collections.sort(functionalities);
        this.functionalities.clear();
        this.authorities.clear();
        functionalities.forEach(f -> {
            if (!this.functionalities.contains(f.getFunctionality())) {
                this.functionalities.add(f.getFunctionality());
                this.authorities.add((GrantedAuthority)new SimpleGrantedAuthority(f.getFunctionality()));
            }
        });
    }

    public String getJwt() {
        return this.jwt;
    }

    public Instant getCreation() {
        return this.creation;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClient() {
        return this.client;
    }

    public ZoneId getZoneId() {
        return this.zoneId != null ? this.zoneId : ZoneId.systemDefault();
    }

    public Instant getLastUse() {
        return this.lastUse;
    }

    public String getUsername() {
        return this.getUsr();
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isAccountNonExpired() {
        return this.accountExpired == false;
    }

    public boolean isAccountNonLocked() {
        return this.accountLocked == false;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsExpired == false;
    }

    public boolean isEnabled() {
        return this.disabled == false;
    }

    public void eraseCredentials() {
        this.password = null;
        this.authorities.clear();
    }

    public Instant getLastLoginTime() {
        return this.lastLoginTime;
    }

    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public PasswordValidity getPasswordValidity() {
        return this.passwordValidity;
    }

    public Boolean isUse2fa() {
        return this.use2fa;
    }

    public String getSecret2fa() {
        return this.secret2fa;
    }

    public void incrementAttempts2fa() {
        Integer n = this.attemps2fa;
        Integer n2 = this.attemps2fa = Integer.valueOf(this.attemps2fa + 1);
    }

    public Integer getAttemps2fa() {
        return this.attemps2fa;
    }

    public Boolean isAuthenticated() {
        return this.authenticated;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T getProperty(String property) {
        return (T)this.properties.get(property);
    }

    public Boolean isCached() {
        return this.cached;
    }

    public Boolean isPui9Client() {
        return Objects.equals(this.client, Pui9KnownClients.PUI9_CLIENT.name());
    }

    public PuiUserInfo asPuiUserInfo() {
        PuiUserInfo userInfo = PuiUserInfo.forUser(this.getUsr()).withName(this.getName()).withLanguage(this.getLanguage().getIsocode()).withEmail(this.getEmail()).withDateFormat(this.getDateformat()).withJwt("Bearer " + this.getJwt()).withUuid(this.getUuid()).withLastLoginTime(this.getLastLoginTime()).withLastLoginIp(this.getLastLoginIp()).withPasswordValidity(this.getPasswordValidity()).withProfiles(this.getProfiles()).withFunctionalities(this.getFunctionalities()).with2fa(this.isUse2fa());
        this.getProperties().forEach(userInfo::addProperty);
        return userInfo;
    }

    public static class PuiUserSessionFunctionality
    implements Comparable<PuiUserSessionFunctionality> {
        private String profile;
        private String functionality;

        public static PuiUserSessionFunctionality of(String functionality) {
            return new PuiUserSessionFunctionality(functionality);
        }

        public static PuiUserSessionFunctionality of(String profile, String functionality) {
            return new PuiUserSessionFunctionality(profile, functionality);
        }

        private PuiUserSessionFunctionality(String functionality) {
            this("NO_PROFILE_INFO", functionality);
        }

        private PuiUserSessionFunctionality(String profile, String functionality) {
            this.profile = profile;
            this.functionality = functionality;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getFunctionality() {
            return this.functionality;
        }

        public String toString() {
            return this.functionality + " (" + this.profile + ")";
        }

        @Override
        public int compareTo(PuiUserSessionFunctionality o) {
            return this.functionality.compareTo(o.getFunctionality());
        }
    }

    public static class PuiUserSessionProfile
    implements Comparable<PuiUserSessionProfile> {
        private String profile;

        public static PuiUserSessionProfile of(String profile) {
            return new PuiUserSessionProfile(profile);
        }

        private PuiUserSessionProfile(String profile) {
            this.profile = profile;
        }

        public String getProfile() {
            return this.profile;
        }

        public String toString() {
            return this.profile;
        }

        @Override
        public int compareTo(PuiUserSessionProfile o) {
            return this.profile.compareTo(o.getProfile());
        }
    }
}

