/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.eventlistener;

import es.prodevelop.pui9.eventlistener.PuiEventLauncher;
import es.prodevelop.pui9.eventlistener.event.AbstractDaoEvent;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThreadDaoEvents {
    private static final AtomicLong seq = new AtomicLong(0L);
    private ThreadLocal<PriorityBlockingQueue<OrderedEvent>> threadLocal = new ThreadLocal();
    @Autowired
    private PuiEventLauncher eventLauncher;

    private ThreadDaoEvents() {
    }

    public void initialize() {
        if (this.threadLocal.get() == null) {
            this.threadLocal.set(new PriorityBlockingQueue());
        }
    }

    public void addEventType(AbstractDaoEvent<?> eventType) {
        if (this.threadLocal.get() == null) {
            return;
        }
        this.threadLocal.get().put(new OrderedEvent(eventType));
    }

    public void process(Long transactionId) {
        if (this.threadLocal.get() == null) {
            return;
        }
        PriorityBlockingQueue<OrderedEvent> queue = this.threadLocal.get();
        if (queue.isEmpty()) {
            this.remove();
            return;
        }
        try {
            while (!queue.isEmpty()) {
                OrderedEvent threadEvent = queue.take();
                threadEvent.event.setTransactionId(transactionId);
                this.eventLauncher.fireSync(threadEvent.event);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.remove();
    }

    public void remove() {
        if (this.threadLocal.get() == null) {
            return;
        }
        this.threadLocal.remove();
    }

    static /* synthetic */ AtomicLong access$100() {
        return seq;
    }

    private class OrderedEvent
    implements Comparable<OrderedEvent> {
        private final long seqNum = ThreadDaoEvents.access$100().getAndIncrement();
        private AbstractDaoEvent<?> event;

        public OrderedEvent(AbstractDaoEvent<?> event) {
            this.event = event;
        }

        @Override
        public int compareTo(OrderedEvent o) {
            return this.seqNum < o.seqNum ? -1 : 1;
        }

        public String toString() {
            return this.seqNum + " :: " + ((Object)this.event).getClass().getSimpleName() + " :: " + this.event.getSource();
        }
    }
}

