/*
 * Decompiled with CFR 0.152.
 */
package es.prodevelop.pui9.db.helpers;

import es.prodevelop.pui9.db.helpers.IDatabaseHelper;
import es.prodevelop.pui9.filter.AbstractFilterRule;
import es.prodevelop.pui9.filter.FilterGroup;
import es.prodevelop.pui9.filter.rules.AbstractBetweenRule;
import es.prodevelop.pui9.filter.rules.AbstractInRule;
import es.prodevelop.pui9.filter.rules.BeginWithRule;
import es.prodevelop.pui9.filter.rules.BetweenRule;
import es.prodevelop.pui9.filter.rules.BoundingBoxRule;
import es.prodevelop.pui9.filter.rules.ContainsRule;
import es.prodevelop.pui9.filter.rules.EndsWithRule;
import es.prodevelop.pui9.filter.rules.EqualsRule;
import es.prodevelop.pui9.filter.rules.GreaterEqualsThanRule;
import es.prodevelop.pui9.filter.rules.GreaterThanRule;
import es.prodevelop.pui9.filter.rules.InRule;
import es.prodevelop.pui9.filter.rules.IntersectsByPointRule;
import es.prodevelop.pui9.filter.rules.IsNotNullRule;
import es.prodevelop.pui9.filter.rules.IsNullRule;
import es.prodevelop.pui9.filter.rules.LowerEqualsThanRule;
import es.prodevelop.pui9.filter.rules.LowerThanRule;
import es.prodevelop.pui9.filter.rules.NotBeginWithRule;
import es.prodevelop.pui9.filter.rules.NotBetweenRule;
import es.prodevelop.pui9.filter.rules.NotContainsRule;
import es.prodevelop.pui9.filter.rules.NotEndsWithRule;
import es.prodevelop.pui9.filter.rules.NotEqualsRule;
import es.prodevelop.pui9.filter.rules.NotInRule;
import es.prodevelop.pui9.login.PuiUserSession;
import es.prodevelop.pui9.model.dao.registry.DaoRegistry;
import es.prodevelop.pui9.model.dto.DtoRegistry;
import es.prodevelop.pui9.model.dto.interfaces.IDto;
import es.prodevelop.pui9.model.dto.interfaces.ITableDto;
import es.prodevelop.pui9.utils.PuiDateUtil;
import java.lang.reflect.Field;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public abstract class AbstractDatabaseHelper
implements IDatabaseHelper {
    private static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    protected static final String DATE_FORMAT = "{DATE_FORMAT}";
    protected static final String COLUMNNAME = "_columnname_";
    protected static final String TIMEZONE = "_timezone_";
    protected static final String OP = "_op_";
    protected static final String VALUE = "_value_";
    protected static final String BEGINNING = "_beginning_";
    protected static final String END = "_end_";
    protected static final String AND = " AND ";
    @Autowired
    private DaoRegistry daoRegistry;
    private DSLContext dslContext;

    @Override
    public final DSLContext getDSLContext() {
        if (this.dslContext == null) {
            this.dslContext = this.initializeDSLContext();
        }
        return this.dslContext;
    }

    protected abstract DSLContext initializeDSLContext();

    @Override
    public String processSearchText(Class<? extends IDto> dtoClass, List<String> fields, String text, ZoneId zoneId) {
        LinkedHashMap<String, String> fieldTextMap = new LinkedHashMap<String, String>();
        fields.forEach(field -> fieldTextMap.put((String)field, text));
        return this.processSearchText(dtoClass, fieldTextMap, zoneId);
    }

    @Override
    public String processSearchText(Class<? extends IDto> dtoClass, Map<String, String> fieldTextMap, ZoneId zoneId) {
        FilterGroup group = FilterGroup.orGroup();
        for (Map.Entry<String, String> next : fieldTextMap.entrySet()) {
            String field = next.getKey();
            String text = next.getValue();
            if (ObjectUtils.isEmpty((Object)field) || ObjectUtils.isEmpty((Object)text)) continue;
            ContainsRule rule = ContainsRule.of((String)field, (String)(text = text.replace("'", "''").replace("%", "")));
            if (rule.isDate(dtoClass)) {
                rule.withZoneId(zoneId);
            } else if (rule.isBoolean(dtoClass) && (text.equalsIgnoreCase(Boolean.TRUE.toString()) || text.equalsIgnoreCase(Boolean.FALSE.toString()))) {
                rule = EqualsRule.of((String)field, (Object)Boolean.valueOf(text));
            }
            group.addRule((AbstractFilterRule)rule);
        }
        return this.processFilters(dtoClass, group, true);
    }

    @Override
    public String processFilters(Class<? extends IDto> dtoClass, FilterGroup filters, boolean addAlias) {
        if (filters == null) {
            return null;
        }
        ArrayList<String> ruleList = new ArrayList<String>();
        ArrayList<String> filterList = new ArrayList<String>();
        for (AbstractFilterRule rule : filters.getRules()) {
            String r = this.processRule(dtoClass, rule, addAlias);
            if (r == null) continue;
            ruleList.add(r);
        }
        for (FilterGroup filter : filters.getGroups()) {
            String f = this.processFilters(dtoClass, filter, addAlias);
            if (f == null) continue;
            filterList.add(f);
        }
        StringBuilder sb = new StringBuilder();
        if (!ruleList.isEmpty()) {
            sb.append("(");
        }
        Iterator it = ruleList.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(" " + filters.getGroupOp() + " ");
        }
        if (!ruleList.isEmpty()) {
            sb.append(")");
        }
        if (!filterList.isEmpty()) {
            if (!ruleList.isEmpty()) {
                sb.append(" " + filters.getGroupOp());
            }
            sb.append(" (");
        }
        it = filterList.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(" " + filters.getGroupOp() + " ");
        }
        if (!filterList.isEmpty()) {
            sb.append(")");
        }
        if (ObjectUtils.isEmpty((Object)sb.toString())) {
            return null;
        }
        return sb.toString();
    }

    private String processRule(Class<? extends IDto> dtoClass, AbstractFilterRule rule, boolean addAlias) {
        AbstractBetweenRule r;
        if (rule == null) {
            return null;
        }
        Field field = DtoRegistry.getJavaFieldFromAllFields(dtoClass, (String)rule.getField());
        if (field == null) {
            return null;
        }
        boolean hasLangSupport = ITableDto.class.isAssignableFrom(dtoClass) && this.daoRegistry.hasLanguageSupport(this.daoRegistry.getDaoFromDto(dtoClass));
        String sqlColumn = rule.getField();
        if (!DtoRegistry.getColumnNames(dtoClass).contains(sqlColumn)) {
            sqlColumn = DtoRegistry.getColumnNameFromFieldName(dtoClass, (String)sqlColumn);
        }
        sqlColumn = hasLangSupport && rule.getField().equalsIgnoreCase("lang") ? (addAlias ? "t2." : "") + sqlColumn : (addAlias ? "t1." : "") + sqlColumn;
        String sqlTextValue = this.valueAsSqlString(rule.getData());
        Instant instantValue = rule.valueAsInstant();
        Number numberValue = rule.valueAsNumber();
        Boolean boolValue = rule.valueAsBoolean();
        boolean isLargeStringField = rule.isLargeStringField(dtoClass);
        if (sqlTextValue == null && instantValue == null && numberValue == null && boolValue == null) {
            if (rule instanceof EqualsRule) {
                rule = IsNullRule.of((String)rule.getField());
            } else if (rule instanceof NotEqualsRule) {
                rule = IsNotNullRule.of((String)rule.getField());
            }
        }
        StringBuilder sqlBuilder = new StringBuilder();
        if (rule instanceof EqualsRule || rule instanceof NotEqualsRule) {
            if (rule.isDataIsColumn().booleanValue()) {
                sqlBuilder.append(this.getSqlTextOperation(sqlColumn, true, false, rule.getSqlOp(), sqlTextValue, false, false, true));
            } else if (rule.isString(dtoClass)) {
                sqlBuilder.append(this.getSqlTextOperation(sqlColumn, rule.isCaseSensitiveAndAccents(), isLargeStringField, rule.getSqlOp(), sqlTextValue, false, false, false));
            } else if (rule.isNumber(dtoClass) || rule.isFloatingNumber(dtoClass) && numberValue != null) {
                sqlBuilder.append(sqlColumn + rule.getSqlOp() + numberValue);
            } else if (rule.isDate(dtoClass) && instantValue != null) {
                sqlBuilder.append(sqlColumn + rule.getSqlOp() + this.getSqlDateOperation(instantValue));
            } else if (rule.isBoolean(dtoClass) && boolValue != null) {
                sqlBuilder.append(sqlColumn + rule.getSqlOp() + boolValue);
            }
        } else if (rule instanceof BeginWithRule || rule instanceof NotBeginWithRule) {
            if (rule.isString(dtoClass)) {
                sqlBuilder.append(this.getSqlTextOperation(sqlColumn, rule.isCaseSensitiveAndAccents(), isLargeStringField, rule.getSqlOp(), sqlTextValue, false, true, rule.isDataIsColumn()));
            }
        } else if (rule instanceof EndsWithRule || rule instanceof NotEndsWithRule) {
            if (rule.isString(dtoClass)) {
                sqlBuilder.append(this.getSqlTextOperation(sqlColumn, rule.isCaseSensitiveAndAccents(), isLargeStringField, rule.getSqlOp(), sqlTextValue, true, false, rule.isDataIsColumn()));
            }
        } else if (rule instanceof ContainsRule || rule instanceof NotContainsRule) {
            if (rule.isString(dtoClass)) {
                sqlBuilder.append(this.getSqlTextOperation(sqlColumn, rule.isCaseSensitiveAndAccents(), isLargeStringField, rule.getSqlOp(), sqlTextValue, true, true, rule.isDataIsColumn()));
            } else if (rule.isNumber(dtoClass) || rule.isFloatingNumber(dtoClass) || rule.isBoolean(dtoClass)) {
                sqlBuilder.append(this.getSqlCastOperationAsString(sqlColumn, rule.getSqlOp(), sqlTextValue, true, true));
            } else if (rule.isDate(dtoClass)) {
                sqlTextValue = sqlTextValue != null ? sqlTextValue.replace("/", "-").replace(".", "-") : "";
                sqlBuilder.append(this.getSqlDateOperationAsString(sqlColumn, rule.getSqlOp(), sqlTextValue, rule.getZoneId()));
            }
        } else if (rule instanceof LowerThanRule || rule instanceof LowerEqualsThanRule || rule instanceof GreaterThanRule || rule instanceof GreaterEqualsThanRule) {
            if (rule.isDataIsColumn().booleanValue()) {
                sqlBuilder.append(sqlColumn + rule.getSqlOp() + sqlTextValue);
            } else if (rule.isNumber(dtoClass) || rule.isFloatingNumber(dtoClass) && numberValue != null) {
                sqlBuilder.append(sqlColumn + rule.getSqlOp() + numberValue);
            } else if (rule.isDate(dtoClass) && instantValue != null) {
                sqlBuilder.append(sqlColumn + rule.getSqlOp() + this.getSqlDateOperation(instantValue));
            } else if (rule.isString(dtoClass)) {
                sqlBuilder.append(this.getSqlTextOperation(sqlColumn, true, false, rule.getSqlOp(), sqlTextValue, false, false, false));
            }
        } else if (rule instanceof BetweenRule || rule instanceof NotBetweenRule) {
            r = (AbstractBetweenRule)rule;
            if (!r.isDataIsColumn().booleanValue()) {
                Object lower = null;
                Object upper = null;
                if (rule.isNumber(dtoClass) || rule.isFloatingNumber(dtoClass)) {
                    lower = r.getLower();
                    upper = r.getUpper();
                } else if (rule.isDate(dtoClass) && r.getLower() instanceof Instant && r.getUpper() instanceof Instant) {
                    lower = this.getSqlDateOperation((Instant)r.getLower());
                    upper = this.getSqlDateOperation((Instant)r.getUpper());
                }
                if (lower != null && upper != null) {
                    sqlBuilder.append(sqlColumn + r.getSqlOp() + lower + AND + upper);
                }
            } else {
                Object value = null;
                String left = (String)r.getLower();
                if (!DtoRegistry.getAllColumnNames(dtoClass).contains(left)) {
                    left = DtoRegistry.getColumnNameFromFieldName(dtoClass, (String)left);
                }
                String right = (String)r.getUpper();
                if (!DtoRegistry.getAllColumnNames(dtoClass).contains(right)) {
                    right = DtoRegistry.getColumnNameFromFieldName(dtoClass, (String)right);
                }
                if (rule.isNumber(dtoClass) || rule.isFloatingNumber(dtoClass)) {
                    value = r.getValue();
                } else if (rule.isDate(dtoClass) && r.getValue() instanceof Instant) {
                    value = this.getSqlDateOperation((Instant)r.getValue());
                }
                if (value != null && !ObjectUtils.isEmpty((Object)left) && !ObjectUtils.isEmpty((Object)right)) {
                    sqlBuilder.append(value + r.getSqlOp() + left + AND + right);
                }
            }
        } else if (rule instanceof InRule || rule instanceof NotInRule) {
            r = (AbstractInRule)rule;
            sqlBuilder.append(sqlColumn + r.getSqlOp() + " (");
            Iterator it = r.getCollection().iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (rule.isString(dtoClass)) {
                    String strVal = (String)next;
                    if (strVal.startsWith("'") && strVal.endsWith("'")) {
                        sqlBuilder.append(strVal);
                    } else {
                        sqlBuilder.append("'" + strVal + "'");
                    }
                } else if (rule.isNumber(dtoClass) || rule.isFloatingNumber(dtoClass)) {
                    sqlBuilder.append(next);
                }
                if (!it.hasNext()) continue;
                sqlBuilder.append(",");
            }
            sqlBuilder.append(")");
        } else if (rule instanceof IsNullRule || rule instanceof IsNotNullRule) {
            sqlBuilder.append(sqlColumn + rule.getSqlOp());
        } else if (rule instanceof BoundingBoxRule) {
            r = (BoundingBoxRule)rule;
            sqlBuilder.append(this.getBoundingBoxSql(r.getField(), r.getSrid(), r.getXmin(), r.getYmin(), r.getXmax(), r.getYmax()));
        } else if (rule instanceof IntersectsByPointRule) {
            r = (IntersectsByPointRule)rule;
            sqlBuilder.append(this.getIntersectsByPoint(r.getField(), r.getSrid(), r.getX(), r.getY()));
        }
        String sql = sqlBuilder.toString();
        return ObjectUtils.isEmpty((Object)sql) ? null : sql;
    }

    private String valueAsSqlString(Object value) {
        String text;
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            text = (String)value;
            if (ObjectUtils.isEmpty((Object)text)) {
                return "";
            }
            if (text.contains("'")) {
                text = text.replace("'", "''");
            }
        } else {
            text = value.toString();
        }
        return text;
    }

    protected abstract String getBoundingBoxSql(String var1, Integer var2, Double var3, Double var4, Double var5, Double var6);

    protected abstract String getIntersectsByPoint(String var1, Integer var2, Double var3, Double var4);

    private String getSqlCastOperationAsString(String column, String operation, String value, boolean beginning, boolean end) {
        return this.getSqlCastToString().replace(COLUMNNAME, column) + operation + (beginning ? "'%" : "'") + value + (end ? "%'" : "'");
    }

    protected abstract String getSqlCastToString();

    private String getSqlDateOperationAsString(String column, String operation, String value, ZoneId zoneId) {
        return this.getSqlConvertDateIntoString(zoneId).replace(COLUMNNAME, column).replace(TIMEZONE, zoneId.getId()) + operation + "'%" + value + "%'";
    }

    protected abstract String getSqlConvertDateIntoString(ZoneId var1);

    private String getSqlDateOperation(Instant instant) {
        if (instant == null) {
            return "''";
        }
        boolean hasMillis = instant.get(ChronoField.MILLI_OF_SECOND) != 0;
        return this.getSqlConvertStringIntoDate(hasMillis).replace(VALUE, PuiDateUtil.temporalAccessorToString((TemporalAccessor)instant, (DateTimeFormatter)DateTimeFormatter.ofPattern(hasMillis ? "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'" : "yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneId.systemDefault())));
    }

    protected abstract String getSqlConvertStringIntoDate(boolean var1);

    private String getSqlTextOperation(String column, boolean caseSensitiveAndAccents, boolean isLargeStringField, String operation, String value, boolean beginning, boolean end, boolean dataIsColumn) {
        return this.getSqlTextOperation(caseSensitiveAndAccents, isLargeStringField, dataIsColumn).replace(COLUMNNAME, column).replace(OP, operation).replace(VALUE, caseSensitiveAndAccents ? value : value.toLowerCase()).replace(BEGINNING, beginning ? "%" : "").replace(END, end ? "%" : "");
    }

    protected abstract String getSqlTextOperation(boolean var1, boolean var2, boolean var3);

    protected String adaptDateFormatToUser(String baseDateFormat) {
        String dateFormat = DEFAULT_DATE_FORMAT;
        if (PuiUserSession.getCurrentSession() != null) {
            dateFormat = PuiUserSession.getCurrentSession().getDateformat();
        }
        return baseDateFormat.replace(DATE_FORMAT, dateFormat).replace("/", "-").replace(".", "-");
    }
}

