/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.utils;

import android.graphics.Bitmap;
import android.view.View;
import com.sdk.getidlib.utils.RectF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001c\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0014\u0010\r\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u00a8\u0006\u000e"}, d2={"getRectFromView", "Lcom/sdk/getidlib/utils/RectF;", "targetFrame", "Landroid/view/View;", "getExtendedRect", "multiplier", "", "getTransformedRect", "ratioX", "ratioY", "matchBitmap", "target", "Landroid/graphics/Bitmap;", "matchRect", "getidlib_release"})
public final class RectUtilsKt {
    @NotNull
    public static final RectF getRectFromView(@NotNull View targetFrame) {
        Intrinsics.checkNotNullParameter((Object)targetFrame, (String)"targetFrame");
        return new RectF(targetFrame.getX(), targetFrame.getY(), targetFrame.getX() + (float)targetFrame.getWidth(), targetFrame.getY() + (float)targetFrame.getHeight());
    }

    @NotNull
    public static final RectF getExtendedRect(@NotNull RectF $this$getExtendedRect, float multiplier) {
        Intrinsics.checkNotNullParameter((Object)$this$getExtendedRect, (String)"<this>");
        float newWidth = $this$getExtendedRect.width() * multiplier;
        float newHeight = $this$getExtendedRect.height() * multiplier;
        float deltaX = (newWidth - $this$getExtendedRect.width()) / (float)2;
        float x = $this$getExtendedRect.getLeft() - deltaX;
        float deltaY = (newHeight - $this$getExtendedRect.height()) / (float)2;
        float y = $this$getExtendedRect.getTop() - deltaY;
        if (x < 0.0f) {
            x = 0.0f;
        }
        if (y < 0.0f) {
            y = 0.0f;
        }
        return new RectF(x, y, $this$getExtendedRect.getRight() + deltaX, $this$getExtendedRect.getBottom() + deltaY);
    }

    @NotNull
    public static final RectF getTransformedRect(@NotNull RectF $this$getTransformedRect, float ratioX, float ratioY) {
        Intrinsics.checkNotNullParameter((Object)$this$getTransformedRect, (String)"<this>");
        return new RectF($this$getTransformedRect.getLeft() * ratioX, $this$getTransformedRect.getTop() * ratioY, $this$getTransformedRect.getRight() * ratioX, $this$getTransformedRect.getBottom() * ratioY);
    }

    @NotNull
    public static final RectF matchBitmap(@NotNull RectF $this$matchBitmap, @NotNull Bitmap target) {
        Intrinsics.checkNotNullParameter((Object)$this$matchBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        RectF r = new RectF(0.0f, 0.0f, target.getWidth(), target.getHeight());
        return RectUtilsKt.matchRect($this$matchBitmap, r);
    }

    @NotNull
    public static final RectF matchRect(@NotNull RectF $this$matchRect, @NotNull RectF target) {
        float b;
        Intrinsics.checkNotNullParameter((Object)$this$matchRect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        float r = $this$matchRect.getRight();
        if (r > target.width()) {
            r = target.width();
        }
        if ((b = $this$matchRect.getBottom()) > target.height()) {
            b = target.height();
        }
        return new RectF($this$matchRect.getLeft(), $this$matchRect.getTop(), r, b);
    }
}

