/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007J \u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/sdk/getidlib/utils/LocaleChooser;", "", "()V", "getBestMatch", "", "preferred", "supported", "", "getChineseBestMatch", "locale", "isLocaleContainsOneOf", "", "markers", "isSimplifiedChinese", "isTraditionalChinese", "normalized", "code", "getidlib_release"})
public final class LocaleChooser {
    @NotNull
    public static final LocaleChooser INSTANCE = new LocaleChooser();

    private LocaleChooser() {
    }

    @NotNull
    public final String getBestMatch(@NotNull String preferred, @NotNull List<String> supported) {
        Object v1;
        block9: {
            String chineseBestMatch;
            Object v0;
            boolean bl;
            Iterable iterable;
            String normalizedPreferred;
            List normalizedSupported;
            block8: {
                Iterable $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)preferred, (String)"preferred");
                Intrinsics.checkNotNullParameter(supported, (String)"supported");
                if (preferred.length() < 2) {
                    return "en";
                }
                Iterable $this$filter$iv = supported;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv22 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.length() >= 2)) continue;
                    destination$iv$iv22.add(element$iv$iv);
                }
                normalizedSupported = (List)destination$iv$iv22;
                if (normalizedSupported.isEmpty()) {
                    return "en";
                }
                normalizedPreferred = this.normalized(preferred);
                $this$filterTo$iv$iv = normalizedSupported;
                boolean destination$iv$iv22 = false;
                iterable = $this$filterTo$iv$iv;
                bl = false;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)INSTANCE.normalized(it), (Object)normalizedPreferred)) continue;
                    v0 = t;
                    break block8;
                }
                v0 = null;
            }
            String same = v0;
            if (same != null) {
                return same;
            }
            String language = StringsKt.take((String)normalizedPreferred, (int)2);
            if (Intrinsics.areEqual((Object)language, (Object)"zh") && (chineseBestMatch = this.getChineseBestMatch(normalizedPreferred, normalizedSupported)) != null) {
                return chineseBestMatch;
            }
            iterable = normalizedSupported;
            bl = false;
            Iterable iterable3 = iterable;
            boolean bl4 = false;
            Iterator iterator = iterable3.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                String it = (String)t;
                boolean bl5 = false;
                if (!StringsKt.startsWith$default((String)INSTANCE.normalized(it), (String)language, (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block9;
            }
            v1 = null;
        }
        String sameLanguage = v1;
        if (sameLanguage != null) {
            return sameLanguage;
        }
        return "en";
    }

    private final String normalized(String code) {
        String string2 = StringsKt.replace$default((String)code, (String)"-", (String)"_", (boolean)false, (int)4, null);
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return string4;
    }

    private final String getChineseBestMatch(String locale, List<String> supported) {
        if (this.isTraditionalChinese(locale)) {
            Object v0;
            block4: {
                Iterable iterable = supported;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl3 = false;
                    if (!INSTANCE.isTraditionalChinese(it)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            return v0;
        }
        if (this.isSimplifiedChinese(locale)) {
            Object v1;
            block5: {
                Iterable iterable = supported;
                boolean bl = false;
                Iterable iterable3 = iterable;
                boolean bl4 = false;
                for (Object t : iterable3) {
                    String it = (String)t;
                    boolean bl5 = false;
                    if (!INSTANCE.isSimplifiedChinese(it)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            return v1;
        }
        return null;
    }

    private final boolean isTraditionalChinese(String locale) {
        if (StringsKt.contains$default((CharSequence)this.normalized(locale), (CharSequence)this.normalized("Hans"), (boolean)false, (int)2, null)) {
            return false;
        }
        Object[] objectArray = new String[]{"Hant", "TW", "HK", "MO"};
        return this.isLocaleContainsOneOf(locale, CollectionsKt.listOf((Object[])objectArray));
    }

    private final boolean isSimplifiedChinese(String locale) {
        if (StringsKt.contains$default((CharSequence)this.normalized(locale), (CharSequence)this.normalized("Hant"), (boolean)false, (int)2, null)) {
            return false;
        }
        Object[] objectArray = new String[]{"Hans", "CN", "SG", "MY"};
        return this.isLocaleContainsOneOf(locale, CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isLocaleContainsOneOf(String locale, List<String> markers) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = markers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string3 = INSTANCE.normalized((String)it);
            collection.add(string3);
        }
        List normalizedMarkers = (List)destination$iv$iv;
        Object object = new String[]{"_"};
        List components = StringsKt.split$default((CharSequence)this.normalized(locale), (String[])object, (boolean)false, (int)0, (int)6, null);
        object = CollectionsKt.intersect((Iterable)normalizedMarkers, (Iterable)components);
        boolean bl = false;
        return !object.isEmpty();
    }
}

