/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/sdk/getidlib/utils/FormatUtils;", "", "()V", "dateFormat", "", "rtlDateFormat", "sdf", "Ljava/text/SimpleDateFormat;", "sdfRTL", "convertDate", "Ljava/util/Date;", "text", "convertDateFromRTL", "date", "formatDate", "formatDateRTL", "getidlib_release"})
public final class FormatUtils {
    @NotNull
    public static final FormatUtils INSTANCE = new FormatUtils();
    @NotNull
    private static final String dateFormat = "yyyy-MM-dd";
    @NotNull
    private static final String rtlDateFormat = "dd-MM-yyyy";
    @NotNull
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    @NotNull
    private static final SimpleDateFormat sdfRTL = new SimpleDateFormat("dd-MM-yyyy", new Locale("ar"));

    private FormatUtils() {
    }

    @NotNull
    public final String formatDateRTL(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string2 = sdfRTL.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdfRTL.format(date)");
        return string2;
    }

    @Nullable
    public final Date convertDate(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return sdf.parse(text);
    }

    @NotNull
    public final String formatDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string2 = sdf.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdf.format(date)");
        return string2;
    }

    @Nullable
    public final String convertDateFromRTL(@NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Date d = sdfRTL.parse(date);
        return d != null ? sdf.format(d) : null;
    }
}

