/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.utils;

import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.helpers.ValidationExtensionsKt;
import com.sdk.getidlib.model.app.form.CategoryType;
import com.sdk.getidlib.model.app.form.FormField;
import com.sdk.getidlib.model.app.form.FormValueType;
import com.sdk.getidlib.model.entity.configuration.Fields;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0012"}, d2={"Lcom/sdk/getidlib/utils/FormFieldCreator;", "", "()V", "createFormField", "Lcom/sdk/getidlib/model/app/form/FormField;", "field", "Lcom/sdk/getidlib/model/entity/configuration/Fields;", "createFormFieldsList", "", "list", "validAndCreateFormFieldsList", "validateCountry", "", "value", "", "validateDate", "validateGender", "validateText", "getidlib_release"})
public final class FormFieldCreator {
    @NotNull
    public static final FormFieldCreator INSTANCE = new FormFieldCreator();

    private FormFieldCreator() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FormField> createFormFieldsList(@NotNull List<Fields> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        ArrayList<FormField> fields = new ArrayList<FormField>();
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Fields fields2 = (Fields)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FormField formField = INSTANCE.createFormField((Fields)it);
            collection.add(formField);
        }
        Iterator $this$forEach$iv = ((List)destination$iv$iv).iterator();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Object object2 = object;
        while (object2.hasNext()) {
            Object element$iv = object2.next();
            FormField it = (FormField)element$iv;
            boolean bl2 = false;
            fields.add(it);
        }
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FormField> validAndCreateFormFieldsList(@NotNull List<Fields> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        ArrayList<FormField> fields = new ArrayList<FormField>();
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Fields fields2 = (Fields)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FormField formField = INSTANCE.createFormField((Fields)it);
            collection.add(formField);
        }
        Iterator $this$forEach$iv = ((List)destination$iv$iv).iterator();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv;
        boolean bl = false;
        Object object2 = object;
        while (object2.hasNext()) {
            boolean isValid;
            boolean bl2;
            Object element$iv = object2.next();
            FormField it = (FormField)element$iv;
            boolean bl3 = false;
            FormValueType formValueType = it.getValueType();
            int n = WhenMappings.$EnumSwitchMapping$0[formValueType.ordinal()];
            switch (n) {
                case 1: {
                    bl2 = INSTANCE.validateDate(it.getValue());
                    break;
                }
                case 2: {
                    bl2 = INSTANCE.validateGender(it.getValue());
                    break;
                }
                case 3: {
                    bl2 = INSTANCE.validateCountry(it.getValue());
                    break;
                }
                case 4: {
                    bl2 = INSTANCE.validateText(it.getValue());
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            if (!(isValid = bl2)) continue;
            fields.add(it);
        }
        return fields;
    }

    public final boolean validateDate(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        sdf.setLenient(false);
        boolean isValid = true;
        try {
            sdf.parse(value);
        }
        catch (ParseException ex) {
            isValid = false;
        }
        return isValid;
    }

    public final boolean validateGender(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Intrinsics.areEqual((Object)value, (Object)"female") || Intrinsics.areEqual((Object)value, (Object)"male");
    }

    /*
     * WARNING - void declaration
     */
    public final boolean validateCountry(@NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = value;
        boolean bl2 = false;
        if (charSequence.length() == 3) {
            void $this$filterTo$iv$iv;
            charSequence = value;
            bl2 = false;
            char[] cArray = ((String)charSequence).toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] $this$filter$iv = cArray;
            boolean $i$f$filter = false;
            char[] cArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var7_7 = $this$filterTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var7_7[i];
                boolean bl3 = false;
                void var13_13 = it;
                boolean bl4 = false;
                if (!Character.isUpperCase((char)var13_13)) continue;
                destination$iv$iv.add(Character.valueOf((char)element$iv$iv));
            }
            charSequence = value;
            bl2 = false;
            bl = ((List)destination$iv$iv).size() == charSequence.length();
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean validateText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = value;
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        charSequence = value;
        bl = false;
        if (charSequence.length() > 256) return false;
        return true;
    }

    @NotNull
    public final FormField createFormField(@NotNull Fields field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        String string2 = field.getContent();
        FormField formField = new FormField(null, FormValueType.TEXT, null, field.getFieldType(), null, string2 == null ? ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE) : string2, field.getRequired(), field.getDisplayHint(), field.getHint(), null, 533, null);
        String string3 = field.getFieldType();
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        switch (string5) {
            case "first-name": 
            case "first name": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_FIRSTNAME));
                formField.setCategory(CategoryType.FIRST_NAME);
                break;
            }
            case "last name": 
            case "last-name": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_LASTNAME));
                formField.setCategory(CategoryType.LAST_NAME);
                break;
            }
            case "address": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_ADDRESS));
                formField.setCategory(CategoryType.ADDRESS);
                break;
            }
            case "email": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_EMAIL));
                formField.setCategory(CategoryType.EMAIL);
                break;
            }
            case "nationality": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_NATIONALITY));
                formField.setValueType(FormValueType.COUNTRY);
                formField.setCategory(CategoryType.NATIONALITY);
                break;
            }
            case "date-of-birth": 
            case "date of birth": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_DATEOFBIRTH));
                formField.setValueType(FormValueType.DATE);
                formField.setCategory(CategoryType.DATE_OF_BIRTH);
                break;
            }
            case "gender": 
            case "sex": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_SEX));
                formField.setValueType(FormValueType.SEX);
                formField.setCategory(CategoryType.SEX);
                break;
            }
            case "personal-number": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_PERSONALNUMBER));
                formField.setCategory(CategoryType.PERSONAL_NUMBER);
                break;
            }
            case "document-number": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_DOCUMENTNUMBER));
                formField.setCategory(CategoryType.DOCUMENT_NUMBER);
                break;
            }
            case "date-of-issue": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_DATEOFISSUE));
                formField.setValueType(FormValueType.DATE);
                formField.setCategory(CategoryType.DATE_OF_ISSUE);
                break;
            }
            case "date-of-expiry": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_DATEOFEXPIRY));
                formField.setValueType(FormValueType.DATE);
                formField.setCategory(CategoryType.DATE_OF_EXPIRY);
                break;
            }
            case "phone-number": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_PHONE));
                formField.setCategory(CategoryType.PHONE_NUMBER);
                break;
            }
            case "city-of-residence": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_CITYOFRESIDENCE));
                formField.setCategory(CategoryType.CITY_OF_RESIDENCE);
                break;
            }
            case "country-of-residence": {
                formField.setTitle(Localization.Companion.translation(TranslationKey.PROFILEDATA_FIELDCATEGORIES_COUNTRYOFRESIDENCE));
                formField.setValueType(FormValueType.COUNTRY);
                formField.setCategory(CategoryType.COUNTRY_OF_RESIDENCE);
                break;
            }
            default: {
                String string6;
                if (Intrinsics.areEqual((Object)field.getContentType(), (Object)"boolean")) {
                    String string7;
                    string3 = field.getLabel();
                    formField.setTitle(string3 == null ? ((string7 = field.getCategory()) == null ? field.getFieldType() : string7) : string3);
                    formField.setValueType(FormValueType.BOOLEAN);
                    formField.setCategory(CategoryType.CUSTOM);
                    break;
                }
                string3 = field.getLabel();
                formField.setTitle(string3 == null ? ((string6 = field.getCategory()) == null ? field.getFieldType() : string6) : string3);
                formField.setValueType(FormValueType.TEXT);
                formField.setCategory(CategoryType.CUSTOM);
            }
        }
        return formField;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormValueType.values().length];
            nArray[FormValueType.DATE.ordinal()] = 1;
            nArray[FormValueType.SEX.ordinal()] = 2;
            nArray[FormValueType.COUNTRY.ordinal()] = 3;
            nArray[FormValueType.TEXT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

