/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u001f\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/sdk/getidlib/utils/FilePath;", "", "()V", "DEFAULT_BUFFER_SIZE", "", "EOF", "copy", "", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "from", "Ljava/io/File;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "getFileName", "", "rename", "file", "newName", "splitFileName", "", "fileName", "(Ljava/lang/String;)[Ljava/lang/String;", "getidlib_release"})
public final class FilePath {
    @NotNull
    public static final FilePath INSTANCE = new FilePath();
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private FilePath() {
    }

    @NotNull
    public final File from(@NotNull Context context, @NotNull Uri uri) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        InputStream inputStream = context.getContentResolver().openInputStream(uri);
        String fileName = this.getFileName(context, uri);
        String[] splitName = this.splitFileName(fileName);
        Object object = splitName[0];
        Object object2 = object == null ? "temp" : object;
        object = splitName[1];
        File file = File.createTempFile((String)object2, (String)(object == null ? "file" : object));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(splitName\u2026, splitName[1] ?: \"file\")");
        File tempFile = file;
        tempFile = this.rename(tempFile, fileName);
        tempFile.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (inputStream != null) {
            FileOutputStream fileOutputStream = out;
            Intrinsics.checkNotNull((Object)fileOutputStream);
            this.copy(inputStream, fileOutputStream);
            inputStream.close();
        }
        if ((object = out) != null) {
            ((FileOutputStream)object).close();
        }
        return tempFile;
    }

    private final String[] splitFileName(String fileName) {
        String[] stringArray;
        Object name = fileName;
        String extension = "";
        Intrinsics.checkNotNull((Object)fileName);
        int i = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)fileName), (String)".", (int)0, (boolean)false, (int)6, null);
        if (i != -1) {
            stringArray = fileName;
            int n = 0;
            boolean bl = false;
            String string2 = stringArray.substring(n, i);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            name = string2;
            stringArray = fileName;
            n = 0;
            String string3 = stringArray.substring(i);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            extension = string3;
        }
        stringArray = new String[]{name, extension};
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFileName(Context context, Uri uri) {
        String string2;
        String result = null;
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"content")) {
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            try {
                if (cursor != null && cursor.moveToFirst()) {
                    result = cursor.getString(cursor.getColumnIndexOrThrow("_display_name"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                string2 = cursor;
                if (string2 != null) {
                    string2.close();
                }
            }
        }
        if (result == null) {
            String string3 = result = uri.getPath();
            Intrinsics.checkNotNull((Object)string3);
            CharSequence charSequence = string3;
            string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            int cut = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
            if (cut != -1) {
                string2 = result;
                int n = cut + 1;
                boolean bl = false;
                String string4 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                result = string4;
            }
        }
        return result;
    }

    private final File rename(File file, String newName) {
        File newFile = new File(file.getParent(), newName);
        if (!Intrinsics.areEqual((Object)newFile, (Object)file)) {
            if (newFile.exists() && newFile.delete()) {
                Log.d((String)"FileUtil", (String)("Delete old " + newName + " file"));
            }
            if (file.renameTo(newFile)) {
                Log.d((String)"FileUtil", (String)Intrinsics.stringPlus((String)"Rename file to ", (Object)newName));
            }
        }
        return newFile;
    }

    /*
     * WARNING - void declaration
     */
    private final long copy(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        int n = 0;
        byte[] buffer = new byte[4096];
        while (true) {
            void it;
            int n2 = input.read(buffer);
            boolean bl = false;
            boolean bl2 = false;
            int n3 = n2;
            int n4 = -1;
            boolean bl3 = false;
            n = it;
            Unit unit = Unit.INSTANCE;
            if (n4 == n2) break;
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

