/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.ui.features.photo_document;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.fragment.app.Fragment;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.sdk.getidlib.R;
import com.sdk.getidlib.app.common.PermissionRequestFragment;
import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.ThemeInstance;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.app.utils.ColorTransparentUtils;
import com.sdk.getidlib.app.utils.ViewUtilsKt;
import com.sdk.getidlib.databinding.FragmentPhotoDocumentLibraryBinding;
import com.sdk.getidlib.databinding.LayoutDocumentErrorDialogBinding;
import com.sdk.getidlib.databinding.LayoutReadFilesPermissionBinding;
import com.sdk.getidlib.presentation.features.photo_document.DocumentState;
import com.sdk.getidlib.presentation.features.photo_document.LibraryPhotoDocumentContract;
import com.sdk.getidlib.ui.features.photo_document.ImageType;
import com.sdk.getidlib.ui.features.photo_document.LibraryDocumentFragment;
import com.sdk.getidlib.ui.global.BaseFragment;
import com.sdk.getidlib.utils.ColorUtils;
import java.io.FileNotFoundException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 I2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00042\u00020\u0005:\u0001IB\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000bH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000bH\u0016J\b\u0010\"\u001a\u00020\u000bH\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020\u001cH\u0002J\b\u0010'\u001a\u00020\u001cH\u0002J\b\u0010(\u001a\u00020\u001cH\u0016J\b\u0010)\u001a\u00020\u001cH\u0016J\b\u0010*\u001a\u00020\u001cH\u0016J\u0012\u0010+\u001a\u00020\u001c2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020-H\u0016J\u000f\u00100\u001a\u0004\u0018\u000101H\u0002\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020-H\u0016J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\b\u00106\u001a\u00020\u001cH\u0002J\u0010\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u0013H\u0016J\u0010\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u000bH\u0002J\b\u0010;\u001a\u00020\u001cH\u0002J\b\u0010<\u001a\u00020\u001cH\u0016J\b\u0010=\u001a\u00020\u001cH\u0016J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@H\u0016J\u0018\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020-H\u0016J\u0018\u0010D\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@2\u0006\u0010E\u001a\u00020\u000bH\u0016J\u0010\u0010F\u001a\u00020\u001c2\u0006\u0010G\u001a\u00020-H\u0002J\b\u0010H\u001a\u00020\u001cH\u0002R.\u0010\u0007\u001a\u001c\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/sdk/getidlib/ui/features/photo_document/LibraryDocumentFragment;", "Lcom/sdk/getidlib/ui/global/BaseFragment;", "Lcom/sdk/getidlib/databinding/FragmentPhotoDocumentLibraryBinding;", "Lcom/sdk/getidlib/presentation/features/photo_document/LibraryPhotoDocumentContract$Presenter;", "Lcom/sdk/getidlib/presentation/features/photo_document/LibraryPhotoDocumentContract$View;", "Lcom/sdk/getidlib/app/common/PermissionRequestFragment$Listener;", "()V", "bindingInflater", "Lkotlin/Function3;", "Landroid/view/LayoutInflater;", "Landroid/view/ViewGroup;", "", "getBindingInflater", "()Lkotlin/jvm/functions/Function3;", "chooseFileResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "kotlin.jvm.PlatformType", "documentType", "Lcom/sdk/getidlib/presentation/features/photo_document/DocumentState;", "presenter", "getPresenter", "()Lcom/sdk/getidlib/presentation/features/photo_document/LibraryPhotoDocumentContract$Presenter;", "presenter$delegate", "Lkotlin/Lazy;", "selectedImage", "Lcom/sdk/getidlib/ui/features/photo_document/ImageType;", "changeAcceptBackground", "", "isChecked", "changeAcceptButtonState", "acceptButtonEnabled", "changeCameraPermissionLayoutVisibility", "visibility", "checkIsNeedToShowCameraPermission", "checkPermission", "clearPreview", "isFrontPreview", "getImageFromLibrary", "initScreen", "onBackPressed", "onStart", "openAppSettings", "permissionDenied", "messageDenied", "", "permissionGranted", "permissionName", "removePermissionFragment", "", "()Ljava/lang/Integer;", "setAgreeButtonTitle", "title", "setBtnAcceptTextColor", "setDesign", "setDocState", "docType", "setLayoutDirection", "isRTL", "setListeners", "setTranslation", "setup", "showBackPreview", "bitmap", "Landroid/graphics/Bitmap;", "showErrorDialog", "header", "description", "showFrontPreview", "isSingleImage", "startPermissionFragment", "permission", "updateDocState", "Companion", "getidlib_release"})
public final class LibraryDocumentFragment
extends BaseFragment<FragmentPhotoDocumentLibraryBinding, LibraryPhotoDocumentContract.Presenter>
implements LibraryPhotoDocumentContract.View,
PermissionRequestFragment.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function3<LayoutInflater, ViewGroup, Boolean, FragmentPhotoDocumentLibraryBinding> bindingInflater = bindingInflater.1.INSTANCE;
    @NotNull
    private final Lazy presenter$delegate = LazyKt.lazy((Function0)presenter.2.INSTANCE);
    @NotNull
    private ImageType selectedImage = ImageType.SINGLE;
    @NotNull
    private DocumentState documentType = DocumentState.SINGLE;
    @NotNull
    private ActivityResultLauncher<Intent> chooseFileResultLauncher;
    @NotNull
    private static final String TAG;

    public LibraryDocumentFragment() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> LibraryDocumentFragment.chooseFileResultLauncher$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026        }\n        }\n    }");
        this.chooseFileResultLauncher = activityResultLauncher;
    }

    @Override
    @NotNull
    public Function3<LayoutInflater, ViewGroup, Boolean, FragmentPhotoDocumentLibraryBinding> getBindingInflater() {
        return this.bindingInflater;
    }

    @Override
    @NotNull
    public LibraryPhotoDocumentContract.Presenter getPresenter() {
        Lazy lazy = this.presenter$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (LibraryPhotoDocumentContract.Presenter)lazy.getValue();
    }

    public void onStart() {
        super.onStart();
        this.checkPermission();
    }

    @Override
    public void setup() {
        this.setDesign();
        LibraryPhotoDocumentContract.Presenter presenter2 = this.getPresenter();
        boolean bl = false;
        boolean bl2 = false;
        LibraryPhotoDocumentContract.Presenter $this$setup_u24lambda_u2d1 = presenter2;
        boolean bl3 = false;
        $this$setup_u24lambda_u2d1.setView(this);
        $this$setup_u24lambda_u2d1.onStart();
        this.initScreen();
        this.setListeners();
        this.getPresenter().changeAcceptButtonState(false);
    }

    @Override
    public void setAgreeButtonTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$setAgreeButtonTitle_u24lambda_u2d2 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        $this$setAgreeButtonTitle_u24lambda_u2d2.btnNext.setText((CharSequence)title);
    }

    @Override
    public void setTranslation() {
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$setTranslation_u24lambda_u2d3 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        $this$setTranslation_u24lambda_u2d3.photoDocumentLibraryTitle.setText((CharSequence)Localization.Companion.translation(TranslationKey.DOCUMENT_FROMGALLERY_DESCRIPTION));
        if (this.documentType == DocumentState.TOP_BOTTOM) {
            $this$setTranslation_u24lambda_u2d3.frontText.setText((CharSequence)Localization.Companion.translation(TranslationKey.DOCUMENT_FROMGALLERY_BOTTOMPAGE));
            $this$setTranslation_u24lambda_u2d3.backText.setText((CharSequence)Localization.Companion.translation(TranslationKey.DOCUMENT_FROMGALLERY_TOPPAGE));
        } else {
            $this$setTranslation_u24lambda_u2d3.frontText.setText((CharSequence)Localization.Companion.translation(TranslationKey.DOCUMENT_FROMGALLERY_FRONTSIDE));
            $this$setTranslation_u24lambda_u2d3.backText.setText((CharSequence)Localization.Companion.translation(TranslationKey.DOCUMENT_FROMGALLERY_BACKSIDE));
        }
        $this$setTranslation_u24lambda_u2d3.singleText.setText((CharSequence)Localization.Companion.translation(TranslationKey.DOCUMENT_SHARED_DOCUMENTPHOTO));
    }

    @Override
    public void onBackPressed() {
        if (!this.getPresenter().isRequestInProgress()) {
            super.onBackPressed();
        }
    }

    @Override
    public void changeCameraPermissionLayoutVisibility(boolean visibility) {
        LayoutReadFilesPermissionBinding layoutReadFilesPermissionBinding = ((FragmentPhotoDocumentLibraryBinding)this.getBinding()).readFilesPermission;
        boolean bl = false;
        boolean bl2 = false;
        LayoutReadFilesPermissionBinding $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5 = layoutReadFilesPermissionBinding;
        boolean bl3 = false;
        if (visibility) {
            ConstraintLayout constraintLayout = $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.clReadPermission;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"clReadPermission");
            ViewUtilsKt.show((View)constraintLayout);
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvPermision.setText((CharSequence)Localization.Companion.translation(TranslationKey.ERRORS_SHARED_NOACCESSTOGALLERY));
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvPermissionDescription.setText((CharSequence)Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ACCESSTOGALLERYDESCRIPTION_MOBILE));
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvGoToSettings.setText((CharSequence)Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_GOTOSETTINGS_MOBILE));
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvGoToSettings.setOnClickListener(arg_0 -> LibraryDocumentFragment.changeCameraPermissionLayoutVisibility$lambda-5$lambda-4(this, arg_0));
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvPermissionDescription.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getSecondaryTextColor()));
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvPermision.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryTextColor()));
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvGoToSettings.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryButtonTextColor()));
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvGoToSettings.setBackgroundColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryButtonBackgroundColor()));
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.clReadPermission.setBackgroundColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryBackgroundColor()));
        } else {
            ConstraintLayout constraintLayout = $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.clReadPermission;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"clReadPermission");
            ViewUtilsKt.gone((View)constraintLayout);
            $this$changeCameraPermissionLayoutVisibility_u24lambda_u2d5.tvGoToSettings.setOnClickListener(null);
        }
    }

    @Override
    public void openAppSettings() {
        Intent intent = new Intent();
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$openAppSettings_u24lambda_u2d6 = intent;
        boolean bl3 = false;
        $this$openAppSettings_u24lambda_u2d6.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        $this$openAppSettings_u24lambda_u2d6.setData(Uri.fromParts((String)"package", (String)this.requireActivity().getPackageName(), null));
        Intent intent2 = intent;
        this.startActivity(intent2);
    }

    @Override
    public void setDocState(@NotNull DocumentState docType) {
        Intrinsics.checkNotNullParameter((Object)((Object)docType), (String)"docType");
        this.documentType = docType;
        this.updateDocState();
    }

    @Override
    public void changeAcceptButtonState(boolean acceptButtonEnabled) {
        this.changeAcceptBackground(acceptButtonEnabled);
        this.setBtnAcceptTextColor(acceptButtonEnabled);
        ((FragmentPhotoDocumentLibraryBinding)this.getBinding()).btnNext.setEnabled(acceptButtonEnabled);
        if (acceptButtonEnabled) {
            ((FragmentPhotoDocumentLibraryBinding)this.getBinding()).btnNext.setOnClickListener(arg_0 -> LibraryDocumentFragment.changeAcceptButtonState$lambda-7(this, arg_0));
        }
    }

    @Override
    public void showFrontPreview(@NotNull Bitmap bitmap, boolean isSingleImage) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$showFrontPreview_u24lambda_u2d8 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        if (isSingleImage) {
            $this$showFrontPreview_u24lambda_u2d8.singleImg.setColorFilter(0, PorterDuff.Mode.SRC_OVER);
            $this$showFrontPreview_u24lambda_u2d8.singleImg.setImageBitmap(bitmap);
            $this$showFrontPreview_u24lambda_u2d8.addSingleImageLayout.setVisibility(8);
            $this$showFrontPreview_u24lambda_u2d8.singlePencil.setVisibility(0);
        } else {
            $this$showFrontPreview_u24lambda_u2d8.frontImg.setColorFilter(0, PorterDuff.Mode.SRC_OVER);
            $this$showFrontPreview_u24lambda_u2d8.frontImg.setImageBitmap(bitmap);
            $this$showFrontPreview_u24lambda_u2d8.addFrontImageLayout.setVisibility(8);
            $this$showFrontPreview_u24lambda_u2d8.frontPencil.setVisibility(0);
        }
    }

    @Override
    public void showBackPreview(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$showBackPreview_u24lambda_u2d9 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        $this$showBackPreview_u24lambda_u2d9.backImg.setColorFilter(0, PorterDuff.Mode.SRC_OVER);
        $this$showBackPreview_u24lambda_u2d9.backImg.setImageBitmap(bitmap);
        $this$showBackPreview_u24lambda_u2d9.addBackImageLayout.setVisibility(8);
        $this$showBackPreview_u24lambda_u2d9.backPencil.setVisibility(0);
    }

    @Override
    public void clearPreview(boolean isFrontPreview) {
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$clearPreview_u24lambda_u2d10 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        if (isFrontPreview) {
            $this$clearPreview_u24lambda_u2d10.frontImg.setImageDrawable(ContextCompat.getDrawable((Context)((Context)this.requireActivity()), (int)R.drawable.border_image_library));
            LinearLayout linearLayout = $this$clearPreview_u24lambda_u2d10.addFrontImageLayout;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"addFrontImageLayout");
            ViewUtilsKt.show((View)linearLayout);
            linearLayout = $this$clearPreview_u24lambda_u2d10.frontPencil;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"frontPencil");
            ViewUtilsKt.hide((View)linearLayout);
        } else {
            $this$clearPreview_u24lambda_u2d10.backImg.setImageDrawable(ContextCompat.getDrawable((Context)((Context)this.requireActivity()), (int)R.drawable.border_image_library));
            LinearLayout linearLayout = $this$clearPreview_u24lambda_u2d10.addBackImageLayout;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"addBackImageLayout");
            ViewUtilsKt.show((View)linearLayout);
            linearLayout = $this$clearPreview_u24lambda_u2d10.backPencil;
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"backPencil");
            ViewUtilsKt.hide((View)linearLayout);
        }
        this.setDesign();
    }

    @Override
    public void showErrorDialog(@NotNull String header, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        LayoutDocumentErrorDialogBinding layoutDocumentErrorDialogBinding = ((FragmentPhotoDocumentLibraryBinding)this.getBinding()).errorDialog;
        boolean bl = false;
        boolean bl2 = false;
        LayoutDocumentErrorDialogBinding $this$showErrorDialog_u24lambda_u2d13 = layoutDocumentErrorDialogBinding;
        boolean bl3 = false;
        FrameLayout frameLayout = $this$showErrorDialog_u24lambda_u2d13.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"root");
        ViewUtilsKt.show((View)frameLayout);
        $this$showErrorDialog_u24lambda_u2d13.tvTitle.setText((CharSequence)header);
        $this$showErrorDialog_u24lambda_u2d13.tvDescription.setText((CharSequence)description);
        $this$showErrorDialog_u24lambda_u2d13.tvStatusDialogAccept.setText((CharSequence)Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_OKGOTIT));
        $this$showErrorDialog_u24lambda_u2d13.tvStatusDialogAccept.setOnClickListener(arg_0 -> LibraryDocumentFragment.showErrorDialog$lambda-13$lambda-11($this$showErrorDialog_u24lambda_u2d13, arg_0));
        $this$showErrorDialog_u24lambda_u2d13.ivStatusDialogAccept.setOnClickListener(arg_0 -> LibraryDocumentFragment.showErrorDialog$lambda-13$lambda-12($this$showErrorDialog_u24lambda_u2d13, arg_0));
        $this$showErrorDialog_u24lambda_u2d13.documentErrorDialogConstraint.getBackground().setTint(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryBackgroundColor()));
        $this$showErrorDialog_u24lambda_u2d13.tvTitle.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryTextColor()));
        $this$showErrorDialog_u24lambda_u2d13.tvDescription.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getSecondaryTextColor()));
        $this$showErrorDialog_u24lambda_u2d13.ivStatus.getBackground().setTint(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getWarningColor()));
        $this$showErrorDialog_u24lambda_u2d13.ivStatusDialogAccept.setColorFilter(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryButtonBackgroundColor()), PorterDuff.Mode.SRC_IN);
    }

    @Override
    public void permissionGranted(@NotNull String permissionName) {
        Intrinsics.checkNotNullParameter((Object)permissionName, (String)"permissionName");
        this.removePermissionFragment();
    }

    @Override
    public void permissionDenied(@Nullable String messageDenied) {
        this.getPresenter().permissionDenied();
        this.removePermissionFragment();
    }

    private final void setDesign() {
        AppCompatImageView it;
        Object element$iv;
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$setDesign_u24lambda_u2d17 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        $this$setDesign_u24lambda_u2d17.getRoot().getBackground().setTint(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryBackgroundColor()));
        this.setLayoutDirection(this.getPresenter().isRTL());
        String color = ColorUtils.INSTANCE.getHex(ThemeInstance.Companion.getTheme$getidlib_release().getAccentColor());
        Object[] objectArray = new AppCompatImageView[]{$this$setDesign_u24lambda_u2d17.singleImg, $this$setDesign_u24lambda_u2d17.frontImg, $this$setDesign_u24lambda_u2d17.backImg};
        Object $this$forEach$iv = ArrayIteratorKt.iterator((Object[])objectArray);
        boolean $i$f$forEach = false;
        Object[] objectArray2 = $this$forEach$iv;
        boolean bl4 = false;
        Object[] objectArray3 = objectArray2;
        while (objectArray3.hasNext()) {
            element$iv = objectArray3.next();
            it = (AppCompatImageView)element$iv;
            boolean bl5 = false;
            it.clearColorFilter();
        }
        $this$forEach$iv = new AppCompatImageView[]{$this$setDesign_u24lambda_u2d17.singlePlus, $this$setDesign_u24lambda_u2d17.frontPlus, $this$setDesign_u24lambda_u2d17.backPlus};
        $this$forEach$iv = ArrayIteratorKt.iterator((Object[])$this$forEach$iv);
        $i$f$forEach = false;
        objectArray2 = $this$forEach$iv;
        bl4 = false;
        objectArray3 = objectArray2;
        while (objectArray3.hasNext()) {
            element$iv = objectArray3.next();
            it = (AppCompatImageView)element$iv;
            boolean bl6 = false;
            it.setColorFilter(ColorTransparentUtils.INSTANCE.transparentColor80(color), PorterDuff.Mode.SRC_IN);
        }
        $this$forEach$iv = new AppCompatImageView[]{$this$setDesign_u24lambda_u2d17.singlePencil, $this$setDesign_u24lambda_u2d17.frontPencil, $this$setDesign_u24lambda_u2d17.backPencil};
        $this$forEach$iv = ArrayIteratorKt.iterator((Object[])$this$forEach$iv);
        $i$f$forEach = false;
        objectArray2 = $this$forEach$iv;
        bl4 = false;
        objectArray3 = objectArray2;
        while (objectArray3.hasNext()) {
            element$iv = objectArray3.next();
            it = (AppCompatImageView)element$iv;
            boolean bl7 = false;
            it.getBackground().setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ColorTransparentUtils.INSTANCE.transparentColor80(color), (BlendModeCompat)BlendModeCompat.SRC_IN));
        }
        $this$setDesign_u24lambda_u2d17.photoDocumentLibraryTitle.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryTextColor()));
        $this$setDesign_u24lambda_u2d17.frontText.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryTextColor()));
        $this$setDesign_u24lambda_u2d17.backText.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryTextColor()));
        $this$setDesign_u24lambda_u2d17.singleText.setTextColor(ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryTextColor()));
    }

    private final void setLayoutDirection(boolean isRTL) {
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$setLayoutDirection_u24lambda_u2d18 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        $this$setLayoutDirection_u24lambda_u2d18.addSingleImageLayout.setLayoutDirection(isRTL ? 1 : 0);
        $this$setLayoutDirection_u24lambda_u2d18.addFrontImageLayout.setLayoutDirection(isRTL ? 1 : 0);
        $this$setLayoutDirection_u24lambda_u2d18.addBackImageLayout.setLayoutDirection(isRTL ? 1 : 0);
    }

    private final void initScreen() {
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$initScreen_u24lambda_u2d20 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        this.updateDocState();
        $this$initScreen_u24lambda_u2d20.btnNext.setEnabled(false);
        $this$initScreen_u24lambda_u2d20.btnNext.setOnClickListener(arg_0 -> LibraryDocumentFragment.initScreen$lambda-20$lambda-19(this, arg_0));
    }

    private final void updateDocState() {
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$updateDocState_u24lambda_u2d21 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        if (this.documentType == DocumentState.SINGLE) {
            $this$updateDocState_u24lambda_u2d21.singleContainer.setVisibility(0);
            $this$updateDocState_u24lambda_u2d21.backContainer.setVisibility(8);
            $this$updateDocState_u24lambda_u2d21.frontContainer.setVisibility(8);
        } else {
            $this$updateDocState_u24lambda_u2d21.singleContainer.setVisibility(8);
            $this$updateDocState_u24lambda_u2d21.backContainer.setVisibility(0);
            $this$updateDocState_u24lambda_u2d21.frontContainer.setVisibility(0);
        }
    }

    private final void checkPermission() {
        if (this.checkIsNeedToShowCameraPermission()) {
            this.startPermissionFragment("android.permission.READ_EXTERNAL_STORAGE");
            return;
        }
    }

    private final void setListeners() {
        Object VB = this.getBinding();
        boolean bl = false;
        boolean bl2 = false;
        FragmentPhotoDocumentLibraryBinding $this$setListeners_u24lambda_u2d25 = (FragmentPhotoDocumentLibraryBinding)VB;
        boolean bl3 = false;
        $this$setListeners_u24lambda_u2d25.frontContainer.setOnClickListener(arg_0 -> LibraryDocumentFragment.setListeners$lambda-25$lambda-22(this, arg_0));
        $this$setListeners_u24lambda_u2d25.backContainer.setOnClickListener(arg_0 -> LibraryDocumentFragment.setListeners$lambda-25$lambda-23(this, arg_0));
        $this$setListeners_u24lambda_u2d25.singleContainer.setOnClickListener(arg_0 -> LibraryDocumentFragment.setListeners$lambda-25$lambda-24(this, arg_0));
    }

    private final void getImageFromLibrary() {
        Intent photoPickerIntent = new Intent("android.intent.action.PICK");
        photoPickerIntent.setType("image/*");
        this.chooseFileResultLauncher.launch((Object)photoPickerIntent);
    }

    private final boolean checkIsNeedToShowCameraPermission() {
        return ActivityCompat.checkSelfPermission((Context)this.requireContext(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0;
    }

    /*
     * WARNING - void declaration
     */
    private final void startPermissionFragment(String permission) {
        void $this$startPermissionFragment_u24lambda_u2d27_u24lambda_u2d26;
        PermissionRequestFragment permissionRequestFragment = new PermissionRequestFragment();
        boolean bl = false;
        boolean bl2 = false;
        PermissionRequestFragment $this$startPermissionFragment_u24lambda_u2d27 = permissionRequestFragment;
        boolean bl3 = false;
        $this$startPermissionFragment_u24lambda_u2d27.setPermissionListener(this);
        Bundle bundle = new Bundle();
        boolean bl4 = false;
        boolean bl5 = false;
        Bundle bundle2 = bundle;
        PermissionRequestFragment permissionRequestFragment2 = $this$startPermissionFragment_u24lambda_u2d27;
        boolean bl6 = false;
        $this$startPermissionFragment_u24lambda_u2d27_u24lambda_u2d26.putString("PERMISSION NAME", permission);
        $this$startPermissionFragment_u24lambda_u2d27_u24lambda_u2d26.putInt("ATTEMPT_COUNT_MAX", 4);
        Unit unit = Unit.INSTANCE;
        permissionRequestFragment2.setArguments(bundle);
        PermissionRequestFragment fragment = permissionRequestFragment;
        this.getParentFragmentManager().beginTransaction().add(R.id.fragment_permission, (Fragment)fragment, PermissionRequestFragment.Companion.getTAG()).commit();
    }

    private final Integer removePermissionFragment() {
        Integer n;
        Fragment fragment = this.getParentFragmentManager().findFragmentByTag(PermissionRequestFragment.Companion.getTAG());
        if (fragment == null) {
            n = null;
        } else {
            int n2;
            Fragment fragment2 = fragment;
            boolean bl = false;
            boolean bl2 = false;
            Fragment it = fragment2;
            boolean bl3 = false;
            try {
                n2 = this.getParentFragmentManager().beginTransaction().remove(it).commit();
            }
            catch (IllegalStateException e) {
                n2 = Log.e((String)TAG, (String)e.toString());
            }
            n = n2;
        }
        return n;
    }

    private final void changeAcceptBackground(boolean isChecked) {
        int resId = isChecked ? R.drawable.ic_btn_main_gradient : R.drawable.ic_btn_main_gradient_alpha;
        Drawable drawable2 = AppCompatResources.getDrawable((Context)this.requireContext(), (int)resId);
        boolean bl = false;
        boolean bl2 = false;
        Drawable $this$changeAcceptBackground_u24lambda_u2d29 = drawable2;
        boolean bl3 = false;
        ViewUtilsKt.addTint($this$changeAcceptBackground_u24lambda_u2d29, ColorUtils.INSTANCE.getHex(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryButtonBackgroundColor()), isChecked);
        Drawable drawable3 = drawable2;
        ((FragmentPhotoDocumentLibraryBinding)this.getBinding()).btnNext.setBackground(drawable3);
    }

    private final void setBtnAcceptTextColor(boolean isChecked) {
        int textColor = isChecked ? ColorUtils.INSTANCE.parse(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryButtonTextColor()) : ColorTransparentUtils.INSTANCE.transparentColor70(ColorUtils.INSTANCE.getHex(ThemeInstance.Companion.getTheme$getidlib_release().getPrimaryButtonTextColor()));
        Context context = this.getContext();
        if (context != null) {
            Context context2 = context;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context2;
            boolean bl3 = false;
            ((FragmentPhotoDocumentLibraryBinding)this.getBinding()).btnNext.setTextColor(textColor);
        }
    }

    private static final void chooseFileResultLauncher$lambda-0(LibraryDocumentFragment this$0, ActivityResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (it.getResultCode() == -1) {
            try {
                Intent intent = it.getData();
                Intrinsics.checkNotNull((Object)intent);
                Uri uri = intent.getData();
                Intrinsics.checkNotNull((Object)uri);
                Uri uri2 = uri;
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"it.data!!.data!!");
                Uri imageUri = uri2;
                Glide.with((Context)this$0.requireContext()).asBitmap().load(imageUri).into((Target)new CustomTarget<Bitmap>(this$0){
                    final /* synthetic */ LibraryDocumentFragment this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResourceReady(@NotNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                        FragmentPhotoDocumentLibraryBinding fragmentPhotoDocumentLibraryBinding = LibraryDocumentFragment.access$getBinding(this.this$0);
                        LibraryDocumentFragment libraryDocumentFragment = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        FragmentPhotoDocumentLibraryBinding $this$onResourceReady_u24lambda_u2d0 = fragmentPhotoDocumentLibraryBinding;
                        boolean bl3 = false;
                        ImageType imageType = LibraryDocumentFragment.access$getSelectedImage$p(libraryDocumentFragment);
                        int n = chooseFileResultLauncher.1.WhenMappings.$EnumSwitchMapping$0[imageType.ordinal()];
                        switch (n) {
                            case 1: {
                                $this$onResourceReady_u24lambda_u2d0.frontImg.setColorFilter(0, PorterDuff.Mode.SRC_OVER);
                                $this$onResourceReady_u24lambda_u2d0.frontImg.setImageBitmap(resource);
                                $this$onResourceReady_u24lambda_u2d0.addFrontImageLayout.setVisibility(8);
                                $this$onResourceReady_u24lambda_u2d0.frontPencil.setVisibility(0);
                                break;
                            }
                            case 2: {
                                $this$onResourceReady_u24lambda_u2d0.backImg.setColorFilter(0, PorterDuff.Mode.SRC_OVER);
                                $this$onResourceReady_u24lambda_u2d0.backImg.setImageBitmap(resource);
                                $this$onResourceReady_u24lambda_u2d0.addBackImageLayout.setVisibility(8);
                                $this$onResourceReady_u24lambda_u2d0.backPencil.setVisibility(0);
                                break;
                            }
                            case 3: {
                                $this$onResourceReady_u24lambda_u2d0.singleImg.setColorFilter(0, PorterDuff.Mode.SRC_OVER);
                                $this$onResourceReady_u24lambda_u2d0.singleImg.setImageBitmap(resource);
                                $this$onResourceReady_u24lambda_u2d0.addSingleImageLayout.setVisibility(8);
                                $this$onResourceReady_u24lambda_u2d0.singlePencil.setVisibility(0);
                            }
                        }
                        LibraryPhotoDocumentContract.Presenter presenter2 = libraryDocumentFragment.getPresenter();
                        imageType = libraryDocumentFragment.requireContext();
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)imageType), (String)"requireContext()");
                        presenter2.saveImage(resource, (Context)imageType, LibraryDocumentFragment.access$getSelectedImage$p(libraryDocumentFragment));
                    }

                    public void onLoadCleared(@Nullable Drawable placeholder) {
                    }
                });
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                Log.e((String)"Get image from library", (String)"Something went wrong");
            }
        }
    }

    private static final void changeCameraPermissionLayoutVisibility$lambda-5$lambda-4(LibraryDocumentFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getPresenter().onClickToGoSettings();
    }

    private static final void changeAcceptButtonState$lambda-7(LibraryDocumentFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getPresenter().onClickAgree();
    }

    private static final void showErrorDialog$lambda-13$lambda-11(LayoutDocumentErrorDialogBinding $this_with, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        FrameLayout frameLayout = $this_with.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"root");
        ViewUtilsKt.hide((View)frameLayout);
    }

    private static final void showErrorDialog$lambda-13$lambda-12(LayoutDocumentErrorDialogBinding $this_with, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        FrameLayout frameLayout = $this_with.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"root");
        ViewUtilsKt.hide((View)frameLayout);
    }

    private static final void initScreen$lambda-20$lambda-19(LibraryDocumentFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getPresenter().onClickAgree();
    }

    private static final void setListeners$lambda-25$lambda-22(LibraryDocumentFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.getPresenter().isRequestInProgress()) {
            this$0.selectedImage = ImageType.FRONT;
            this$0.getImageFromLibrary();
        }
    }

    private static final void setListeners$lambda-25$lambda-23(LibraryDocumentFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.getPresenter().isRequestInProgress()) {
            this$0.selectedImage = ImageType.BACK;
            this$0.getImageFromLibrary();
        }
    }

    private static final void setListeners$lambda-25$lambda-24(LibraryDocumentFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.getPresenter().isRequestInProgress()) {
            this$0.selectedImage = ImageType.SINGLE;
            this$0.getImageFromLibrary();
        }
    }

    public static final /* synthetic */ FragmentPhotoDocumentLibraryBinding access$getBinding(LibraryDocumentFragment $this) {
        return (FragmentPhotoDocumentLibraryBinding)$this.getBinding();
    }

    public static final /* synthetic */ ImageType access$getSelectedImage$p(LibraryDocumentFragment $this) {
        return $this.selectedImage;
    }

    static {
        String string2 = LibraryDocumentFragment.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LibraryDocumentFragment::class.java.simpleName");
        TAG = string2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/sdk/getidlib/ui/features/photo_document/LibraryDocumentFragment$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getidlib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

