/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.video_recording;

import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.model.data.repository.video_recording.VideoRecordingRepository;
import com.sdk.getidlib.model.entity.events.GetIDError;
import com.sdk.getidlib.presentation.features.video_recording.VideoRecordingContract;
import com.sdk.getidlib.presentation.global.BasePresenterImpl;
import com.sdk.getidlib.ui.common.ActionBarMode;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u001bH\u0016J\b\u0010&\u001a\u00020\u001bH\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lcom/sdk/getidlib/presentation/features/video_recording/VideoRecordingPresenter;", "Lcom/sdk/getidlib/presentation/global/BasePresenterImpl;", "Lcom/sdk/getidlib/presentation/features/video_recording/VideoRecordingContract$View;", "Lcom/sdk/getidlib/presentation/features/video_recording/VideoRecordingContract$Presenter;", "repository", "Lcom/sdk/getidlib/model/data/repository/video_recording/VideoRecordingRepository;", "(Lcom/sdk/getidlib/model/data/repository/video_recording/VideoRecordingRepository;)V", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "flowScreen", "getFlowScreen", "setFlowScreen", "formTitleScreen", "getFormTitleScreen", "setFormTitleScreen", "videoRecorded", "Ljava/io/File;", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/video_recording/VideoRecordingContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/video_recording/VideoRecordingContract$View;)V", "finishVideoRecordingStep", "", "getDuration", "", "getReadableText", "onCaptureClicked", "onClickToGoSettings", "onStart", "onStopVideo", "onVideoTaken", "file", "permissionDenied", "showPreview", "getidlib_release"})
public final class VideoRecordingPresenter
extends BasePresenterImpl<VideoRecordingContract.View>
implements VideoRecordingContract.Presenter {
    @NotNull
    private final VideoRecordingRepository repository;
    public VideoRecordingContract.View view;
    @Nullable
    private String flowScreen;
    @Nullable
    private String formTitleScreen;
    @Nullable
    private String eventScreenName;
    @Nullable
    private File videoRecorded;

    public VideoRecordingPresenter(@NotNull VideoRecordingRepository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
        this.flowScreen = Screens.VideoRecording.INSTANCE.getScreenKey();
        this.eventScreenName = "video";
    }

    @Override
    @NotNull
    public VideoRecordingContract.View getView() {
        VideoRecordingContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull VideoRecordingContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    @Override
    public void onStart() {
        super.onStart();
        VideoRecordingContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        VideoRecordingContract.View $this$onStart_u24lambda_u2d0 = view;
        boolean bl3 = false;
        $this$onStart_u24lambda_u2d0.changeToolbarMode(ActionBarMode.BACK);
        this.getView().changeTitleToolbar(Localization.Companion.translation(TranslationKey.VIDEO_SHARED_HEADER));
    }

    @Override
    public void onVideoTaken(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.videoRecorded = file;
        this.repository.saveVideo(file);
    }

    @Override
    public void permissionDenied() {
        this.getView().changeCameraPermissionLayoutVisibility(true);
    }

    @Override
    public void onClickToGoSettings() {
        this.getView().openAppSettings();
        this.getEventsRepository().verificationFlowFail(GetIDError.DENY_PERMISSION);
        this.getView().finish();
    }

    @Override
    public void onCaptureClicked() {
        VideoRecordingContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        VideoRecordingContract.View $this$onCaptureClicked_u24lambda_u2d1 = view;
        boolean bl3 = false;
        $this$onCaptureClicked_u24lambda_u2d1.stopVideo();
        $this$onCaptureClicked_u24lambda_u2d1.takeVideo();
    }

    @Override
    public void showPreview() {
        this.onClickAgree();
    }

    @Override
    @NotNull
    public String getReadableText() {
        return this.repository.getReadableText();
    }

    @Override
    public int getDuration() {
        return this.repository.getDuration();
    }

    @Override
    public void finishVideoRecordingStep() {
        this.onClickAgree();
    }

    @Override
    public void onStopVideo() {
        this.getView().stopVideo();
    }
}

