/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.photo_document;

import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.helpers.ValidationExtensionsKt;
import com.sdk.getidlib.internal.AcceptableDocumentsFilter;
import com.sdk.getidlib.internal.DocumentType;
import com.sdk.getidlib.internal.OCRResult;
import com.sdk.getidlib.internal.Result;
import com.sdk.getidlib.internal.Success;
import com.sdk.getidlib.internal.UploadFileError;
import com.sdk.getidlib.internal.UploadedDocument;
import com.sdk.getidlib.model.app.form.CategoryType;
import com.sdk.getidlib.model.app.form.FormField;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.form.FormRepository;
import com.sdk.getidlib.model.data.repository.setup.SetupRepository;
import com.sdk.getidlib.model.entity.documents.AgeRestrictions;
import com.sdk.getidlib.model.entity.documents.DocumentData;
import com.sdk.getidlib.model.entity.documents.DocumentSidesConclusionEnum;
import com.sdk.getidlib.model.entity.documents.Field;
import com.sdk.getidlib.model.entity.documents.Mask;
import com.sdk.getidlib.model.entity.documents.PhotoIssues;
import com.sdk.getidlib.presentation.features.document_type.DocumentConverter;
import com.sdk.getidlib.presentation.features.photo_document.DocumentState;
import com.sdk.getidlib.presentation.global.BaseContract;
import com.sdk.getidlib.presentation.global.BasePresenterImpl;
import com.sdk.getidlib.utils.FieldTranslationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c\u0012\b\u0012\u00060\u001dj\u0002`\u001e0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\b\u0010\u001f\u001a\u00020 H&J\u0012\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020 H&J\b\u0010%\u001a\u00020 H&J\u0018\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010)H\u0002J\u0017\u0010*\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010#H\u0000\u00a2\u0006\u0002\b,J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020'H\u0002J\u0018\u0010/\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00100\u001a\u00020\fH\u0004J(\u00101\u001a\u00020\f2\f\u00102\u001a\b\u0012\u0004\u0012\u00020'0)2\u0010\u00103\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010'\u0018\u00010)H\u0002J\b\u00104\u001a\u00020\fH\u0002J \u00105\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00100\u001a\u00020\f2\u0006\u00106\u001a\u00020\fH\u0002J\u0016\u00107\u001a\u00020 2\f\u00108\u001a\b\u0012\u0004\u0012\u0002090)H\u0004J&\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?H\u0002J\b\u0010@\u001a\u00020 H\u0002J\b\u0010A\u001a\u00020 H\u0002J\u0010\u0010B\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010B\u001a\u00020 2\b\u0010C\u001a\u0004\u0018\u00010'2\b\u0010D\u001a\u0004\u0018\u00010'H\u0002J\u0018\u0010E\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00106\u001a\u00020\fH&J\u0018\u0010F\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00106\u001a\u00020\fH&J\b\u0010G\u001a\u00020 H&R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006H"}, d2={"Lcom/sdk/getidlib/presentation/features/photo_document/PhotoDocumentAnalyzerPresenter;", "T", "Lcom/sdk/getidlib/presentation/global/BaseContract$View;", "Lcom/sdk/getidlib/presentation/global/BasePresenterImpl;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "formRepository", "Lcom/sdk/getidlib/model/data/repository/form/FormRepository;", "setupRepository", "Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;", "(Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;Lcom/sdk/getidlib/model/data/repository/form/FormRepository;Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;)V", "docTypeSingle", "", "getDocTypeSingle", "()Z", "setDocTypeSingle", "(Z)V", "getDocumentTypeRepository", "()Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "getFormRepository", "()Lcom/sdk/getidlib/model/data/repository/form/FormRepository;", "getSetupRepository", "()Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;", "checkRequiredFields", "responseData", "Lcom/sdk/getidlib/model/entity/documents/DocumentData;", "checkUploadedDocument", "Lcom/sdk/getidlib/internal/Result;", "Lcom/sdk/getidlib/internal/UploadedDocument;", "Lcom/sdk/getidlib/internal/UploadFileError;", "Lcom/sdk/getidlib/internal/UploadDocumentError;", "docSidesConclusionBackMissing", "", "docSidesConclusionBadPhoto", "issue", "Lcom/sdk/getidlib/model/entity/documents/PhotoIssues;", "docSidesConclusionFrontMissing", "docSidesConclusionOther", "getPhotoIssueForSide", "", "side", "", "getPhotoIssueMessage", "photoIssues", "getPhotoIssueMessage$getidlib_release", "getTranslateError", "error", "handleConclusion", "bFrontDoc", "isContainingRequiredFields", "requiredFields", "extractedFields", "isPrefillRequired", "proceedWithDoc", "bCanProceed", "saveMrz", "fields", "Lcom/sdk/getidlib/model/entity/documents/Field;", "setPrefillField", "type", "Lcom/sdk/getidlib/model/app/form/CategoryType;", "content", "mask", "Lcom/sdk/getidlib/model/entity/documents/Mask;", "showAcceptableCountryError", "showAcceptableDocumentsError", "updateComposition", "issuingCountry", "documentType", "uploadConclusionBackSideMissing", "uploadConclusionOk", "uploadConclusionOther", "getidlib_release"})
public abstract class PhotoDocumentAnalyzerPresenter<T extends BaseContract.View>
extends BasePresenterImpl<T> {
    @NotNull
    private final DocumentTypeRepository documentTypeRepository;
    @NotNull
    private final FormRepository formRepository;
    @NotNull
    private final SetupRepository setupRepository;
    private boolean docTypeSingle;

    public PhotoDocumentAnalyzerPresenter(@NotNull DocumentTypeRepository documentTypeRepository, @NotNull FormRepository formRepository, @NotNull SetupRepository setupRepository) {
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        Intrinsics.checkNotNullParameter((Object)formRepository, (String)"formRepository");
        Intrinsics.checkNotNullParameter((Object)setupRepository, (String)"setupRepository");
        this.documentTypeRepository = documentTypeRepository;
        this.formRepository = formRepository;
        this.setupRepository = setupRepository;
        this.docTypeSingle = true;
    }

    @NotNull
    public final DocumentTypeRepository getDocumentTypeRepository() {
        return this.documentTypeRepository;
    }

    @NotNull
    public final FormRepository getFormRepository() {
        return this.formRepository;
    }

    @NotNull
    public final SetupRepository getSetupRepository() {
        return this.setupRepository;
    }

    public final boolean getDocTypeSingle() {
        return this.docTypeSingle;
    }

    public final void setDocTypeSingle(boolean bl) {
        this.docTypeSingle = bl;
    }

    protected final void handleConclusion(@NotNull DocumentData responseData, boolean bFrontDoc) {
        String message;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"responseData");
        Object object = responseData.getConclusion();
        if ((Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.ALL_SIDES_PROVIDED.getValue()) ? true : Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.OK.getValue())) ? true : Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.DIFFERENT_DOCUMENTS.getValue())) {
            this.updateComposition(responseData);
            if (this.checkRequiredFields(responseData)) {
                this.proceedWithDoc(responseData, bFrontDoc, true);
            } else {
                this.docSidesConclusionOther();
            }
        } else if (Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.FRONT_SIDE_MISSING.getValue())) {
            this.updateComposition(responseData);
            this.docSidesConclusionFrontMissing();
            if (!bFrontDoc) {
                this.proceedWithDoc(responseData, bFrontDoc, true);
            }
        } else if (Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.BACK_SIDE_MISSING.getValue())) {
            this.updateComposition(responseData);
            this.docSidesConclusionBackMissing();
            if (bFrontDoc) {
                this.proceedWithDoc(responseData, bFrontDoc, false);
            }
        } else if (Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.UNACCEPTABLE_DOCUMENT_TYPE.getValue())) {
            this.docSidesConclusionOther();
            this.showAcceptableDocumentsError();
        } else if (Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.PHOTO_ISSUES.getValue())) {
            this.docSidesConclusionBadPhoto(responseData.getPhotoIssues());
        } else if (Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.UNKNOWN_SIDES.getValue())) {
            this.docSidesConclusionOther();
            ((BaseContract.View)this.getView()).showErrorDialog(Localization.Companion.translation(TranslationKey.DOCUMENT_BADPHOTO_NODOCUMENT), Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_PLEASERETAKE));
        } else if (Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.EXPIRED.getValue())) {
            ((BaseContract.View)this.getView()).showErrorDialog(Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ERROR), Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_EXPIRED));
        } else if (Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.TOO_YOUNG.getValue())) {
            Integer n;
            String string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_TOOYOUNG);
            AgeRestrictions ageRestrictions = responseData.getAgeRestrictions();
            Object[] objectArray = new Object[]{ageRestrictions == null ? 18 : ((n = ageRestrictions.getMin()) == null ? 18 : n)};
            bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
            message = string3;
            ((BaseContract.View)this.getView()).showErrorDialog(Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ERROR), message);
        } else if (Intrinsics.areEqual((Object)object, (Object)DocumentSidesConclusionEnum.TOO_OLD.getValue())) {
            Integer n;
            String string4 = Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_TOOOLD);
            AgeRestrictions ageRestrictions = responseData.getAgeRestrictions();
            Object[] objectArray = new Object[]{ageRestrictions == null ? 99 : ((n = ageRestrictions.getMax()) == null ? 99 : n)};
            bl = false;
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(this, *args)");
            message = string5;
            ((BaseContract.View)this.getView()).showErrorDialog(Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ERROR), message);
        }
        object = responseData.getExtractedData();
        if (object != null) {
            Object object2 = object;
            boolean bl2 = false;
            boolean bl3 = false;
            Object list = object2;
            boolean bl4 = false;
            this.saveMrz((List<Field>)list);
        }
    }

    private final void proceedWithDoc(DocumentData responseData, boolean bFrontDoc, boolean bCanProceed) {
        if (bFrontDoc && bCanProceed) {
            this.documentTypeRepository.setBackId(null);
        }
        Result<UploadedDocument, UploadFileError> filter = this.checkUploadedDocument(responseData);
        UploadedDocument.Conclusion conclusion = ((UploadedDocument)((Success)filter).getValue()).getConclusion();
        int n = WhenMappings.$EnumSwitchMapping$0[conclusion.ordinal()];
        switch (n) {
            case 1: {
                this.uploadConclusionOk(responseData, bCanProceed);
                break;
            }
            case 2: {
                this.uploadConclusionBackSideMissing(responseData, bCanProceed);
                break;
            }
            case 3: {
                this.docSidesConclusionOther();
                this.showAcceptableDocumentsError();
                break;
            }
            case 4: {
                this.docSidesConclusionOther();
                this.showAcceptableCountryError();
                break;
            }
            default: {
                this.uploadConclusionOther();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkRequiredFields(DocumentData responseData) {
        List list;
        List<String> requiredFields = this.documentTypeRepository.getRequiredFields();
        List<Field> list2 = responseData.getExtractedData();
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Field it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Field)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it.getContent();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = !(charSequence == null || charSequence.length() == 0);
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            $this$filter$iv = list3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Field)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.getFieldType();
                collection.add(string2);
            }
            list = (List)destination$iv$iv;
        }
        List extractedFields = list;
        return this.isContainingRequiredFields(requiredFields, extractedFields);
    }

    private final boolean isContainingRequiredFields(List<String> requiredFields, List<String> extractedFields) {
        boolean bl;
        Collection collection = requiredFields;
        boolean bl2 = false;
        boolean bl3 = false;
        if (collection == null || collection.isEmpty() || extractedFields == null) {
            return true;
        }
        String error = null;
        error = Intrinsics.stringPlus((String)Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MISSINGREQUIREDFIELDS), (Object)"\n");
        Iterator<String> $this$forEach$iv = requiredFields.iterator();
        boolean $i$f$forEach = false;
        Iterator<String> iterator = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String element$iv;
            String requiredField = element$iv = iterator2.next();
            boolean bl5 = false;
            if (extractedFields.contains(requiredField)) continue;
            error = error + FieldTranslationHelper.INSTANCE.getTranslatedField(requiredField) + '\n';
        }
        if (Intrinsics.areEqual((Object)error, (Object)Intrinsics.stringPlus((String)Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MISSINGREQUIREDFIELDS), (Object)"\n"))) {
            bl = true;
        } else {
            ((BaseContract.View)this.getView()).showErrorDialog(Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ERROR), error);
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected final Result<UploadedDocument, UploadFileError> checkUploadedDocument(@NotNull DocumentData responseData) {
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"responseData");
        Object object = responseData.getFileIds();
        String string2 = object == null ? null : object.getFront();
        object = responseData.getFileIds();
        UploadedDocument.FileIDs fileIDs = new UploadedDocument.FileIDs(string2, object == null ? null : object.getBack());
        String string3 = responseData.getConclusion();
        object = UploadedDocument.Conclusion.Companion.getConclusion(string3 == null ? "ok" : string3);
        UploadedDocument uploadedDocument = new UploadedDocument(fileIDs, (UploadedDocument.Conclusion)((Object)(object == null ? UploadedDocument.Conclusion.OK : object)), new OCRResult(responseData.getIssuingCountry(), DocumentType.Companion.getDocumentType(responseData.getDocumentType()), null, 4, null), null);
        AcceptableDocumentsFilter acceptableDocumentsFilter = new AcceptableDocumentsFilter();
        Map<String, List<DocumentType>> acceptableDocumentsServer = this.setupRepository.getAcceptableDocumentsFromServer();
        Map<String, List<DocumentType>> acceptableDocumentsClient = this.setupRepository.getAcceptableDocumentsFromClient();
        return acceptableDocumentsFilter.check(uploadedDocument, acceptableDocumentsServer, acceptableDocumentsClient);
    }

    @NotNull
    public final String getPhotoIssueMessage$getidlib_release(@Nullable PhotoIssues photoIssues) {
        String errorMessage = ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE);
        Object object = photoIssues;
        object = object == null ? null : ((PhotoIssues)object).getFront();
        boolean bl = false;
        boolean bl2 = false;
        if (!(object == null || object.isEmpty())) {
            object = photoIssues;
            errorMessage = Intrinsics.stringPlus((String)errorMessage, (Object)this.getPhotoIssueForSide(object == null ? null : ((PhotoIssues)object).getFront()));
        } else {
            object = photoIssues;
            object = object == null ? null : ((PhotoIssues)object).getBack();
            bl = false;
            bl2 = false;
            if (!(object == null || object.isEmpty())) {
                object = photoIssues;
                errorMessage = Intrinsics.stringPlus((String)errorMessage, (Object)this.getPhotoIssueForSide(object == null ? null : ((PhotoIssues)object).getBack()));
            }
        }
        object = errorMessage;
        bl = false;
        return object.length() == 0 ? Localization.Companion.translation(TranslationKey.DOCUMENT_BADPHOTO_NODOCUMENT) : errorMessage;
    }

    private final void showAcceptableDocumentsError() {
        ((BaseContract.View)this.getView()).showErrorDialog(Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_UNACCEPTABLEDOCUMENTTYPE), ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE));
    }

    private final void showAcceptableCountryError() {
        ((BaseContract.View)this.getView()).showErrorDialog(Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_UNACCEPTABLECOUNTRY), ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE));
    }

    private final boolean isPrefillRequired() {
        return this.documentTypeRepository.getPrefillRequired();
    }

    private final String getPhotoIssueForSide(List<String> side) {
        String errorMessage = null;
        errorMessage = ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE);
        if (side != null) {
            if (side.size() == 1) {
                errorMessage = Intrinsics.stringPlus((String)errorMessage, (Object)this.getTranslateError(side.get(0)));
            } else {
                errorMessage = errorMessage + Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MULTIPLEISSUES) + ":\n\n";
                Iterator<String> $this$forEach$iv = side.iterator();
                boolean $i$f$forEach = false;
                Iterator<String> iterator = $this$forEach$iv;
                boolean bl = false;
                Iterator<String> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    String element$iv;
                    String it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    errorMessage = errorMessage + this.getTranslateError(it) + "\n\n";
                }
            }
        }
        return errorMessage;
    }

    protected final void saveMrz(@NotNull List<Field> fields) {
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Iterator<Field> $this$forEach$iv = fields.iterator();
        boolean $i$f$forEach = false;
        Iterator<Field> iterator = $this$forEach$iv;
        boolean bl = false;
        Iterator<Field> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String string2;
            Field element$iv;
            Field field = element$iv = iterator2.next();
            boolean bl2 = false;
            if (!this.isPrefillRequired() || (string2 = field.getFieldType()) == null) continue;
            int n = -1;
            switch (string2.hashCode()) {
                case -1147692044: {
                    if (string2.equals("address")) {
                        n = 1;
                    }
                    break;
                }
                case 92847548: {
                    if (string2.equals("nationality")) {
                        n = 2;
                    }
                    break;
                }
                case -1249512767: {
                    if (string2.equals("gender")) {
                        n = 3;
                    }
                    break;
                }
                case 1866867874: {
                    if (string2.equals("date-of-issue")) {
                        n = 4;
                    }
                    break;
                }
                case 1928329866: {
                    if (string2.equals("date-of-expiry")) {
                        n = 5;
                    }
                    break;
                }
                case 1860104328: {
                    if (string2.equals("date-of-birth")) {
                        n = 6;
                    }
                    break;
                }
                case 113766: {
                    if (string2.equals("sex")) {
                        n = 3;
                    }
                    break;
                }
                case 1716981819: {
                    if (string2.equals("document-number")) {
                        n = 7;
                    }
                    break;
                }
                case -1373923466: {
                    if (string2.equals("personal-number")) {
                        n = 8;
                    }
                    break;
                }
                case -207161464: {
                    if (string2.equals("first-name")) {
                        n = 9;
                    }
                    break;
                }
                case 1966946146: {
                    if (string2.equals("last-name")) {
                        n = 10;
                    }
                    break;
                }
            }
            switch (n) {
                case 9: {
                    this.setPrefillField(CategoryType.FIRST_NAME, field.getContent(), field.getMask());
                    break;
                }
                case 10: {
                    this.setPrefillField(CategoryType.LAST_NAME, field.getContent(), field.getMask());
                    break;
                }
                case 2: {
                    PhotoDocumentAnalyzerPresenter.setPrefillField$default(this, CategoryType.NATIONALITY, field.getContent(), null, 4, null);
                    break;
                }
                case 3: {
                    PhotoDocumentAnalyzerPresenter.setPrefillField$default(this, CategoryType.SEX, field.getContent(), null, 4, null);
                    break;
                }
                case 6: {
                    PhotoDocumentAnalyzerPresenter.setPrefillField$default(this, CategoryType.DATE_OF_BIRTH, field.getContent(), null, 4, null);
                    break;
                }
                case 1: {
                    PhotoDocumentAnalyzerPresenter.setPrefillField$default(this, CategoryType.ADDRESS, field.getContent(), null, 4, null);
                    break;
                }
                case 8: {
                    PhotoDocumentAnalyzerPresenter.setPrefillField$default(this, CategoryType.PERSONAL_NUMBER, field.getContent(), null, 4, null);
                    break;
                }
                case 7: {
                    PhotoDocumentAnalyzerPresenter.setPrefillField$default(this, CategoryType.DOCUMENT_NUMBER, field.getContent(), null, 4, null);
                    break;
                }
                case 4: {
                    PhotoDocumentAnalyzerPresenter.setPrefillField$default(this, CategoryType.DATE_OF_ISSUE, field.getContent(), null, 4, null);
                    break;
                }
                case 5: {
                    PhotoDocumentAnalyzerPresenter.setPrefillField$default(this, CategoryType.DATE_OF_EXPIRY, field.getContent(), null, 4, null);
                }
            }
        }
    }

    private final void setPrefillField(CategoryType type, String content, Mask mask) {
        for (ArrayList<FormField> fields : this.formRepository.getFormFields().values()) {
            Iterator<FormField> iterator = fields.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"fields.iterator()");
            Iterator<FormField> $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator<FormField> iterator2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<FormField> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                FormField element$iv;
                FormField it = element$iv = iterator3.next();
                boolean bl2 = false;
                if (it.getCategory() != type) continue;
                CharSequence charSequence = it.getValue();
                boolean bl3 = false;
                if (!(charSequence.length() == 0)) continue;
                String string2 = content;
                Intrinsics.checkNotNull((Object)string2);
                it.setValue(string2);
                it.setMask(mask);
            }
        }
    }

    static /* synthetic */ void setPrefillField$default(PhotoDocumentAnalyzerPresenter photoDocumentAnalyzerPresenter, CategoryType categoryType, String string2, Mask mask, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setPrefillField");
        }
        if ((n & 4) != 0) {
            mask = null;
        }
        photoDocumentAnalyzerPresenter.setPrefillField(categoryType, string2, mask);
    }

    private final String getTranslateError(String error) {
        String string2;
        switch (error) {
            case "document-border-is-out-of-frame": {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_OUTOFFRAME);
                break;
            }
            case "document-is-close-to-borders": {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_CLOSETOBORDERS);
                break;
            }
            case "blur": {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_BLUR);
                break;
            }
            case "dark": {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_DARK);
                break;
            }
            case "glare": {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_GLARE);
                break;
            }
            default: {
                string2 = ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE);
            }
        }
        return string2;
    }

    private final void updateComposition(DocumentData responseData) {
        DocumentState composition = DocumentConverter.INSTANCE.getDocumentCompositionByName(responseData.getComposition());
        if (composition != null) {
            this.documentTypeRepository.setComposition(composition);
            this.docTypeSingle = composition == DocumentState.SINGLE;
        } else {
            this.updateComposition(responseData.getIssuingCountry(), responseData.getDocumentType());
        }
    }

    private final void updateComposition(String issuingCountry, String documentType) {
        CharSequence charSequence = issuingCountry;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = documentType;
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                DocumentState composition = DocumentConverter.INSTANCE.getDocumentComposition(Localization.Companion.getCountryByShortName(issuingCountry), documentType);
                this.documentTypeRepository.setComposition(composition);
                this.docTypeSingle = composition == DocumentState.SINGLE;
            }
        }
    }

    public abstract void docSidesConclusionFrontMissing();

    public abstract void docSidesConclusionBackMissing();

    public void docSidesConclusionBadPhoto(@Nullable PhotoIssues issue) {
        ((BaseContract.View)this.getView()).showErrorDialog(Localization.Companion.translation(TranslationKey.DOCUMENT_BADPHOTO_NODOCUMENT), Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_PLEASERETAKE));
    }

    public abstract void docSidesConclusionOther();

    public abstract void uploadConclusionOk(@NotNull DocumentData var1, boolean var2);

    public abstract void uploadConclusionBackSideMissing(@NotNull DocumentData var1, boolean var2);

    public abstract void uploadConclusionOther();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UploadedDocument.Conclusion.values().length];
            nArray[UploadedDocument.Conclusion.OK.ordinal()] = 1;
            nArray[UploadedDocument.Conclusion.BACK_SIDE_MISSING.ordinal()] = 2;
            nArray[UploadedDocument.Conclusion.UNACCEPTABLE_DOCUMENT_TYPE.ordinal()] = 3;
            nArray[UploadedDocument.Conclusion.UNACCEPTABLE_COUNTRY.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

