/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.photo_document;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.app.utils.FileEncodeUtils;
import com.sdk.getidlib.helpers.ValidationExtensionsKt;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.events.EventsRepository;
import com.sdk.getidlib.model.data.repository.form.FormRepository;
import com.sdk.getidlib.model.data.repository.photo.PhotoRepository;
import com.sdk.getidlib.model.data.repository.setup.SetupRepository;
import com.sdk.getidlib.model.entity.documents.DocumentData;
import com.sdk.getidlib.model.entity.documents.FileIds;
import com.sdk.getidlib.model.entity.documents.PhotoIssues;
import com.sdk.getidlib.model.entity.events.GetIDError;
import com.sdk.getidlib.presentation.features.photo_document.DocumentState;
import com.sdk.getidlib.presentation.features.photo_document.LibraryPhotoDocumentContract;
import com.sdk.getidlib.presentation.features.photo_document.PhotoDocumentAnalyzerPresenter;
import com.sdk.getidlib.ui.common.ActionBarMode;
import com.sdk.getidlib.ui.features.photo_document.ImageType;
import java.io.File;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0016J\b\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020&H\u0002J\b\u0010*\u001a\u00020&H\u0002J\b\u0010+\u001a\u00020&H\u0016J\u0012\u0010,\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020&H\u0016J\b\u00100\u001a\u00020&H\u0016J\b\u00101\u001a\u00020\u001fH\u0016J\b\u00102\u001a\u00020\u001fH\u0016J\b\u00103\u001a\u00020&H\u0016J\b\u00104\u001a\u00020&H\u0016J\b\u00105\u001a\u00020&H\u0016J\u0018\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001cH\u0002J \u00109\u001a\u00020&2\u0006\u00108\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020&H\u0002J\u0018\u0010>\u001a\u00020&2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001fH\u0016J\u0018\u0010B\u001a\u00020&2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001fH\u0016J\b\u0010C\u001a\u00020&H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006D"}, d2={"Lcom/sdk/getidlib/presentation/features/photo_document/LibraryDocumentPresenter;", "Lcom/sdk/getidlib/presentation/features/photo_document/PhotoDocumentAnalyzerPresenter;", "Lcom/sdk/getidlib/presentation/features/photo_document/LibraryPhotoDocumentContract$View;", "Lcom/sdk/getidlib/presentation/features/photo_document/LibraryPhotoDocumentContract$Presenter;", "repository", "Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "formRepository", "Lcom/sdk/getidlib/model/data/repository/form/FormRepository;", "setupRepository", "Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;", "(Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;Lcom/sdk/getidlib/model/data/repository/form/FormRepository;Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;)V", "context", "Landroid/content/Context;", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "flowScreen", "getFlowScreen", "setFlowScreen", "formTitleScreen", "getFormTitleScreen", "setFormTitleScreen", "imageBackSide", "Landroid/graphics/Bitmap;", "imageFrontSide", "requestSend", "", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/photo_document/LibraryPhotoDocumentContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/photo_document/LibraryPhotoDocumentContract$View;)V", "changeAcceptButtonState", "", "acceptButtonEnabled", "changeToolbarTitle", "checkDocumentPhotoState", "clearImageSideState", "docSidesConclusionBackMissing", "docSidesConclusionBadPhoto", "issue", "Lcom/sdk/getidlib/model/entity/documents/PhotoIssues;", "docSidesConclusionFrontMissing", "docSidesConclusionOther", "isRTL", "isRequestInProgress", "onClickToGoSettings", "onStart", "permissionDenied", "photoSideMissing", "isFrontMissing", "image", "saveImage", "requireContext", "imageType", "Lcom/sdk/getidlib/ui/features/photo_document/ImageType;", "sendEventOpenedScreen", "uploadConclusionBackSideMissing", "responseData", "Lcom/sdk/getidlib/model/entity/documents/DocumentData;", "bCanProceed", "uploadConclusionOk", "uploadConclusionOther", "getidlib_release"})
public final class LibraryDocumentPresenter
extends PhotoDocumentAnalyzerPresenter<LibraryPhotoDocumentContract.View>
implements LibraryPhotoDocumentContract.Presenter {
    @NotNull
    private final PhotoRepository repository;
    public LibraryPhotoDocumentContract.View view;
    @Nullable
    private String flowScreen;
    @Nullable
    private String formTitleScreen;
    @Nullable
    private String eventScreenName;
    private boolean requestSend;
    @Nullable
    private Context context;
    @Nullable
    private Bitmap imageFrontSide;
    @Nullable
    private Bitmap imageBackSide;

    public LibraryDocumentPresenter(@NotNull PhotoRepository repository, @NotNull DocumentTypeRepository documentTypeRepository, @NotNull FormRepository formRepository, @NotNull SetupRepository setupRepository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        Intrinsics.checkNotNullParameter((Object)formRepository, (String)"formRepository");
        Intrinsics.checkNotNullParameter((Object)setupRepository, (String)"setupRepository");
        super(documentTypeRepository, formRepository, setupRepository);
        this.repository = repository;
        this.flowScreen = Screens.LibraryPhotoDocument.INSTANCE.getScreenKey();
        this.eventScreenName = "document-from-gallery";
        File file = this.repository.getFrontDocumentMedia();
        this.imageFrontSide = BitmapFactory.decodeFile((String)(file == null ? null : file.getPath()));
        file = this.repository.getBackDocumentMedia();
        this.imageBackSide = BitmapFactory.decodeFile((String)(file == null ? null : file.getPath()));
    }

    @Override
    @NotNull
    public LibraryPhotoDocumentContract.View getView() {
        LibraryPhotoDocumentContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull LibraryPhotoDocumentContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    @Override
    public void onStart() {
        Object object;
        this.updateCurrentFlowScreen();
        this.initStateButtonAgree();
        this.initAgreeButtonTitle();
        LibraryPhotoDocumentContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        LibraryPhotoDocumentContract.View $this$onStart_u24lambda_u2d0 = view;
        boolean bl3 = false;
        $this$onStart_u24lambda_u2d0.changeToolbarMode(ActionBarMode.BACK);
        this.checkDocumentPhotoState();
        this.changeToolbarTitle();
        if (this.repository.getBackDocumentMedia() != null) {
            this.getView().setDocState(this.getDocumentTypeRepository().getComposition());
            Object object2 = this.repository.getBackDocumentMedia();
            view = BitmapFactory.decodeFile((String)(object2 == null ? null : ((File)object2).getPath()));
            if (view != null) {
                object2 = view;
                bl2 = false;
                boolean bl4 = false;
                Object it = object2;
                boolean bl5 = false;
                this.getView().showBackPreview((Bitmap)it);
            }
        }
        if ((view = BitmapFactory.decodeFile((String)((object = this.repository.getFrontDocumentMedia()) == null ? null : ((File)object).getPath()))) != null) {
            object = view;
            bl2 = false;
            boolean bl6 = false;
            Object it = object;
            boolean bl7 = false;
            this.getView().showFrontPreview((Bitmap)it, this.getDocTypeSingle());
        }
        this.getDocumentTypeRepository().isFromGallery(true);
        this.sendEventOpenedScreen();
    }

    @Override
    public void permissionDenied() {
        this.getView().changeCameraPermissionLayoutVisibility(true);
    }

    @Override
    public void onClickToGoSettings() {
        this.getView().openAppSettings();
        this.getEventsRepository().verificationFlowFail(GetIDError.DENY_PERMISSION);
        this.getView().finish();
    }

    @Override
    public void changeAcceptButtonState(boolean acceptButtonEnabled) {
        boolean buttonEnabled = false;
        if (acceptButtonEnabled) {
            buttonEnabled = true;
        } else {
            buttonEnabled = false;
            if (this.getDocTypeSingle() && this.imageFrontSide != null) {
                buttonEnabled = true;
            } else if (this.imageFrontSide != null && this.imageBackSide != null) {
                buttonEnabled = true;
            }
        }
        this.getView().changeAcceptButtonState(buttonEnabled);
    }

    private final void clearImageSideState() {
        this.imageFrontSide = null;
        this.imageBackSide = null;
    }

    private final void checkDocumentPhotoState() {
        DocumentState docState = this.getDocumentTypeRepository().getComposition();
        this.getView().setDocState(docState);
    }

    private final void changeToolbarTitle() {
        this.getView().changeTitleToolbar(Localization.Companion.translation(TranslationKey.DOCUMENT_SHARED_DOCUMENTPHOTO));
    }

    private final void sendEventOpenedScreen() {
        this.setEventScreenName(this.getDocTypeSingle() ? "front-or-single" : "front");
        EventsRepository eventsRepository2 = this.getEventsRepository();
        String string2 = this.getEventScreenName();
        Intrinsics.checkNotNull((Object)string2);
        eventsRepository2.sendStatusOpenedScreen(string2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ LibraryDocumentPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LibraryDocumentPresenter.access$showDialogEaAlreadyExists(this.this$0);
            }
        }));
    }

    @Override
    public void saveImage(@NotNull Bitmap image, @NotNull Context requireContext, @NotNull ImageType imageType) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)requireContext, (String)"requireContext");
        Intrinsics.checkNotNullParameter((Object)((Object)imageType), (String)"imageType");
        ImageType imageType2 = imageType;
        int n = WhenMappings.$EnumSwitchMapping$0[imageType2.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                Bitmap bitmap = this.imageFrontSide = new FileEncodeUtils().scaleDocumentImage(image);
                if (bitmap == null) break;
                Bitmap bitmap2 = bitmap;
                boolean bl = false;
                boolean bl2 = false;
                Bitmap it = bitmap2;
                boolean bl3 = false;
                File imageFile = new FileEncodeUtils().getImageFile(Intrinsics.stringPlus((String)requireContext.getFilesDir().getAbsolutePath(), (Object)"document_image_front"), it);
                this.repository.onUpdateFrontDocumentMedia(imageFile);
                break;
            }
            case 3: {
                Bitmap bitmap = this.imageBackSide = new FileEncodeUtils().scaleDocumentImage(image);
                if (bitmap == null) break;
                Bitmap bitmap3 = bitmap;
                boolean bl = false;
                boolean bl4 = false;
                Bitmap it = bitmap3;
                boolean bl5 = false;
                File imageFile = new FileEncodeUtils().getImageFile(Intrinsics.stringPlus((String)requireContext.getFilesDir().getAbsolutePath(), (Object)"document_image_back"), image);
                this.repository.onUpdateBackDocumentMedia(imageFile);
            }
        }
        this.context = requireContext;
        this.getView().showLoading();
        if (!this.requestSend) {
            this.requestSend = true;
            this.getView().changeAcceptButtonState(false);
            imageType2 = (Function1)new Function1<Continuation<? super Response<DocumentData>>, Object>(this, null){
                int label;
                final /* synthetic */ LibraryDocumentPresenter this$0;
                {
                    this.this$0 = $receiver;
                    super(1, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.getDocumentTypeRepository().sendDocument((Continuation<? super Response<DocumentData>>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@Nullable Continuation<? super Response<DocumentData>> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            };
            n = 0;
            this.doRequest(true, imageType2, (Function1)new Function1<DocumentData, Unit>(this){
                final /* synthetic */ LibraryDocumentPresenter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable DocumentData it) {
                    LibraryDocumentPresenter.access$setRequestSend$p(this.this$0, false);
                    DocumentData documentData = it;
                    Integer n = documentData == null ? null : documentData.getResponseCode();
                    documentData = new IntRange(200, 299);
                    boolean bl = false;
                    if (n != null && documentData.contains(n)) {
                        DocumentData documentData2 = it;
                        Intrinsics.checkNotNull((Object)documentData2);
                        this.this$0.handleConclusion(documentData2, true);
                    } else {
                        Integer n2 = n;
                        int n3 = 400;
                        if (n2 != null && n2 == n3) {
                            this.this$0.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.ERRORS_SHARED_BADREQUEST), Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_PLEASERETAKE));
                        }
                    }
                    this.this$0.getView().hideLoading();
                }
            });
        }
    }

    @Override
    public void docSidesConclusionFrontMissing() {
        this.checkDocumentPhotoState();
        if (!this.getDocTypeSingle() && this.imageFrontSide != null) {
            if (this.getDocumentTypeRepository().getComposition() != DocumentState.TOP_BOTTOM) {
                this.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ERROR), Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MISSINGFRONTSIDE));
            } else {
                this.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ERROR), Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MISSINGBOTTOMPAGE));
            }
        }
        this.getView().clearPreview(true);
        if (this.imageBackSide != null) {
            FileEncodeUtils fileEncodeUtils = new FileEncodeUtils();
            Bitmap bitmap = this.imageBackSide;
            Intrinsics.checkNotNull((Object)bitmap);
            Bitmap bitmap2 = this.imageBackSide = fileEncodeUtils.scaleDocumentImage(bitmap);
            if (bitmap2 != null) {
                File file;
                Bitmap bitmap3 = bitmap2;
                boolean bl = false;
                boolean bl2 = false;
                Bitmap it = bitmap3;
                boolean bl3 = false;
                Context context = this.context;
                File imageFile = new FileEncodeUtils().getImageFile(Intrinsics.stringPlus(context == null ? null : ((file = context.getFilesDir()) == null ? null : file.getAbsolutePath()), (Object)"document_image_back"), it);
                this.repository.onUpdateBackDocumentMedia(imageFile);
            }
            Bitmap bitmap4 = this.imageBackSide;
            Intrinsics.checkNotNull((Object)bitmap4);
            this.photoSideMissing(true, bitmap4);
            LibraryPhotoDocumentContract.View view = this.getView();
            Bitmap bitmap5 = this.imageBackSide;
            Intrinsics.checkNotNull((Object)bitmap5);
            view.showBackPreview(bitmap5);
        }
    }

    @Override
    public void docSidesConclusionBackMissing() {
        this.checkDocumentPhotoState();
        if (!this.getDocTypeSingle() && this.imageBackSide != null) {
            if (this.getDocumentTypeRepository().getComposition() != DocumentState.TOP_BOTTOM) {
                this.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ERROR), Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MISSINGBACKSIDE));
            } else {
                this.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_ERROR), Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MISSINGTOPPAGE));
            }
        }
        LibraryPhotoDocumentContract.View view = this.getView();
        Bitmap bitmap = this.imageFrontSide;
        Intrinsics.checkNotNull((Object)bitmap);
        view.showFrontPreview(bitmap, false);
        Bitmap bitmap2 = this.imageFrontSide;
        Intrinsics.checkNotNull((Object)bitmap2);
        this.photoSideMissing(false, bitmap2);
    }

    @Override
    public void docSidesConclusionBadPhoto(@Nullable PhotoIssues issue) {
        this.getView().showErrorDialog(this.getPhotoIssueMessage$getidlib_release(issue), ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE));
    }

    @Override
    public void docSidesConclusionOther() {
    }

    @Override
    public void uploadConclusionOk(@NotNull DocumentData responseData, boolean bCanProceed) {
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"responseData");
        FileIds fileIds = responseData.getFileIds();
        if (fileIds != null) {
            FileIds fileIds2 = fileIds;
            boolean bl = false;
            boolean bl2 = false;
            FileIds ids = fileIds2;
            boolean bl3 = false;
            this.getDocumentTypeRepository().setFrontId(ids.getFront());
            String string2 = ids.getBack();
            if (string2 != null) {
                String string3 = string2;
                boolean bl4 = false;
                boolean bl5 = false;
                String back = string3;
                boolean bl6 = false;
                this.getDocumentTypeRepository().setBackId(back);
            }
        }
        this.changeAcceptButtonState(bCanProceed);
    }

    @Override
    public void uploadConclusionBackSideMissing(@NotNull DocumentData responseData, boolean bCanProceed) {
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"responseData");
    }

    @Override
    public void uploadConclusionOther() {
    }

    @Override
    public boolean isRequestInProgress() {
        return this.requestSend;
    }

    @Override
    public boolean isRTL() {
        return this.getDocumentTypeRepository().getIsRTL();
    }

    private final void photoSideMissing(boolean isFrontMissing, Bitmap image) {
        this.clearImageSideState();
        if (isFrontMissing) {
            this.imageBackSide = image;
        } else {
            this.imageFrontSide = image;
        }
        this.changeAcceptButtonState(false);
    }

    public static final /* synthetic */ void access$showDialogEaAlreadyExists(LibraryDocumentPresenter $this) {
        $this.showDialogEaAlreadyExists();
    }

    public static final /* synthetic */ void access$setRequestSend$p(LibraryDocumentPresenter $this, boolean bl) {
        $this.requestSend = bl;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageType.values().length];
            nArray[ImageType.FRONT.ordinal()] = 1;
            nArray[ImageType.SINGLE.ordinal()] = 2;
            nArray[ImageType.BACK.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

