/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.photo_document;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.app.utils.FileEncodeUtils;
import com.sdk.getidlib.model.app.navigation.ScreenFlowItem;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.events.EventsRepository;
import com.sdk.getidlib.model.data.repository.form.FormRepository;
import com.sdk.getidlib.model.data.repository.photo.PhotoRepository;
import com.sdk.getidlib.model.data.repository.setup.SetupRepository;
import com.sdk.getidlib.model.entity.documents.DocumentData;
import com.sdk.getidlib.model.entity.documents.FileIds;
import com.sdk.getidlib.presentation.features.photo_document.BasePhotoDocumentPresenter;
import com.sdk.getidlib.presentation.features.photo_document.DocumentState;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020\u001bH\u0002J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0019H\u0016J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0019H\u0016J\b\u0010*\u001a\u00020\u001bH\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/sdk/getidlib/presentation/features/photo_document/FrontPhotoDocumentPresenter;", "Lcom/sdk/getidlib/presentation/features/photo_document/BasePhotoDocumentPresenter;", "repository", "Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "formRepository", "Lcom/sdk/getidlib/model/data/repository/form/FormRepository;", "setupRepository", "Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;", "(Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;Lcom/sdk/getidlib/model/data/repository/form/FormRepository;Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;)V", "context", "Landroid/content/Context;", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "flowScreen", "getFlowScreen", "setFlowScreen", "imageFrontSide", "Landroid/graphics/Bitmap;", "isRequestInProgress", "", "changeToolbarTitle", "", "docSidesConclusionBackMissing", "docSidesConclusionFrontMissing", "docSidesConclusionOther", "onRetakeClicked", "onStart", "onUsePhotoClicked", "saveImage", "image", "sendEventOpenedScreen", "uploadConclusionBackSideMissing", "responseData", "Lcom/sdk/getidlib/model/entity/documents/DocumentData;", "bCanProceed", "uploadConclusionOk", "uploadConclusionOther", "getidlib_release"})
public final class FrontPhotoDocumentPresenter
extends BasePhotoDocumentPresenter {
    @Nullable
    private String flowScreen;
    @Nullable
    private String eventScreenName;
    @Nullable
    private Context context;
    @Nullable
    private Bitmap imageFrontSide;
    private boolean isRequestInProgress;

    public FrontPhotoDocumentPresenter(@NotNull PhotoRepository repository, @NotNull DocumentTypeRepository documentTypeRepository, @NotNull FormRepository formRepository, @NotNull SetupRepository setupRepository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        Intrinsics.checkNotNullParameter((Object)formRepository, (String)"formRepository");
        Intrinsics.checkNotNullParameter((Object)setupRepository, (String)"setupRepository");
        super(repository, documentTypeRepository, formRepository, setupRepository);
        this.flowScreen = Screens.FrontPhotoDocument.INSTANCE.getScreenKey();
        File file = repository.getFrontDocumentMedia();
        this.imageFrontSide = BitmapFactory.decodeFile((String)(file == null ? null : file.getPath()));
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onStart() {
        void $this$filterTo$iv$iv;
        super.onStart();
        Bitmap bitmap = this.imageFrontSide;
        if (bitmap != null) {
            Bitmap bitmap2 = bitmap;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap2;
            boolean bl3 = false;
            this.showPreview(it);
        }
        this.getDocumentTypeRepository().isFromGallery(false);
        this.changeToolbarTitle();
        this.sendEventOpenedScreen();
        Iterable $this$filter$iv = this.getFlowRepository().getActiveFlows();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScreenFlowItem it = (ScreenFlowItem)element$iv$iv;
            boolean bl = false;
            boolean bl4 = !Intrinsics.areEqual((Object)it.getName(), (Object)Screens.BackPhotoDocument.INSTANCE.getScreenKey()) && !Intrinsics.areEqual((Object)it.getName(), (Object)Screens.BackGuideline.INSTANCE.getScreenKey());
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ArrayList flowList = (ArrayList)((List)destination$iv$iv);
        this.getFlowRepository().onUpdateFlows(flowList);
    }

    private final void changeToolbarTitle() {
        String string2;
        DocumentState documentState = this.getDocumentTypeRepository().getComposition();
        int n = WhenMappings.$EnumSwitchMapping$0[documentState.ordinal()];
        switch (n) {
            case 1: {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_SHARED_SINGLEHEADER_MOBILE);
                break;
            }
            case 2: 
            case 3: {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_SHARED_FRONTHEADER_MOBILE);
                break;
            }
            case 4: {
                string2 = Localization.Companion.translation(TranslationKey.DOCUMENT_SHARED_BOTTOMPAGEHEADER_MOBILE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String title = string2;
        this.getView().changeTitleToolbar(title);
    }

    /*
     * WARNING - void declaration
     */
    private final void sendEventOpenedScreen() {
        void $this$filterTo$iv$iv;
        this.setEventScreenName(this.getDocTypeSingle() ? "front-or-single" : "front");
        List flowList = null;
        ScreenFlowItem flowItem = new ScreenFlowItem(Screens.BackPhotoDocument.INSTANCE.getScreenKey(), true, false, null, 12, null);
        Iterable $this$filter$iv = this.getFlowRepository().getActiveFlows();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScreenFlowItem it = (ScreenFlowItem)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)Screens.BackPhotoDocument.INSTANCE.getScreenKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        flowList = (ArrayList)((List)destination$iv$iv);
        if (!this.getDocTypeSingle() && !flowList.contains(flowItem)) {
            flowList.add(this.getFlowRepository().getIndexNextScreen(), flowItem);
        }
        this.getFlowRepository().onUpdateFlows(flowList);
        EventsRepository eventsRepository2 = this.getEventsRepository();
        String string2 = this.getEventScreenName();
        Intrinsics.checkNotNull((Object)string2);
        eventsRepository2.sendStatusOpenedScreen(string2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrontPhotoDocumentPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FrontPhotoDocumentPresenter.access$showDialogEaAlreadyExists(this.this$0);
            }
        }));
    }

    @Override
    public void onRetakeClicked() {
        this.imageFrontSide = null;
        this.getRepository().onUpdateFrontDocumentMedia(null);
        this.getView().changePreviewVisibility(false);
    }

    @Override
    public void onUsePhotoClicked() {
        this.getView().showLoading();
        this.isRequestInProgress = true;
        Function1 function1 = (Function1)new Function1<Continuation<? super Response<DocumentData>>, Object>(this, null){
            int label;
            final /* synthetic */ FrontPhotoDocumentPresenter this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getDocumentTypeRepository().sendDocument((Continuation<? super Response<DocumentData>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Response<DocumentData>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        };
        boolean bl = false;
        this.doRequest(true, function1, (Function1)new Function1<DocumentData, Unit>(this){
            final /* synthetic */ FrontPhotoDocumentPresenter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable DocumentData data) {
                DocumentData documentData = data;
                Integer n = documentData == null ? null : documentData.getResponseCode();
                documentData = new IntRange(200, 299);
                boolean bl = false;
                if (n != null && documentData.contains(n)) {
                    DocumentData documentData2 = data;
                    Intrinsics.checkNotNull((Object)documentData2);
                    this.this$0.handleConclusion(documentData2, true);
                } else {
                    Integer n2 = n;
                    int n3 = 400;
                    if (n2 != null && n2 == n3) {
                        this.this$0.onRetakeClicked();
                        this.this$0.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.ERRORS_SHARED_BADREQUEST), Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_PLEASERETAKE));
                    } else {
                        this.this$0.getView().showError("Oops: Something else went wrong");
                    }
                }
                this.this$0.getView().hideLoading();
                FrontPhotoDocumentPresenter.access$setRequestInProgress$p(this.this$0, false);
            }
        });
    }

    @Override
    public void docSidesConclusionFrontMissing() {
        this.onRetakeClicked();
        this.getView().showErrorDialog(Localization.Companion.translation(TranslationKey.DOCUMENT_ERRORS_MISSINGFRONTSIDE), Localization.Companion.translation(TranslationKey.GLOBAL_SHARED_PLEASERETAKE));
    }

    @Override
    public void docSidesConclusionBackMissing() {
    }

    @Override
    public void docSidesConclusionOther() {
        this.onRetakeClicked();
    }

    @Override
    public void uploadConclusionOk(@NotNull DocumentData responseData, boolean bCanProceed) {
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"responseData");
        FileIds fileIds = responseData.getFileIds();
        this.getDocumentTypeRepository().setFrontId(fileIds == null ? null : fileIds.getFront());
        if (bCanProceed) {
            this.onClickAgree();
        } else {
            this.goToBackDocumentPhoto();
        }
    }

    @Override
    public void uploadConclusionBackSideMissing(@NotNull DocumentData responseData, boolean bCanProceed) {
        Intrinsics.checkNotNullParameter((Object)responseData, (String)"responseData");
        if (!bCanProceed) {
            FileIds fileIds;
            this.getDocumentTypeRepository().setFrontId((fileIds = responseData.getFileIds()) == null ? null : fileIds.getFront());
            this.goToBackDocumentPhoto();
        }
    }

    @Override
    public void uploadConclusionOther() {
    }

    @Override
    public boolean isRequestInProgress() {
        return this.isRequestInProgress;
    }

    @Override
    public void saveImage(@NotNull Bitmap image, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Bitmap bitmap = this.imageFrontSide = new FileEncodeUtils().scaleDocumentImage(image);
        if (bitmap != null) {
            Bitmap bitmap2 = bitmap;
            boolean bl = false;
            boolean bl2 = false;
            Bitmap it = bitmap2;
            boolean bl3 = false;
            File imageFile = new FileEncodeUtils().getImageFile(Intrinsics.stringPlus((String)context.getFilesDir().getAbsolutePath(), (Object)"document_image_front"), it);
            this.getRepository().onUpdateFrontDocumentMedia(imageFile);
        }
    }

    public static final /* synthetic */ void access$showDialogEaAlreadyExists(FrontPhotoDocumentPresenter $this) {
        $this.showDialogEaAlreadyExists();
    }

    public static final /* synthetic */ void access$setRequestInProgress$p(FrontPhotoDocumentPresenter $this, boolean bl) {
        $this.isRequestInProgress = bl;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DocumentState.values().length];
            nArray[DocumentState.SINGLE.ordinal()] = 1;
            nArray[DocumentState.FRONT_BACK.ordinal()] = 2;
            nArray[DocumentState.BOOKLET.ordinal()] = 3;
            nArray[DocumentState.TOP_BOTTOM.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

