/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.photo_document;

import android.content.Context;
import android.graphics.Bitmap;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.model.app.navigation.ScreenFlowItem;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.form.FormRepository;
import com.sdk.getidlib.model.data.repository.photo.PhotoRepository;
import com.sdk.getidlib.model.data.repository.setup.SetupRepository;
import com.sdk.getidlib.model.entity.events.GetIDError;
import com.sdk.getidlib.presentation.features.photo_document.PhotoDocumentAnalyzerPresenter;
import com.sdk.getidlib.presentation.features.photo_document.PhotoDocumentContract;
import com.sdk.getidlib.ui.common.ActionBarMode;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016J\u001a\u0010#\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001bH\u0016J\b\u0010)\u001a\u00020\u001bH\u0016J\u0018\u0010*\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H&J\u0010\u0010+\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0004R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/sdk/getidlib/presentation/features/photo_document/BasePhotoDocumentPresenter;", "Lcom/sdk/getidlib/presentation/features/photo_document/PhotoDocumentAnalyzerPresenter;", "Lcom/sdk/getidlib/presentation/features/photo_document/PhotoDocumentContract$View;", "Lcom/sdk/getidlib/presentation/features/photo_document/PhotoDocumentContract$Presenter;", "repository", "Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "formRepository", "Lcom/sdk/getidlib/model/data/repository/form/FormRepository;", "setupRepository", "Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;", "(Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;Lcom/sdk/getidlib/model/data/repository/form/FormRepository;Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;)V", "formTitleScreen", "", "getFormTitleScreen", "()Ljava/lang/String;", "setFormTitleScreen", "(Ljava/lang/String;)V", "getRepository", "()Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/photo_document/PhotoDocumentContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/photo_document/PhotoDocumentContract$View;)V", "addFlowItem", "", "flowItemKey", "goToBackDocumentPhoto", "isRTL", "", "isSwitchShapeAllowed", "onCaptureClicked", "onClickToGoSettings", "onPictureTaken", "image", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "onStart", "permissionDenied", "saveImage", "showPreview", "getidlib_release"})
public abstract class BasePhotoDocumentPresenter
extends PhotoDocumentAnalyzerPresenter<PhotoDocumentContract.View>
implements PhotoDocumentContract.Presenter {
    @NotNull
    private final PhotoRepository repository;
    public PhotoDocumentContract.View view;
    @Nullable
    private String formTitleScreen;

    public BasePhotoDocumentPresenter(@NotNull PhotoRepository repository, @NotNull DocumentTypeRepository documentTypeRepository, @NotNull FormRepository formRepository, @NotNull SetupRepository setupRepository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        Intrinsics.checkNotNullParameter((Object)formRepository, (String)"formRepository");
        Intrinsics.checkNotNullParameter((Object)setupRepository, (String)"setupRepository");
        super(documentTypeRepository, formRepository, setupRepository);
        this.repository = repository;
    }

    @NotNull
    public final PhotoRepository getRepository() {
        return this.repository;
    }

    @Override
    @NotNull
    public PhotoDocumentContract.View getView() {
        PhotoDocumentContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull PhotoDocumentContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @Override
    public void onStart() {
        this.updateCurrentFlowScreen();
        this.initStateButtonAgree();
        this.initAgreeButtonTitle();
        PhotoDocumentContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        PhotoDocumentContract.View $this$onStart_u24lambda_u2d0 = view;
        boolean bl3 = false;
        $this$onStart_u24lambda_u2d0.changeToolbarMode(ActionBarMode.BACK);
    }

    @Override
    public void onPictureTaken(@Nullable Bitmap image, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (image != null) {
            this.saveImage(image, context);
            this.showPreview(image);
        }
        this.getView().hideLoading();
    }

    @Override
    public void permissionDenied() {
        this.getView().changeCameraPermissionLayoutVisibility(true);
    }

    @Override
    public void onClickToGoSettings() {
        this.getView().openAppSettings();
        this.getEventsRepository().verificationFlowFail(GetIDError.DENY_PERMISSION);
        this.getView().finish();
    }

    @Override
    public void onCaptureClicked() {
        PhotoDocumentContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        PhotoDocumentContract.View $this$onCaptureClicked_u24lambda_u2d1 = view;
        boolean bl3 = false;
        $this$onCaptureClicked_u24lambda_u2d1.showLoading();
        $this$onCaptureClicked_u24lambda_u2d1.takePicture();
        $this$onCaptureClicked_u24lambda_u2d1.blink();
    }

    @Override
    public boolean isRTL() {
        return this.getDocumentTypeRepository().getIsRTL();
    }

    @Override
    public boolean isSwitchShapeAllowed() {
        return this.getDocumentTypeRepository().getDefaultFrameShape() == null || Intrinsics.areEqual((Object)this.getDocumentTypeRepository().getDefaultFrameShape(), (Object)"switchable");
    }

    @NotNull
    protected final PhotoDocumentContract.View showPreview(@NotNull Bitmap image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        PhotoDocumentContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        PhotoDocumentContract.View $this$showPreview_u24lambda_u2d2 = view;
        boolean bl3 = false;
        $this$showPreview_u24lambda_u2d2.changePreviewVisibility(true);
        $this$showPreview_u24lambda_u2d2.showPreviewPicture(image);
        return view;
    }

    protected final void goToBackDocumentPhoto() {
        this.getView().changePreviewVisibility(false);
        this.addFlowItem(Screens.BackPhotoDocument.INSTANCE.getScreenKey());
        if (this.getDocumentTypeRepository().isShowGuideline()) {
            this.addFlowItem(Screens.BackGuideline.INSTANCE.getScreenKey());
        }
        this.navigateToNextFlowScreen();
    }

    private final void addFlowItem(String flowItemKey) {
        List flowList = null;
        ScreenFlowItem flowItem = new ScreenFlowItem(flowItemKey, true, false, null, 12, null);
        flowList = TypeIntrinsics.asMutableList(this.getFlowRepository().getActiveFlows());
        if (!flowList.contains(flowItem)) {
            flowList.add(this.getFlowRepository().getIndexNextScreen(), flowItem);
        }
        this.getFlowRepository().onUpdateFlows(flowList);
    }

    public abstract void saveImage(@NotNull Bitmap var1, @NotNull Context var2);
}

