/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.liveness;

import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.model.app.navigation.ScreenFlowItem;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.liveness.LivenessRepository;
import com.sdk.getidlib.model.entity.events.GetIDError;
import com.sdk.getidlib.model.entity.liveness.FaceActionEnum;
import com.sdk.getidlib.model.entity.liveness.LivenessResponse;
import com.sdk.getidlib.presentation.features.liveness.DetectListener;
import com.sdk.getidlib.presentation.features.liveness.EventsListener;
import com.sdk.getidlib.presentation.features.liveness.LivenessContract;
import com.sdk.getidlib.presentation.global.BasePresenterImpl;
import com.sdk.getidlib.ui.common.ActionBarMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\u001fH\u0002J\u0012\u0010#\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010%\u001a\u00020\u0018H\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\b\u0010(\u001a\u00020\u001fH\u0016J\b\u0010)\u001a\u00020\u001fH\u0016J\b\u0010*\u001a\u00020\u001fH\u0016J\b\u0010+\u001a\u00020\u001fH\u0016J\b\u0010,\u001a\u00020\u001fH\u0016J\b\u0010-\u001a\u00020\u001fH\u0016J\b\u0010.\u001a\u00020\u001fH\u0016J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u001fH\u0002J\u0010\u00103\u001a\u00020\u001f2\u0006\u0010!\u001a\u000204H\u0016J\b\u00105\u001a\u00020\u001fH\u0016J\u0012\u00106\u001a\u00020\u001f2\b\u00107\u001a\u0004\u0018\u00010\fH\u0016J\b\u00108\u001a\u00020\u001fH\u0016J\b\u00109\u001a\u00020\u001fH\u0016J\b\u0010:\u001a\u00020\u001fH\u0016J\u0010\u0010;\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020<H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006="}, d2={"Lcom/sdk/getidlib/presentation/features/liveness/LivenessPresenter;", "Lcom/sdk/getidlib/presentation/global/BasePresenterImpl;", "Lcom/sdk/getidlib/presentation/features/liveness/LivenessContract$View;", "Lcom/sdk/getidlib/presentation/features/liveness/LivenessContract$Presenter;", "Lcom/sdk/getidlib/presentation/features/liveness/EventsListener;", "Lcom/sdk/getidlib/presentation/features/liveness/DetectListener;", "repository", "Lcom/sdk/getidlib/model/data/repository/liveness/LivenessRepository;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "(Lcom/sdk/getidlib/model/data/repository/liveness/LivenessRepository;Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;)V", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "flowScreen", "getFlowScreen", "setFlowScreen", "formTitleScreen", "getFormTitleScreen", "setFormTitleScreen", "isNeedToWaiting", "", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/liveness/LivenessContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/liveness/LivenessContract$View;)V", "changeToolbarTitle", "", "failure", "error", "giveTask", "handleSessionError", "sessionError", "isRTL", "onClickStatusErrorDialog", "onClickStatusInfoDialog", "onClickStatusOkDialog", "onClickStatusWarningDialog", "onClickToGoSettings", "onStart", "onStop", "permissionDenied", "recognized", "sendFrame", "data", "", "setupDetectListener", "showFatalErrorScreen", "Lcom/sdk/getidlib/model/entity/events/GetIDError;", "startRecognize", "startTask", "task", "stopSendingFrames", "success", "taskComplete", "warning", "Lcom/sdk/getidlib/model/entity/liveness/LivenessResponse$LivenessWarning;", "getidlib_release"})
public final class LivenessPresenter
extends BasePresenterImpl<LivenessContract.View>
implements LivenessContract.Presenter,
EventsListener,
DetectListener {
    @NotNull
    private final LivenessRepository repository;
    @NotNull
    private final DocumentTypeRepository documentTypeRepository;
    public LivenessContract.View view;
    @Nullable
    private String flowScreen;
    @Nullable
    private String formTitleScreen;
    @Nullable
    private String eventScreenName;
    private boolean isNeedToWaiting;

    public LivenessPresenter(@NotNull LivenessRepository repository, @NotNull DocumentTypeRepository documentTypeRepository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        this.repository = repository;
        this.documentTypeRepository = documentTypeRepository;
        this.flowScreen = Screens.LivenessCheck.INSTANCE.getScreenKey();
        this.eventScreenName = "liveness";
    }

    @Override
    @NotNull
    public LivenessContract.View getView() {
        LivenessContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull LivenessContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    @Override
    public void onStart() {
        super.onStart();
        LivenessContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        LivenessContract.View $this$onStart_u24lambda_u2d0 = view;
        boolean bl3 = false;
        $this$onStart_u24lambda_u2d0.changeToolbarMode(ActionBarMode.BACK);
        this.changeToolbarTitle();
    }

    @Override
    public void onStop() {
        this.repository.dispose();
        super.onStop();
    }

    @Override
    public void permissionDenied() {
        this.getView().changeCameraPermissionLayoutVisibility(true);
    }

    @Override
    public void onClickToGoSettings() {
        this.getView().openAppSettings();
        this.exit();
    }

    @Override
    public void startRecognize() {
        this.getView().showLivenessInfoDialog();
    }

    @Override
    public void onClickStatusInfoDialog() {
        this.setupDetectListener();
        this.repository.init(this);
    }

    private final void setupDetectListener() {
        this.repository.setupDetectListener(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onClickStatusOkDialog() {
        int n;
        List flowList;
        block4: {
            List $this$indexOfFirst$iv = flowList = this.getFlowRepository().getActiveFlows();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<ScreenFlowItem> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                ScreenFlowItem item$iv;
                ScreenFlowItem it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)Screens.LivenessCheck.INSTANCE.getScreenKey())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        if (n != 0) {
            void $this$filterTo$iv$iv;
            this.onBackPressed();
            Iterable $this$filter$iv = flowList;
            boolean $i$f$filter = false;
            Iterable index$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ScreenFlowItem it = (ScreenFlowItem)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getName(), (Object)Screens.LivenessCheck.INSTANCE.getScreenKey()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            flowList = (ArrayList)((List)destination$iv$iv);
            this.getFlowRepository().onUpdateFlows(flowList);
        }
        this.onClickAgree();
    }

    @Override
    public void onClickStatusErrorDialog() {
        this.setupDetectListener();
        this.repository.init(this);
    }

    @Override
    public void onClickStatusWarningDialog() {
        this.giveTask();
    }

    @Override
    public void sendFrame(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.isNeedToWaiting) {
            this.repository.sendFrame(data);
        }
    }

    @Override
    public boolean isRTL() {
        return this.documentTypeRepository.getIsRTL();
    }

    @Override
    public void recognized() {
        this.getView().showLivenessCommandGood();
    }

    private final void changeToolbarTitle() {
        this.getView().changeTitleToolbar(Localization.Companion.translation(TranslationKey.LIVENESS_SHARED_HEADER));
    }

    @Override
    public void startTask(@Nullable String task) {
        this.isNeedToWaiting = true;
        this.getView().hideLivenessWarning();
        String string2 = task;
        if (Intrinsics.areEqual((Object)string2, (Object)FaceActionEnum.TURN_LEFT.getAction())) {
            this.getView().showLivenessCommandTurnLeft();
        } else if (Intrinsics.areEqual((Object)string2, (Object)FaceActionEnum.TURN_RIGHT.getAction())) {
            this.getView().showLivenessCommandTurnRight();
        } else if (Intrinsics.areEqual((Object)string2, (Object)FaceActionEnum.SMILE.getAction())) {
            this.getView().showLivenessCommandSmile();
        } else if (Intrinsics.areEqual((Object)string2, (Object)FaceActionEnum.CLOSE_EYES.getAction())) {
            this.getView().showLivenessCommandCloseEyes();
        } else if (Intrinsics.areEqual((Object)string2, (Object)FaceActionEnum.CLOSE_ANY_EYE.getAction())) {
            this.getView().showLivenessCommandCloseAnyEyes();
        } else {
            this.getView().showLivenessCommandSmile();
        }
    }

    @Override
    public void taskComplete() {
        this.isNeedToWaiting = false;
        this.getView().showLivenessCommandGood();
    }

    @Override
    public void stopSendingFrames() {
        this.isNeedToWaiting = false;
    }

    @Override
    public void failure(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.getView().hideLivenessCommandDialog();
        switch (error) {
            case "noFace": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_NOFACE));
                break;
            }
            case "faceTooSmall": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_FACETOOSMALL));
                break;
            }
            case "multipleFaces": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_MULTIPLEFACES));
                break;
            }
            case "tooManyWarnings": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_FOLLOWINSTRUCTIONS));
                break;
            }
            case "serviceError": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.ERRORS_SHARED_SOMETHINGWENTWRONG));
                break;
            }
            case "slowConnection": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_SLOWCONNECTION));
                break;
            }
            case "timeout": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_TIMEOUT));
                break;
            }
            case "livenessServerUnavailable": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.ERRORS_LIVENESS_SERVERUNAVAILABLE));
                break;
            }
            case "lowConfidence": {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_LOWCONFIDENCE));
                break;
            }
            default: {
                this.getView().showLivenessCheckStatusError(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_FOLLOWINSTRUCTIONS));
            }
        }
    }

    @Override
    public void warning(@NotNull LivenessResponse.LivenessWarning warning) {
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        this.getView().hideLivenessCommandDialog();
        switch (warning.getWarningType()) {
            case "otherAction": {
                LivenessContract.View view = this.getView();
                LivenessResponse.LivenessOtherActionWarning livenessOtherActionWarning = warning.getOtherAction();
                Intrinsics.checkNotNull((Object)livenessOtherActionWarning);
                view.showLivenessWarningOtherAction(livenessOtherActionWarning.getDetected(), warning.getOtherAction().getTask());
                break;
            }
            case "timeout": {
                this.getView().showLivenessWarning(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_TIMEOUT));
                break;
            }
            case "sessionError": {
                this.handleSessionError(warning.getSessionError());
                break;
            }
            case "faceTooSmall": {
                this.getView().showLivenessWarning(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_FACETOOSMALL));
                break;
            }
            default: {
                this.getView().showLivenessWarning(Localization.Companion.translation(TranslationKey.ERRORS_SHARED_SOMETHINGWENTWRONG));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleSessionError(String sessionError) {
        String string2 = sessionError;
        if (string2 != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case -101804214: {
                    if (!string2.equals("tooManyWarnings")) break;
                    n = 1;
                    break;
                }
                case -1039206311: {
                    if (!string2.equals("tooManyFrames")) break;
                    n = 2;
                    break;
                }
                case -355174465: {
                    if (!string2.equals("slowConnection")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    this.getView().showLivenessWarning(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_FOLLOWINSTRUCTIONS));
                    return;
                }
                case 3: {
                    this.getView().showLivenessWarning(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_SLOWCONNECTION));
                    return;
                }
                case 2: {
                    this.getView().showLivenessWarning(Localization.Companion.translation(TranslationKey.LIVENESS_ERRORS_TOOMANYFRAMES));
                    return;
                }
            }
        }
        this.getView().showLivenessWarning(Localization.Companion.translation(TranslationKey.ERRORS_SHARED_SOMETHINGWENTWRONG));
    }

    @Override
    public void success() {
        this.getView().hideLivenessCommandDialog();
        this.getView().showLivenessCheckStatusOk();
    }

    private final void giveTask() {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LivenessPresenter this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)600L, (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        LivenessPresenter.access$getRepository$p(this.this$0).giveTask();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    public void showFatalErrorScreen(@NotNull GetIDError error) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        this.getEventsRepository().verificationFlowFail(error);
        GetIDError getIDError = error;
        int n = WhenMappings.$EnumSwitchMapping$0[getIDError.ordinal()];
        switch (n) {
            case 1: {
                this.getView().showErrorScreen(Localization.Companion.translation(TranslationKey.ERRORS_SHARED_INVALIDTOKEN));
                break;
            }
            case 2: {
                this.getView().showErrorScreen(Localization.Companion.translation(TranslationKey.ERRORS_LIVENESS_UNSUPPORTEDVERSION));
            }
        }
    }

    public static final /* synthetic */ LivenessRepository access$getRepository$p(LivenessPresenter $this) {
        return $this.repository;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GetIDError.values().length];
            nArray[GetIDError.INVALID_LIVENESS_TOKEN.ordinal()] = 1;
            nArray[GetIDError.UNSUPPORTED_LIVENESS_VERSION.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

