/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.form;

import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.Screens;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.helpers.ValidationExtensionsKt;
import com.sdk.getidlib.helpers.ValidationHelper;
import com.sdk.getidlib.model.app.form.CategoryType;
import com.sdk.getidlib.model.app.form.FormField;
import com.sdk.getidlib.model.app.form.FormValueType;
import com.sdk.getidlib.model.data.cache.local.AppPreferences;
import com.sdk.getidlib.model.data.repository.consent.ConsentRepository;
import com.sdk.getidlib.model.data.repository.document_type.DocumentTypeRepository;
import com.sdk.getidlib.model.data.repository.form.FormRepository;
import com.sdk.getidlib.model.data.repository.setup.SetupRepository;
import com.sdk.getidlib.model.entity.documents.Mask;
import com.sdk.getidlib.presentation.features.form.FormFieldsContract;
import com.sdk.getidlib.presentation.global.BasePresenterImpl;
import com.sdk.getidlib.ui.common.ActionBarMode;
import com.sdk.getidlib.utils.FormatUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0002J\u0016\u0010*\u001a\u00020'2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0016j\b\u0012\u0004\u0012\u00020\u0010`/H\u0002J\b\u00100\u001a\u00020 H\u0016J\b\u00101\u001a\u00020'H\u0016J\b\u00102\u001a\u00020'H\u0016J\u0010\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020\u0010H\u0016J\b\u00105\u001a\u00020'H\u0002J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\b\u00107\u001a\u00020'H\u0002J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0010\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020\u0017H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u0014R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u0002X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006;"}, d2={"Lcom/sdk/getidlib/presentation/features/form/FormFieldsPresenter;", "Lcom/sdk/getidlib/presentation/global/BasePresenterImpl;", "Lcom/sdk/getidlib/presentation/features/form/FormFieldsContract$View;", "Lcom/sdk/getidlib/presentation/features/form/FormFieldsContract$Presenter;", "formRepository", "Lcom/sdk/getidlib/model/data/repository/form/FormRepository;", "consentRepository", "Lcom/sdk/getidlib/model/data/repository/consent/ConsentRepository;", "documentTypeRepository", "Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;", "setupRepository", "Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;", "appPreferences", "Lcom/sdk/getidlib/model/data/cache/local/AppPreferences;", "(Lcom/sdk/getidlib/model/data/repository/form/FormRepository;Lcom/sdk/getidlib/model/data/repository/consent/ConsentRepository;Lcom/sdk/getidlib/model/data/repository/document_type/DocumentTypeRepository;Lcom/sdk/getidlib/model/data/repository/setup/SetupRepository;Lcom/sdk/getidlib/model/data/cache/local/AppPreferences;)V", "eventScreenName", "", "getEventScreenName", "()Ljava/lang/String;", "setEventScreenName", "(Ljava/lang/String;)V", "fields", "Ljava/util/ArrayList;", "Lcom/sdk/getidlib/model/app/form/FormField;", "flowScreen", "getFlowScreen", "setFlowScreen", "formTitle", "formTitleScreen", "getFormTitleScreen", "setFormTitleScreen", "hasItemsEmptyValue", "", "view", "getView", "()Lcom/sdk/getidlib/presentation/features/form/FormFieldsContract$View;", "setView", "(Lcom/sdk/getidlib/presentation/features/form/FormFieldsContract$View;)V", "changeAcceptButtonState", "", "changeConsentState", "checkHasItemListEmptyValue", "formFieldsUpdated", "itemList", "getLocale", "Ljava/util/Locale;", "getSexList", "Lkotlin/collections/ArrayList;", "isRTL", "onClickAgree", "onStart", "setFormTitle", "title", "setupConsentCheckBox", "setupDropDowns", "showData", "translateItems", "validate", "field", "getidlib_release"})
public final class FormFieldsPresenter
extends BasePresenterImpl<FormFieldsContract.View>
implements FormFieldsContract.Presenter {
    @NotNull
    private final FormRepository formRepository;
    @NotNull
    private final ConsentRepository consentRepository;
    @NotNull
    private final DocumentTypeRepository documentTypeRepository;
    @NotNull
    private final SetupRepository setupRepository;
    @NotNull
    private final AppPreferences appPreferences;
    public FormFieldsContract.View view;
    @Nullable
    private String flowScreen;
    @Nullable
    private String formTitleScreen;
    @Nullable
    private String eventScreenName;
    private boolean hasItemsEmptyValue;
    private ArrayList<FormField> fields;
    private String formTitle;

    public FormFieldsPresenter(@NotNull FormRepository formRepository, @NotNull ConsentRepository consentRepository, @NotNull DocumentTypeRepository documentTypeRepository, @NotNull SetupRepository setupRepository, @NotNull AppPreferences appPreferences) {
        Intrinsics.checkNotNullParameter((Object)formRepository, (String)"formRepository");
        Intrinsics.checkNotNullParameter((Object)consentRepository, (String)"consentRepository");
        Intrinsics.checkNotNullParameter((Object)documentTypeRepository, (String)"documentTypeRepository");
        Intrinsics.checkNotNullParameter((Object)setupRepository, (String)"setupRepository");
        Intrinsics.checkNotNullParameter((Object)appPreferences, (String)"appPreferences");
        this.formRepository = formRepository;
        this.consentRepository = consentRepository;
        this.documentTypeRepository = documentTypeRepository;
        this.setupRepository = setupRepository;
        this.appPreferences = appPreferences;
        this.flowScreen = Screens.Form.getScreenKey();
        this.formTitleScreen = Screens.Form.getFormTitle();
        this.eventScreenName = "form";
    }

    @Override
    @NotNull
    public FormFieldsContract.View getView() {
        FormFieldsContract.View view = this.view;
        if (view != null) {
            return view;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"view");
        return null;
    }

    @Override
    public void setView(@NotNull FormFieldsContract.View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
        this.view = view;
    }

    @Override
    @Nullable
    public String getFlowScreen() {
        return this.flowScreen;
    }

    @Override
    public void setFlowScreen(@Nullable String string2) {
        this.flowScreen = string2;
    }

    @Override
    @Nullable
    public String getFormTitleScreen() {
        return this.formTitleScreen;
    }

    @Override
    public void setFormTitleScreen(@Nullable String string2) {
        this.formTitleScreen = string2;
    }

    @Override
    @Nullable
    public String getEventScreenName() {
        return this.eventScreenName;
    }

    @Override
    public void setEventScreenName(@Nullable String string2) {
        this.eventScreenName = string2;
    }

    @Override
    public void onStart() {
        super.onStart();
        FormFieldsContract.View view = this.getView();
        boolean bl = false;
        boolean bl2 = false;
        FormFieldsContract.View $this$onStart_u24lambda_u2d0 = view;
        boolean bl3 = false;
        $this$onStart_u24lambda_u2d0.changeToolbarMode(ActionBarMode.BACK);
        $this$onStart_u24lambda_u2d0.changeTitleToolbar(Localization.Companion.translation(TranslationKey.PROFILEDATA_FORM_HEADER));
        this.showData();
    }

    private final void showData() {
        Object object;
        String string2;
        Map<String, ArrayList<FormField>> map = this.formRepository.getFormFields();
        Object object2 = this.formTitle;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"formTitle");
            string2 = null;
        } else {
            string2 = object2;
        }
        ArrayList<FormField> arrayList = map.get(string2);
        Intrinsics.checkNotNull(arrayList);
        this.fields = arrayList;
        FormFieldsContract.View view = this.getView();
        object2 = this.fields;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fields");
            object = null;
        } else {
            object = object2;
        }
        view.showFields((ArrayList<FormField>)object);
        this.setupDropDowns();
        this.setupConsentCheckBox();
        this.checkHasItemListEmptyValue();
        this.changeAcceptButtonState();
    }

    @Override
    public void formFieldsUpdated(@NotNull ArrayList<FormField> itemList) {
        String string2;
        Map map;
        Intrinsics.checkNotNullParameter(itemList, (String)"itemList");
        Map map2 = map = MapsKt.toMutableMap(this.formRepository.getFormFields());
        String string3 = this.formTitle;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"formTitle");
            string2 = null;
        } else {
            string2 = string3;
        }
        string3 = string2;
        ArrayList<FormField> arrayList = this.translateItems(itemList);
        boolean bl = false;
        map2.put(string3, arrayList);
        this.formRepository.onUpdateForm(map);
        this.checkHasItemListEmptyValue();
        this.changeAcceptButtonState();
    }

    @Override
    public void changeConsentState() {
        boolean previousConsentState = this.consentRepository.getCheckBoxConsentState();
        boolean actualConsentState = !previousConsentState;
        this.consentRepository.onUpdateCheckBoxConsentState(actualConsentState);
        this.getView().changeConsentStateIcon(actualConsentState);
        this.changeAcceptButtonState();
    }

    private final ArrayList<FormField> setupDropDowns() {
        Object v2;
        ArrayList<FormField> arrayList;
        block7: {
            Object v1;
            FormField it;
            boolean bl;
            Iterable iterable;
            boolean bl2;
            Iterable iterable2;
            ArrayList<FormField> $this$setupDropDowns_u24lambda_u2d3;
            block6: {
                ArrayList<FormField> arrayList2;
                arrayList = this.fields;
                if (arrayList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"fields");
                    arrayList2 = null;
                } else {
                    arrayList2 = arrayList;
                }
                arrayList = arrayList2;
                boolean bl3 = false;
                boolean bl4 = false;
                $this$setupDropDowns_u24lambda_u2d3 = arrayList;
                boolean bl5 = false;
                iterable2 = $this$setupDropDowns_u24lambda_u2d3;
                bl2 = false;
                iterable = iterable2;
                bl = false;
                for (Object t : iterable) {
                    it = (FormField)t;
                    boolean bl6 = false;
                    if (!(it.getValueType() == FormValueType.SEX)) continue;
                    v1 = t;
                    break block6;
                }
                v1 = null;
            }
            if (v1 != null) {
                this.getView().preLoadSexListToDropDown(this.getSexList());
            }
            iterable2 = $this$setupDropDowns_u24lambda_u2d3;
            bl2 = false;
            iterable = iterable2;
            bl = false;
            for (Object t : iterable) {
                it = (FormField)t;
                boolean bl7 = false;
                if (!(it.getValueType() == FormValueType.COUNTRY)) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        if (v2 != null) {
            Set<String> set = this.appPreferences.getCountries();
            Intrinsics.checkNotNull(set);
            ArrayList countries = (ArrayList)CollectionsKt.toList((Iterable)set);
            this.getView().preLoadCountriesToDropDown(countries);
        }
        return arrayList;
    }

    private final void setupConsentCheckBox() {
        this.getView().changeConsentCheckMarkVisibility(this.consentRepository.isNeedToShowConsentOnForm());
        if (this.consentRepository.isNeedToShowConsentOnForm()) {
            this.getView().changeConsentStateIcon(this.consentRepository.getCheckBoxConsentState());
        }
    }

    private final ArrayList<FormField> translateItems(ArrayList<FormField> itemList) {
        Iterator<FormField> iterator = itemList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2;
            int index = n++;
            FormField value = iterator.next();
            if (value.getValueType() == FormValueType.SEX) {
                String string3;
                String string4 = value.getValue();
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string5.toLowerCase(Locale.ROOT), (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                string4 = Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_MALE);
                bl = false;
                String string6 = string4;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (Intrinsics.areEqual((Object)string3, (Object)string7)) {
                    string2 = Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_MALE);
                } else {
                    string4 = Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_FEMALE);
                    bl = false;
                    String string8 = string4;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    string2 = Intrinsics.areEqual((Object)string3, (Object)string9) ? Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_FEMALE) : (Intrinsics.areEqual((Object)string3, (Object)"male") ? Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_MALE) : (Intrinsics.areEqual((Object)string3, (Object)"female") ? Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_FEMALE) : ValidationExtensionsKt.getEmpty(StringCompanionObject.INSTANCE)));
                }
            } else {
                string2 = value.getValue();
            }
            itemList.get(index).setValue(string2);
        }
        return itemList;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkHasItemListEmptyValue() {
        void $this$forEach$iv;
        ArrayList<FormField> arrayList;
        this.hasItemsEmptyValue = false;
        ArrayList<FormField> arrayList2 = this.fields;
        if (arrayList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fields");
            arrayList = null;
        } else {
            arrayList = arrayList2;
        }
        Iterator<FormField> iterator = arrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"fields.iterator()");
        boolean $i$f$forEach = false;
        void var3_4 = $this$forEach$iv;
        boolean bl = false;
        void var5_6 = var3_4;
        while (var5_6.hasNext()) {
            Object element$iv = var5_6.next();
            FormField it = (FormField)element$iv;
            boolean bl2 = false;
            if (!it.isRequired() || it.getValueType() == FormValueType.BOOLEAN) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!this.validate(it)) continue;
            this.hasItemsEmptyValue = true;
            return;
        }
    }

    private final boolean validate(FormField field) {
        boolean bl;
        Object object = field.getValue();
        int n = 0;
        if (object.length() == 0) {
            return true;
        }
        object = field.getCategory();
        n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                Mask mask;
                if (!ValidationHelper.Companion.isValidName(field.getValue()) || !ValidationHelper.Companion.isValidValueWithMask(field.getValue(), (mask = field.getMask()) == null ? null : mask.getRegexp())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (!ValidationHelper.Companion.isValidName(field.getValue())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: 
            case 5: {
                if (!ValidationHelper.Companion.isValidNumber(field.getValue())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 6: {
                if (!ValidationHelper.Companion.isValidPhoneNumber(field.getValue())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                if (!ValidationHelper.Companion.isValidEmail(field.getValue())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onClickAgree() {
        ArrayList<FormField> arrayList;
        String string2;
        void $this$forEach$iv;
        ArrayList<FormField> arrayList2;
        Map map = MapsKt.toMutableMap(this.formRepository.getFormFields());
        ArrayList<FormField> arrayList3 = this.fields;
        if (arrayList3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fields");
            arrayList2 = null;
        } else {
            arrayList2 = arrayList3;
        }
        Object object = arrayList2.iterator();
        Intrinsics.checkNotNullExpressionValue(object, (String)"fields.iterator()");
        boolean $i$f$forEach = false;
        ArrayList<FormField> arrayList4 = $this$forEach$iv;
        boolean bl = false;
        void var6_8 = arrayList4;
        while (var6_8.hasNext()) {
            CharSequence charSequence;
            Object element$iv = var6_8.next();
            FormField field = (FormField)element$iv;
            boolean bl2 = false;
            if (field.getValueType() == FormValueType.SEX) {
                String string3 = field.getValue();
                boolean bl3 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                charSequence = string5;
                string3 = Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_MALE);
                bl3 = false;
                String string6 = string3;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (Intrinsics.areEqual((Object)charSequence, (Object)string7)) {
                    field.setValue("Male");
                } else {
                    string3 = Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_FEMALE);
                    bl3 = false;
                    String string8 = string3;
                    if (string8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string9 = string8.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                    if (Intrinsics.areEqual((Object)charSequence, (Object)string9)) {
                        field.setValue("Female");
                    }
                }
            }
            charSequence = field.getValue();
            boolean bl4 = false;
            if (!(charSequence.length() > 0) || field.getValueType() != FormValueType.DATE || !this.isRTL()) continue;
            charSequence = FormatUtils.INSTANCE.convertDateFromRTL(field.getValue());
            field.setValue((String)(charSequence == null ? "" : charSequence));
        }
        object = map;
        String string10 = this.formTitle;
        if (string10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"formTitle");
            string2 = null;
        } else {
            string2 = string10;
        }
        string10 = string2;
        arrayList4 = this.fields;
        if (arrayList4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fields");
            arrayList = null;
        } else {
            arrayList = arrayList4;
        }
        arrayList4 = arrayList;
        bl = false;
        object.put(string10, arrayList4);
        this.formRepository.onUpdateForm(map);
        super.onClickAgree();
    }

    private final void changeAcceptButtonState() {
        boolean acceptButtonEnabled = this.hasItemsEmptyValue ? false : (this.consentRepository.isNeedToShowConsentOnForm() ? this.consentRepository.getCheckBoxConsentState() : true);
        this.getView().changeAcceptButtonState(acceptButtonEnabled);
    }

    private final ArrayList<String> getSexList() {
        Object[] objectArray = new String[]{Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_MALE), Localization.Companion.translation(TranslationKey.PROFILEDATA_SEX_FEMALE)};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    @Override
    public void setFormTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.formTitle = title;
    }

    @Override
    public boolean isRTL() {
        return this.documentTypeRepository.getIsRTL();
    }

    @Override
    @NotNull
    public Locale getLocale() {
        String string2 = this.setupRepository.getSelectedLocale();
        return new Locale(string2 == null ? "en_" : string2);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CategoryType.values().length];
            nArray[CategoryType.FIRST_NAME.ordinal()] = 1;
            nArray[CategoryType.LAST_NAME.ordinal()] = 2;
            nArray[CategoryType.CITY_OF_RESIDENCE.ordinal()] = 3;
            nArray[CategoryType.DOCUMENT_NUMBER.ordinal()] = 4;
            nArray[CategoryType.PERSONAL_NUMBER.ordinal()] = 5;
            nArray[CategoryType.PHONE_NUMBER.ordinal()] = 6;
            nArray[CategoryType.EMAIL.ordinal()] = 7;
            nArray[CategoryType.DATE_OF_BIRTH.ordinal()] = 8;
            nArray[CategoryType.DATE_OF_EXPIRY.ordinal()] = 9;
            nArray[CategoryType.DATE_OF_ISSUE.ordinal()] = 10;
            nArray[CategoryType.SEX.ordinal()] = 11;
            nArray[CategoryType.ADDRESS.ordinal()] = 12;
            nArray[CategoryType.NATIONALITY.ordinal()] = 13;
            nArray[CategoryType.BIRTH_PLACE.ordinal()] = 14;
            nArray[CategoryType.COUNTRY_OF_RESIDENCE.ordinal()] = 15;
            nArray[CategoryType.CUSTOM.ordinal()] = 16;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

