/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.presentation.features.document_type;

import com.sdk.getidlib.app.common.objects.Localization;
import com.sdk.getidlib.app.common.objects.TranslationKey;
import com.sdk.getidlib.model.entity.countries.Country;
import com.sdk.getidlib.model.entity.countries.Document;
import com.sdk.getidlib.presentation.features.photo_document.DocumentState;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/sdk/getidlib/presentation/features/document_type/DocumentConverter;", "", "()V", "getDocumentComposition", "Lcom/sdk/getidlib/presentation/features/photo_document/DocumentState;", "country", "Lcom/sdk/getidlib/model/entity/countries/Country;", "document", "", "getDocumentCompositionByName", "compositionName", "getDocumentField", "Lcom/sdk/getidlib/model/entity/countries/Document;", "getField", "title", "name", "getidlib_release"})
public final class DocumentConverter {
    @NotNull
    public static final DocumentConverter INSTANCE = new DocumentConverter();

    private DocumentConverter() {
    }

    @Nullable
    public final Document getDocumentField(@NotNull String document) {
        Document document2;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        switch (document) {
            case "id-card": {
                document2 = this.getField(Localization.Companion.translation(TranslationKey.DOCUMENT_TYPES_IDCARD), document);
                break;
            }
            case "driving-licence": {
                document2 = this.getField(Localization.Companion.translation(TranslationKey.DOCUMENT_TYPES_DRIVINGLICENCE), document);
                break;
            }
            case "passport": {
                document2 = this.getField(Localization.Companion.translation(TranslationKey.DOCUMENT_TYPES_PASSPORT), document);
                break;
            }
            case "domestic-passport": {
                document2 = this.getField(Localization.Companion.translation(TranslationKey.DOCUMENT_TYPES_DOMESTICPASSPORT), document);
                break;
            }
            case "address-card": {
                document2 = this.getField(Localization.Companion.translation(TranslationKey.DOCUMENT_TYPES_ADDRESSCARD), document);
                break;
            }
            case "residence-permit": {
                document2 = this.getField(Localization.Companion.translation(TranslationKey.DOCUMENT_TYPES_RESIDENCEPERMIT), document);
                break;
            }
            case "voter-card": {
                document2 = this.getField(Localization.Companion.translation(TranslationKey.DOCUMENT_TYPES_VOTERCARD), document);
                break;
            }
            case "tax-card": {
                document2 = this.getField(Localization.Companion.translation(TranslationKey.DOCUMENT_TYPES_TAXCARD), document);
                break;
            }
            default: {
                document2 = null;
            }
        }
        return document2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final DocumentState getDocumentComposition(@NotNull Country country, @NotNull String document) {
        DocumentState documentState;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)country, (String)"country");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Map<String, String[]> map = country.getSideCompositions();
        String composition = map == null ? null : ((objectArray = map.get(document)) == null ? null : (String)ArraysKt.first((Object[])objectArray));
        map = composition;
        if (map != null) {
            int n = -1;
            switch (((String)((Object)map)).hashCode()) {
                case -902265784: {
                    if (!((String)((Object)map)).equals("single")) break;
                    n = 1;
                    break;
                }
                case 64688786: {
                    if (!((String)((Object)map)).equals("booklet")) break;
                    n = 2;
                    break;
                }
                case -370755061: {
                    if (!((String)((Object)map)).equals("front-back")) break;
                    n = 3;
                    break;
                }
                case 1736247715: {
                    if (!((String)((Object)map)).equals("top-bottom")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    documentState = DocumentState.SINGLE;
                    return documentState;
                }
                case 3: {
                    documentState = DocumentState.FRONT_BACK;
                    return documentState;
                }
                case 4: {
                    documentState = DocumentState.TOP_BOTTOM;
                    return documentState;
                }
                case 2: {
                    documentState = DocumentState.BOOKLET;
                    return documentState;
                }
            }
        }
        documentState = DocumentState.SINGLE;
        return documentState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final DocumentState getDocumentCompositionByName(@Nullable String compositionName) {
        String string2 = compositionName;
        if (string2 == null) return null;
        int n = -1;
        switch (string2.hashCode()) {
            case -902265784: {
                if (string2.equals("single")) {
                    n = 1;
                }
                break;
            }
            case 64688786: {
                if (string2.equals("booklet")) {
                    n = 2;
                }
                break;
            }
            case -370755061: {
                if (string2.equals("front-back")) {
                    n = 3;
                }
                break;
            }
            case 1736247715: {
                if (string2.equals("top-bottom")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                DocumentState documentState = DocumentState.SINGLE;
                return documentState;
            }
            case 3: {
                DocumentState documentState = DocumentState.FRONT_BACK;
                return documentState;
            }
            case 4: {
                DocumentState documentState = DocumentState.TOP_BOTTOM;
                return documentState;
            }
            case 2: {
                DocumentState documentState = DocumentState.BOOKLET;
                return documentState;
            }
            default: {
                return null;
            }
        }
    }

    private final Document getField(String title, String name) {
        return new Document(title, false, name);
    }
}

