/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.model.data.repository.video_recording;

import com.sdk.getidlib.app.di.network.NetworkComponent;
import com.sdk.getidlib.model.app.video_recording.VideoRecordingConfig;
import com.sdk.getidlib.model.data.cache.runtime.VideoRecordingState;
import com.sdk.getidlib.model.data.repository.video_recording.VideoRecordingRepository;
import com.sdk.getidlib.model.entity.files.UploadResponse;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0016J\u0016\u0010\u0016\u001a\u00020\b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0012\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0016J\u001f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcom/sdk/getidlib/model/data/repository/video_recording/VideoRecordingRepositoryImpl;", "Lcom/sdk/getidlib/model/data/repository/video_recording/VideoRecordingRepository;", "videoRecordingState", "Lcom/sdk/getidlib/model/data/cache/runtime/VideoRecordingState;", "networkComponent", "Lcom/sdk/getidlib/app/di/network/NetworkComponent;", "(Lcom/sdk/getidlib/model/data/cache/runtime/VideoRecordingState;Lcom/sdk/getidlib/app/di/network/NetworkComponent;)V", "configVideoRecordingParams", "", "videoRecordingConfig", "Lcom/sdk/getidlib/model/app/video_recording/VideoRecordingConfig;", "getDuration", "", "getPhrases", "", "", "getReadableText", "getVideo", "Ljava/io/File;", "getVideoRecordingId", "saveVideo", "videoRecorded", "setPhrases", "phrases", "setVideoDuration", "maxVideoDuration", "setVideoRecordingId", "fileId", "uploadVideoRecording", "Lretrofit2/Response;", "Lcom/sdk/getidlib/model/entity/files/UploadResponse;", "video", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getidlib_release"})
public final class VideoRecordingRepositoryImpl
implements VideoRecordingRepository {
    @NotNull
    private final VideoRecordingState videoRecordingState;
    @NotNull
    private final NetworkComponent networkComponent;

    public VideoRecordingRepositoryImpl(@NotNull VideoRecordingState videoRecordingState2, @NotNull NetworkComponent networkComponent) {
        Intrinsics.checkNotNullParameter((Object)videoRecordingState2, (String)"videoRecordingState");
        Intrinsics.checkNotNullParameter((Object)networkComponent, (String)"networkComponent");
        this.videoRecordingState = videoRecordingState2;
        this.networkComponent = networkComponent;
    }

    @Override
    public void configVideoRecordingParams(@NotNull VideoRecordingConfig videoRecordingConfig) {
        Intrinsics.checkNotNullParameter((Object)videoRecordingConfig, (String)"videoRecordingConfig");
        this.videoRecordingState.setVideoSecondsDuration((Integer)videoRecordingConfig.getDuration());
        this.videoRecordingState.setReadableText(videoRecordingConfig.getReadableText());
    }

    @Override
    @NotNull
    public String getReadableText() {
        return this.videoRecordingState.getReadableText();
    }

    @Override
    public int getDuration() {
        return this.videoRecordingState.getVideoSecondsDuration();
    }

    @Override
    public void saveVideo(@Nullable File videoRecorded) {
        this.videoRecordingState.setVideo(videoRecorded);
    }

    @Override
    @Nullable
    public File getVideo() {
        return this.videoRecordingState.getVideo();
    }

    @Override
    public void setVideoDuration(int maxVideoDuration) {
        this.videoRecordingState.setVideoSecondsDuration((Integer)maxVideoDuration);
    }

    @Override
    public void setPhrases(@NotNull List<String> phrases) {
        Intrinsics.checkNotNullParameter(phrases, (String)"phrases");
        this.videoRecordingState.setPhrases(phrases);
    }

    @Override
    @NotNull
    public List<String> getPhrases() {
        return this.videoRecordingState.getPhrases();
    }

    @Override
    @Nullable
    public Object uploadVideoRecording(@NotNull File video, @NotNull Continuation<? super Response<UploadResponse>> $completion) {
        MultipartBody.Part videoFile = MultipartBody.Part.Companion.createFormData("file", "blob", RequestBody.Companion.create(video, MediaType.Companion.parse("video/mp4")));
        return this.networkComponent.appService().uploadFile(videoFile, $completion);
    }

    @Override
    public void setVideoRecordingId(@Nullable String fileId) {
        this.videoRecordingState.setVideoId(fileId);
    }

    @Override
    @Nullable
    public String getVideoRecordingId() {
        return this.videoRecordingState.getVideoId();
    }
}

