/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.model.data.repository.photo;

import com.sdk.getidlib.app.common.objects.PhotoEnum;
import com.sdk.getidlib.app.di.network.NetworkComponent;
import com.sdk.getidlib.model.app.selfie.SelfieConfig;
import com.sdk.getidlib.model.data.cache.runtime.PhotoState;
import com.sdk.getidlib.model.data.repository.photo.PhotoRepository;
import com.sdk.getidlib.model.entity.selfie.SelfieData;
import java.io.File;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0012\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u001f\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u000fH\u0016J\u0017\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010$J\u0017\u0010%\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepositoryImpl;", "Lcom/sdk/getidlib/model/data/repository/photo/PhotoRepository;", "photoState", "Lcom/sdk/getidlib/model/data/cache/runtime/PhotoState;", "networkComponent", "Lcom/sdk/getidlib/app/di/network/NetworkComponent;", "(Lcom/sdk/getidlib/model/data/cache/runtime/PhotoState;Lcom/sdk/getidlib/app/di/network/NetworkComponent;)V", "addFileId", "", "fileId", "", "checkSelfie", "Lretrofit2/Response;", "Lcom/sdk/getidlib/model/entity/selfie/SelfieData;", "file", "Ljava/io/File;", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configSelfieParams", "config", "Lcom/sdk/getidlib/model/app/selfie/SelfieConfig;", "getBackDocumentMedia", "getFileId", "getFrontDocumentMedia", "getSelfieMediaPic", "getSelfieVideoDuration", "", "getVideoPermission", "", "isShowGuideline", "onUpdateBackDocumentMedia", "media", "onUpdateFrontDocumentMedia", "onUpdateSelfieMediaPic", "mediaPic", "setVideoDurationPermission", "maxVideoDuration", "(Ljava/lang/Integer;)V", "setVideoPermission", "videoPermission", "(Ljava/lang/Boolean;)V", "getidlib_release"})
public final class PhotoRepositoryImpl
implements PhotoRepository {
    @NotNull
    private final PhotoState photoState;
    @NotNull
    private final NetworkComponent networkComponent;

    public PhotoRepositoryImpl(@NotNull PhotoState photoState2, @NotNull NetworkComponent networkComponent) {
        Intrinsics.checkNotNullParameter((Object)photoState2, (String)"photoState");
        Intrinsics.checkNotNullParameter((Object)networkComponent, (String)"networkComponent");
        this.photoState = photoState2;
        this.networkComponent = networkComponent;
    }

    @Override
    public void configSelfieParams(@NotNull SelfieConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.photoState.setShowGuideline(config.isShowGuidelines());
    }

    @Override
    public boolean isShowGuideline() {
        return this.photoState.isShowGuideline();
    }

    @Override
    public void setVideoDurationPermission(@Nullable Integer maxVideoDuration) {
        Integer n = maxVideoDuration;
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            this.photoState.setSelfieVideoSecondsDuration((Integer)it);
        }
    }

    @Override
    public int getSelfieVideoDuration() {
        return this.photoState.getSelfieVideoSecondsDuration();
    }

    @Override
    public void onUpdateFrontDocumentMedia(@Nullable File media) {
        this.photoState.setFrontDocumentMedia(media);
    }

    @Override
    @Nullable
    public File getFrontDocumentMedia() {
        return this.photoState.getFrontDocumentMedia();
    }

    @Override
    public void onUpdateBackDocumentMedia(@Nullable File media) {
        this.photoState.setBackDocumentMedia(media);
    }

    @Override
    @Nullable
    public File getBackDocumentMedia() {
        return this.photoState.getBackDocumentMedia();
    }

    @Override
    public void onUpdateSelfieMediaPic(@Nullable File mediaPic) {
        this.photoState.setSelfieMediaPic(mediaPic);
    }

    @Override
    @Nullable
    public File getSelfieMediaPic() {
        return this.photoState.getSelfieMediaPic();
    }

    @Override
    public void setVideoPermission(@Nullable Boolean videoPermission) {
        Boolean bl = videoPermission;
        if (bl != null) {
            Boolean bl2 = bl;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean it = bl2;
            boolean bl5 = false;
            this.photoState.setVideoPermission(it);
        }
    }

    @Override
    public boolean getVideoPermission() {
        return this.photoState.isVideoPermission();
    }

    @Override
    @Nullable
    public Object checkSelfie(@NotNull File file, @NotNull Continuation<? super Response<SelfieData>> $completion) {
        String string2 = PhotoEnum.SELFIE.name();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        MultipartBody.Part selfiePhoto = MultipartBody.Part.Companion.createFormData(string4, "blob", RequestBody.Companion.create(file, MediaType.Companion.parse("image/jpeg")));
        return this.networkComponent.appService().checkSelfie(selfiePhoto, $completion);
    }

    @Override
    public void addFileId(@Nullable String fileId) {
        this.photoState.setSelfieFileId(fileId);
    }

    @Override
    @Nullable
    public String getFileId() {
        return this.photoState.getSelfieFileId();
    }
}

