/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.model.data.network;

import com.sdk.getidlib.app.di.storage.StorageComponent;
import com.sdk.getidlib.model.data.network.RequestUtilsOptions;
import com.sdk.getidlib.model.data.network.RetrofitFactory;
import com.sdk.getidlib.model.data.service.AppService;
import com.sdk.getidlib.model.data.service.JwtService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0011\u0014\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rH\u0002J\u0010\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\rH\u0002J\r\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u001c*\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/sdk/getidlib/model/data/network/RetrofitFactory;", "", "storage", "Lcom/sdk/getidlib/app/di/storage/StorageComponent;", "(Lcom/sdk/getidlib/app/di/storage/StorageComponent;)V", "appJwtService", "Lcom/sdk/getidlib/model/data/service/JwtService;", "appService", "Lcom/sdk/getidlib/model/data/service/AppService;", "getHeaders", "Lokhttp3/Headers;", "getHeadersWithApiKey", "initRetrofit", "Lretrofit2/Retrofit;", "kotlin.jvm.PlatformType", "initRetrofitJwt", "makeApiKeyInterceptor", "com/sdk/getidlib/model/data/network/RetrofitFactory$makeApiKeyInterceptor$1", "()Lcom/sdk/getidlib/model/data/network/RetrofitFactory$makeApiKeyInterceptor$1;", "makeBaseInterceptor", "com/sdk/getidlib/model/data/network/RetrofitFactory$makeBaseInterceptor$1", "()Lcom/sdk/getidlib/model/data/network/RetrofitFactory$makeBaseInterceptor$1;", "makeLoggingInterceptor", "Lokhttp3/logging/HttpLoggingInterceptor;", "makeOkHttpClient", "Lokhttp3/OkHttpClient;", "makeOkHttpClientWithApiKey", "addHeaders", "Lokhttp3/Request$Builder;", "addHeadersWithApiKey", "getidlib_release"})
public final class RetrofitFactory {
    @NotNull
    private final StorageComponent storage;

    public RetrofitFactory(@NotNull StorageComponent storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
    }

    @NotNull
    public final AppService appService() {
        Object object = this.initRetrofit().create(AppService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"initRetrofit().create(AppService::class.java)");
        return (AppService)object;
    }

    @NotNull
    public final JwtService appJwtService() {
        Object object = this.initRetrofitJwt().create(JwtService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"initRetrofitJwt().create(JwtService::class.java)");
        return (JwtService)object;
    }

    private final Retrofit initRetrofit() {
        return new Retrofit.Builder().baseUrl(this.storage.getSetupState().getApiUrl()).client(this.makeOkHttpClient()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
    }

    private final Retrofit initRetrofitJwt() {
        return new Retrofit.Builder().baseUrl(this.storage.getSetupState().getApiUrl()).client(this.makeOkHttpClientWithApiKey()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    private final OkHttpClient makeOkHttpClientWithApiKey() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)this.makeLoggingInterceptor()).addInterceptor((Interceptor)this.makeApiKeyInterceptor()).build();
    }

    private final OkHttpClient makeOkHttpClient() {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)this.makeLoggingInterceptor()).addInterceptor((Interceptor)this.makeBaseInterceptor()).connectTimeout(90L, TimeUnit.SECONDS).readTimeout(90L, TimeUnit.SECONDS).writeTimeout(90L, TimeUnit.SECONDS).build();
    }

    private final HttpLoggingInterceptor makeLoggingInterceptor() {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor(null, 1, null);
        boolean bl = false;
        boolean bl2 = false;
        HttpLoggingInterceptor $this$makeLoggingInterceptor_u24lambda_u2d0 = httpLoggingInterceptor;
        boolean bl3 = false;
        $this$makeLoggingInterceptor_u24lambda_u2d0.level(HttpLoggingInterceptor.Level.BODY);
        return httpLoggingInterceptor;
    }

    private final makeApiKeyInterceptor.1 makeApiKeyInterceptor() {
        return new Interceptor(this){
            final /* synthetic */ RetrofitFactory this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Request.Builder builder = chain.request().newBuilder();
                RetrofitFactory retrofitFactory2 = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Request.Builder $this$intercept_u24lambda_u2d0 = builder;
                boolean bl3 = false;
                RetrofitFactory.access$addHeadersWithApiKey(retrofitFactory2, $this$intercept_u24lambda_u2d0);
                Request.Builder builder2 = builder;
                Request request = builder2.build();
                return chain.proceed(request);
            }
        };
    }

    private final makeBaseInterceptor.1 makeBaseInterceptor() {
        return new Interceptor(this){
            final /* synthetic */ RetrofitFactory this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Response intercept(@NotNull Interceptor.Chain chain) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Request.Builder builder = chain.request().newBuilder();
                RetrofitFactory retrofitFactory2 = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                Request.Builder $this$intercept_u24lambda_u2d0 = builder;
                boolean bl3 = false;
                RetrofitFactory.access$addHeaders(retrofitFactory2, $this$intercept_u24lambda_u2d0);
                Request.Builder builder2 = builder;
                Request request = builder2.build();
                return chain.proceed(request);
            }
        };
    }

    private final Request.Builder addHeadersWithApiKey(Request.Builder $this$addHeadersWithApiKey) {
        return $this$addHeadersWithApiKey.headers(this.getHeadersWithApiKey());
    }

    private final Request.Builder addHeaders(Request.Builder $this$addHeaders) {
        return $this$addHeaders.headers(this.getHeaders());
    }

    private final Headers getHeadersWithApiKey() {
        Headers.Builder builder = new Headers.Builder();
        boolean bl = false;
        boolean bl2 = false;
        Headers.Builder $this$getHeadersWithApiKey_u24lambda_u2d1 = builder;
        boolean bl3 = false;
        for (Pair<String, String> value : new RequestUtilsOptions().getRequestHeadersWithApiKey(this.storage.getSetupState().getApiKey())) {
            $this$getHeadersWithApiKey_u24lambda_u2d1.set((String)value.getFirst(), (String)value.getSecond());
        }
        $this$getHeadersWithApiKey_u24lambda_u2d1.set("x-schema-version", "2.0.0");
        $this$getHeadersWithApiKey_u24lambda_u2d1.set("x-sdk-version", "2.5.0");
        $this$getHeadersWithApiKey_u24lambda_u2d1.set("x-sdk-platform", "android");
        return builder.build();
    }

    private final Headers getHeaders() {
        Headers.Builder builder = new Headers.Builder();
        boolean bl = false;
        boolean bl2 = false;
        Headers.Builder $this$getHeaders_u24lambda_u2d2 = builder;
        boolean bl3 = false;
        for (Pair<String, String> value : new RequestUtilsOptions().getRequestHeaders()) {
            $this$getHeaders_u24lambda_u2d2.set((String)value.getFirst(), (String)value.getSecond());
        }
        $this$getHeaders_u24lambda_u2d2.set("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)this.storage.getPreferences().getJwt()));
        $this$getHeaders_u24lambda_u2d2.set("x-schema-version", "2.0.0");
        $this$getHeaders_u24lambda_u2d2.set("x-sdk-version", "2.5.0");
        $this$getHeaders_u24lambda_u2d2.set("x-sdk-platform", "android");
        return builder.build();
    }

    public static final /* synthetic */ Request.Builder access$addHeadersWithApiKey(RetrofitFactory $this, Request.Builder $receiver) {
        return $this.addHeadersWithApiKey($receiver);
    }

    public static final /* synthetic */ Request.Builder access$addHeaders(RetrofitFactory $this, Request.Builder $receiver) {
        return $this.addHeaders($receiver);
    }
}

