/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.helpers;

import com.sdk.getidlib.helpers.EmailValidator;
import com.sdk.getidlib.helpers.InputValidator;
import com.sdk.getidlib.helpers.NameValidator;
import com.sdk.getidlib.helpers.ValidationHelper;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/sdk/getidlib/helpers/ValidationHelper;", "", "()V", "Companion", "getidlib_release"})
public final class ValidationHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0007J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0007J\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/sdk/getidlib/helpers/ValidationHelper$Companion;", "", "()V", "getEmailFieldValidators", "", "Lcom/sdk/getidlib/helpers/InputValidator;", "invalidErrorMessage", "", "(Ljava/lang/String;)[Lcom/sdk/getidlib/helpers/InputValidator;", "getMaskValidators", "maskRegexp", "(Ljava/lang/String;Ljava/lang/String;)[Lcom/sdk/getidlib/helpers/InputValidator;", "getNameFieldValidators", "getNumberFieldValidators", "getPhoneNumberFieldValidators", "isValidEmail", "", "email", "isValidName", "name", "isValidNumber", "isValidPhoneNumber", "phoneNumber", "isValidValueWithMask", "value", "notEmptyValidator", "getidlib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InputValidator[] notEmptyValidator(@NotNull String invalidErrorMessage) {
            Intrinsics.checkNotNullParameter((Object)invalidErrorMessage, (String)"invalidErrorMessage");
            InputValidator[] inputValidatorArray = new InputValidator[]{new InputValidator((Function1<? super String, Boolean>)((Function1)notEmptyValidator.1.INSTANCE), invalidErrorMessage)};
            return inputValidatorArray;
        }

        @NotNull
        public final InputValidator[] getEmailFieldValidators(@NotNull String invalidErrorMessage) {
            Intrinsics.checkNotNullParameter((Object)invalidErrorMessage, (String)"invalidErrorMessage");
            InputValidator[] inputValidatorArray = new InputValidator[]{new InputValidator((Function1<? super String, Boolean>)((Function1)getEmailFieldValidators.1.INSTANCE), invalidErrorMessage)};
            return inputValidatorArray;
        }

        @NotNull
        public final InputValidator[] getNameFieldValidators(@NotNull String invalidErrorMessage) {
            Intrinsics.checkNotNullParameter((Object)invalidErrorMessage, (String)"invalidErrorMessage");
            InputValidator[] inputValidatorArray = new InputValidator[]{new InputValidator((Function1<? super String, Boolean>)((Function1)getNameFieldValidators.1.INSTANCE), invalidErrorMessage)};
            return inputValidatorArray;
        }

        @NotNull
        public final InputValidator[] getNumberFieldValidators(@NotNull String invalidErrorMessage) {
            Intrinsics.checkNotNullParameter((Object)invalidErrorMessage, (String)"invalidErrorMessage");
            InputValidator[] inputValidatorArray = new InputValidator[]{new InputValidator((Function1<? super String, Boolean>)((Function1)getNumberFieldValidators.1.INSTANCE), invalidErrorMessage)};
            return inputValidatorArray;
        }

        @NotNull
        public final InputValidator[] getPhoneNumberFieldValidators(@NotNull String invalidErrorMessage) {
            Intrinsics.checkNotNullParameter((Object)invalidErrorMessage, (String)"invalidErrorMessage");
            InputValidator[] inputValidatorArray = new InputValidator[]{new InputValidator((Function1<? super String, Boolean>)((Function1)getPhoneNumberFieldValidators.1.INSTANCE), invalidErrorMessage)};
            return inputValidatorArray;
        }

        @NotNull
        public final InputValidator[] getMaskValidators(@Nullable String maskRegexp, @NotNull String invalidErrorMessage) {
            Intrinsics.checkNotNullParameter((Object)invalidErrorMessage, (String)"invalidErrorMessage");
            InputValidator[] inputValidatorArray = new InputValidator[]{new InputValidator((Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(maskRegexp){
                final /* synthetic */ String $maskRegexp;
                {
                    this.$maskRegexp = $maskRegexp;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String s) {
                    Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                    return ValidationHelper.Companion.isValidValueWithMask(s, this.$maskRegexp);
                }
            }), invalidErrorMessage)};
            return inputValidatorArray;
        }

        public final boolean isValidEmail(@NotNull String email) {
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            return EmailValidator.INSTANCE.isValidEmail(email);
        }

        public final boolean isValidName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return NameValidator.INSTANCE.isValidName(name);
        }

        public final boolean isValidNumber(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Pattern.compile("[a-zA-Z0-9-]+").matcher(name).matches();
        }

        public final boolean isValidPhoneNumber(@NotNull String phoneNumber) {
            Intrinsics.checkNotNullParameter((Object)phoneNumber, (String)"phoneNumber");
            return Pattern.compile("^\\+?\\(?[0-9]{1,3}\\)? ?-?[0-9]{1,3} ?-?[0-9]{3,5} ?-?[0-9]{4}( ?-?[0-9]{3})?").matcher(phoneNumber).matches();
        }

        public final boolean isValidValueWithMask(@NotNull String value, @Nullable String maskRegexp) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (maskRegexp != null) {
                Function1 validatorFun2 = (Function1)new Function1<String, Boolean>(maskRegexp){
                    final /* synthetic */ String $maskRegexp;
                    {
                        this.$maskRegexp = $maskRegexp;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String s) {
                        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                        return Pattern.compile(this.$maskRegexp).matcher(s).matches();
                    }
                };
                bl = (Boolean)validatorFun2.invoke((Object)value);
            } else {
                bl = true;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

