/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.app.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import com.sdk.getidlib.app.utils.ColorTransparentUtils;
import com.sdk.getidlib.utils.ColorUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a \u0010\u0003\u001a\u00020\u0004*\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\f\u0010\r\u001a\u00020\u0004*\u00020\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0010H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0004*\u00020\u000eH\u0000\u001a\f\u0010\u0011\u001a\u00020\t*\u00020\u000eH\u0000\u001a\u0016\u0010\u0012\u001a\u00020\u0004*\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u001e\u0010\u0014\u001a\u00020\u0004*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\tH\u0000\u001a\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0010H\u0000\u001a\f\u0010\u0016\u001a\u00020\u0004*\u00020\u000eH\u0000\u00a8\u0006\u0017"}, d2={"convertDpToPixel", "", "dp", "addTint", "", "Landroid/graphics/drawable/Drawable;", "colorHex", "", "isChecked", "", "dpSize", "Landroid/content/Context;", "size", "gone", "Landroid/view/View;", "hide", "Landroid/view/MenuItem;", "isVisible", "setTextColor", "Landroid/widget/TextView;", "setVisibility", "invisibleGone", "show", "getidlib_release"})
public final class ViewUtilsKt {
    public static final void setVisibility(@NotNull View $this$setVisibility, boolean isVisible, boolean invisibleGone) {
        Intrinsics.checkNotNullParameter((Object)$this$setVisibility, (String)"<this>");
        if (isVisible) {
            ViewUtilsKt.show($this$setVisibility);
        } else if (invisibleGone) {
            ViewUtilsKt.gone($this$setVisibility);
        } else {
            ViewUtilsKt.hide($this$setVisibility);
        }
    }

    public static /* synthetic */ void setVisibility$default(View view, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        ViewUtilsKt.setVisibility(view, bl, bl2);
    }

    public static final void show(@NotNull View $this$show) {
        Intrinsics.checkNotNullParameter((Object)$this$show, (String)"<this>");
        if ($this$show.getVisibility() != 0) {
            $this$show.setVisibility(0);
        }
    }

    public static final void hide(@NotNull View $this$hide) {
        Intrinsics.checkNotNullParameter((Object)$this$hide, (String)"<this>");
        if ($this$hide.getVisibility() != 4) {
            $this$hide.setVisibility(4);
        }
    }

    public static final void gone(@NotNull View $this$gone) {
        Intrinsics.checkNotNullParameter((Object)$this$gone, (String)"<this>");
        if ($this$gone.getVisibility() != 8) {
            $this$gone.setVisibility(8);
        }
    }

    public static final boolean isVisible(@NotNull View $this$isVisible) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisible, (String)"<this>");
        return $this$isVisible.getVisibility() == 0;
    }

    public static final void show(@NotNull MenuItem $this$show) {
        Intrinsics.checkNotNullParameter((Object)$this$show, (String)"<this>");
        $this$show.setVisible(true);
    }

    public static final void hide(@NotNull MenuItem $this$hide) {
        Intrinsics.checkNotNullParameter((Object)$this$hide, (String)"<this>");
        $this$hide.setVisible(false);
    }

    public static final void setTextColor(@NotNull TextView $this$setTextColor, @Nullable String colorHex) {
        Intrinsics.checkNotNullParameter((Object)$this$setTextColor, (String)"<this>");
        CharSequence charSequence = colorHex;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            $this$setTextColor.setTextColor(ColorUtils.INSTANCE.parse(colorHex));
        }
    }

    public static final float dpSize(@NotNull Context $this$dpSize, float size) {
        Intrinsics.checkNotNullParameter((Object)$this$dpSize, (String)"<this>");
        return TypedValue.applyDimension((int)1, (float)size, (DisplayMetrics)$this$dpSize.getResources().getDisplayMetrics());
    }

    public static final void addTint(@Nullable Drawable $this$addTint, @Nullable String colorHex, boolean isChecked) {
        if ($this$addTint == null || colorHex == null) {
            return;
        }
        int tintTran = isChecked ? 100 : 50;
        int color = ColorTransparentUtils.INSTANCE.convertIntoColor(colorHex, tintTran);
        $this$addTint.setTint(color);
    }

    public static final float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return MathKt.roundToInt((float)px);
    }
}

