/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.app.utils;

import android.graphics.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0002J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u0017"}, d2={"Lcom/sdk/getidlib/app/utils/ColorTransparentUtils;", "", "()V", "applyTransparent", "", "colorStr", "transCode", "", "convert", "trans", "convertIntoColor", "colorHex", "transparentColor10", "colorCode", "transparentColor100", "transparentColor20", "transparentColor30", "transparentColor40", "transparentColor50", "transparentColor60", "transparentColor70", "transparentColor80", "transparentColor90", "getidlib_release"})
public final class ColorTransparentUtils {
    @NotNull
    public static final ColorTransparentUtils INSTANCE = new ColorTransparentUtils();

    private ColorTransparentUtils() {
    }

    public final int transparentColor10(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 10);
    }

    public final int transparentColor20(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 20);
    }

    public final int transparentColor30(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 30);
    }

    public final int transparentColor40(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 40);
    }

    public final int transparentColor50(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 50);
    }

    public final int transparentColor60(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 60);
    }

    public final int transparentColor70(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 70);
    }

    public final int transparentColor80(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 80);
    }

    public final int transparentColor90(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 90);
    }

    public final int transparentColor100(@NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        return this.convertIntoColor(colorCode, 100);
    }

    public final int convertIntoColor(@NotNull String colorHex, int transCode) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)colorHex, (String)"colorHex");
        String colorStr = colorHex;
        CharSequence charSequence = colorStr;
        boolean bl = false;
        if (charSequence.length() > 0 && transCode <= 100) {
            if (colorStr.length() > 6) {
                colorStr = StringsKt.takeLast((String)colorStr, (int)6);
            }
            colorStr = this.applyTransparent(colorStr, transCode);
        }
        return Color.parseColor((String)colorStr);
    }

    private final String applyTransparent(String colorStr, int transCode) {
        return '#' + this.convert(transCode) + colorStr;
    }

    private final String convert(int trans) {
        String hexString = Integer.toHexString(MathKt.roundToInt((float)((float)(255 * trans) / 100.0f)));
        return Intrinsics.stringPlus((String)(hexString.length() < 2 ? "0" : ""), (Object)hexString);
    }
}

