/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.getidlib.app.common;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import com.sdk.getidlib.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J&\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\r0\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/sdk/getidlib/app/common/PermissionRequestFragment;", "Landroidx/fragment/app/Fragment;", "()V", "attemptCountMax", "", "count", "permissionListener", "Lcom/sdk/getidlib/app/common/PermissionRequestFragment$Listener;", "getPermissionListener", "()Lcom/sdk/getidlib/app/common/PermissionRequestFragment$Listener;", "setPermissionListener", "(Lcom/sdk/getidlib/app/common/PermissionRequestFragment$Listener;)V", "permissionName", "", "permissionsResultCallback", "Landroidx/activity/result/ActivityResultLauncher;", "kotlin.jvm.PlatformType", "canAskAgain", "", "generatePermissionDeniedMessage", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onCreateView", "", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "requestForPermission", "requestPermission", "Companion", "Listener", "getidlib_release"})
public final class PermissionRequestFragment
extends Fragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int attemptCountMax;
    private int count;
    @Nullable
    private String permissionName;
    @Nullable
    private Listener permissionListener;
    @NotNull
    private final ActivityResultLauncher<String> permissionsResultCallback;
    @NotNull
    private static final String TAG;
    @NotNull
    public static final String PERMISSION_NAME = "PERMISSION NAME";
    @NotNull
    public static final String ATTEMPT_COUNT_MAX = "ATTEMPT_COUNT_MAX";

    public PermissionRequestFragment() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> PermissionRequestFragment.permissionsResultCallback$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026        }\n        }\n    }");
        this.permissionsResultCallback = activityResultLauncher;
    }

    @Nullable
    public final Listener getPermissionListener() {
        return this.permissionListener;
    }

    public final void setPermissionListener(@Nullable Listener listener) {
        this.permissionListener = listener;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(null);
        if (this.getArguments() == null || this.getActivity() == null) {
            Listener listener = this.permissionListener;
            if (listener != null) {
                listener.permissionDenied("bundle == null || activity == null");
            }
            return;
        }
        this.permissionName = this.requireArguments().getString(PERMISSION_NAME);
        this.attemptCountMax = this.requireArguments().getInt(ATTEMPT_COUNT_MAX, 1);
        this.requestPermission();
    }

    @Nullable
    public Void onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return null;
    }

    private final boolean canAskAgain() {
        Activity activity = (Activity)this.requireActivity();
        String string = this.permissionName;
        Intrinsics.checkNotNull((Object)string);
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)string);
    }

    private final void requestPermission() {
        if (this.permissionName == null || Intrinsics.areEqual((Object)this.permissionName, (Object)PERMISSION_NAME)) {
            Listener listener = this.permissionListener;
            if (listener != null) {
                listener.permissionDenied("permissionName == null || permissionName == PERMISSION_NAME");
            }
            return;
        }
        String string = this.permissionName;
        Intrinsics.checkNotNull((Object)string);
        this.requestForPermission(string);
    }

    private final void requestForPermission(String permissionName) {
        if (ActivityCompat.checkSelfPermission((Context)((Context)this.requireActivity()), (String)permissionName) != 0) {
            this.permissionsResultCallback.launch((Object)permissionName);
        } else {
            Listener listener = this.permissionListener;
            if (listener != null) {
                listener.permissionGranted(permissionName);
            }
        }
    }

    private final String generatePermissionDeniedMessage(String permissionName) {
        String string2 = this.getString(R.string.title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.title)");
        String appName = string2;
        String permName = StringsKt.removePrefix((String)permissionName, (CharSequence)"android.permission.");
        Object[] objectArray = new Object[]{appName, permName};
        String string3 = this.getString(R.string.permission, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(R.string.permission, appName, permName)");
        return string3;
    }

    private static final void permissionsResultCallback$lambda-0(PermissionRequestFragment this$0, Boolean granted) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = this$0.permissionName;
        int n = 0;
        boolean bl = false;
        if (object == null || object.length() == 0 || this$0.getPermissionListener() == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)granted, (String)"granted");
        if (granted.booleanValue()) {
            object = this$0.getPermissionListener();
            if (object != null) {
                String string2 = this$0.permissionName;
                object.permissionGranted(string2 == null ? "" : string2);
            }
        } else {
            object = this$0;
            n = ((PermissionRequestFragment)((Object)object)).count;
            ((PermissionRequestFragment)((Object)object)).count = n + 1;
            if (this$0.canAskAgain() && this$0.count < this$0.attemptCountMax) {
                this$0.requestPermission();
            } else {
                object = this$0.getPermissionListener();
                if (object != null) {
                    String string3 = this$0.permissionName;
                    object.permissionDenied(this$0.generatePermissionDeniedMessage(string3 == null ? "" : string3));
                }
            }
        }
    }

    static {
        String string2 = PermissionRequestFragment.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PermissionRequestFragment::class.java.simpleName");
        TAG = string2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/sdk/getidlib/app/common/PermissionRequestFragment$Listener;", "", "permissionDenied", "", "messageDenied", "", "permissionGranted", "permissionName", "getidlib_release"})
    public static interface Listener {
        public void permissionGranted(@NotNull String var1);

        public void permissionDenied(@Nullable String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/sdk/getidlib/app/common/PermissionRequestFragment$Companion;", "", "()V", "ATTEMPT_COUNT_MAX", "", "PERMISSION_NAME", "TAG", "getTAG", "()Ljava/lang/String;", "getidlib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

