/*
  $Id: Reasons.java 2745 2013-06-25 21:16:10Z dfisher $

  Copyright (C) 2003-2013 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2745 $
  Updated: $Date: 2013-06-25 17:16:10 -0400 (Tue, 25 Jun 2013) $
*/
package edu.vt.middleware.crypt.x509.types;

/**
 * Definitions of the meanings of the bits in the {@link ReasonFlags} BIT STRING
 * defined in section 4.2.1.14 of RFC 2459.
 *
 * @author  Middleware Services
 * @version  $Revision: 2745 $
 */
public enum Reasons {

  /** Unused. */
  Unused(7),

  /** KeyCompromise. */
  KeyCompromise(6),

  /** CACompromise. */
  CACompromise(5),

  /** AffiliationChanged. */
  AffiliationChanged(4),

  /** Superseded. */
  Superseded(3),

  /** CessationOfOperation. */
  CessationOfOperation(2),

  /** CertificateHold. */
  CertificateHold(1);


  /** Bit mask value. */
  private final int mask;


  /**
   * Creates a bit flag with the given bit mask offset.
   *
   * @param  offset  Bit mask offset.
   */
  Reasons(final int offset)
  {
    mask = 1 << offset;
  }


  /** @return  Bit mask value. */
  public int getMask()
  {
    return mask;
  }
}
