/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index.impl;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.index.IEntryResult;

public class EntryResult
implements IEntryResult {
    private char[] word;
    private int[] fileRefs;

    public EntryResult(char[] word, int[] refs) {
        this.word = word;
        this.fileRefs = refs;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof EntryResult) {
            EntryResult anEntryResult = (EntryResult)anObject;
            if (!CharOperation.equals(this.word, anEntryResult.word)) {
                return false;
            }
            int[] refs = this.fileRefs;
            int length = this.fileRefs.length;
            int[] otherRefs = anEntryResult.fileRefs;
            if (length != anEntryResult.fileRefs.length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (refs[i] != otherRefs[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int[] getFileReferences() {
        return this.fileRefs;
    }

    public char[] getWord() {
        return this.word;
    }

    public int hashCode() {
        return CharOperation.hashCode(this.word);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.word.length * 2);
        buffer.append("EntryResult: word=");
        buffer.append(this.word);
        buffer.append(", refs={");
        int i = 0;
        while (i < this.fileRefs.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(' ');
            buffer.append(this.fileRefs[i]);
            ++i;
        }
        buffer.append(" }");
        return buffer.toString();
    }
}

