/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IGenericType;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.HandleFactory;
import org.eclipse.jdt.internal.core.IPathRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBinaryType;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.jdt.internal.core.hierarchy.IndexBasedHierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.search.IndexSearchAdapter;
import org.eclipse.jdt.internal.core.search.SubTypeSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;

public class IndexBasedHierarchyBuilder
extends HierarchyBuilder {
    public static final int MAXTICKS = 800;
    protected Map cuToHandle = new HashMap(5);
    protected Map handleToWorkingCopy;
    protected IJavaSearchScope scope;
    protected Map binariesFromIndexMatches = new HashMap(10);

    public IndexBasedHierarchyBuilder(TypeHierarchy hierarchy, IJavaSearchScope scope) throws JavaModelException {
        super(hierarchy);
        this.scope = scope;
    }

    private void addInfoFromBinaryIndexMatch(Openable handle, HierarchyBinaryType binaryType, ArrayList infos) throws JavaModelException {
        infos.add(binaryType);
        this.infoToHandle.put(binaryType, handle);
    }

    protected void addInfoFromClosedElement(Openable handle, ArrayList infos, ArrayList units, String resourcePath) throws JavaModelException {
        HierarchyBinaryType binaryType = (HierarchyBinaryType)this.binariesFromIndexMatches.get(resourcePath);
        if (binaryType != null) {
            this.addInfoFromBinaryIndexMatch(handle, binaryType, infos);
        } else {
            super.addInfoFromClosedElement(handle, infos, units, resourcePath);
        }
    }

    private void addInfosFromType(IType type, ArrayList infos) throws JavaModelException {
        if (type.isBinary()) {
            ClassFile classFile = (ClassFile)type.getClassFile();
            if (classFile != null) {
                this.addInfoFromOpenClassFile(classFile, infos);
            }
        } else {
            CompilationUnit unit = (CompilationUnit)type.getCompilationUnit();
            if (unit != null) {
                this.addInfoFromOpenCU(unit, infos);
            }
        }
    }

    public void build(boolean computeSubtypes) throws JavaModelException, CoreException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles();
            if (computeSubtypes) {
                boolean focusIsObject = this.getType().getElementName().equals(new String(IIndexConstants.OBJECT));
                int amountOfWorkForSubtypes = focusIsObject ? 5 : 80;
                SubProgressMonitor possibleSubtypesMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, amountOfWorkForSubtypes);
                String[] allPossibleSubtypes = this.determinePossibleSubTypes((IProgressMonitor)possibleSubtypesMonitor);
                if (allPossibleSubtypes != null) {
                    SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 100 - amountOfWorkForSubtypes);
                    this.hierarchy.initialize(allPossibleSubtypes.length);
                    this.buildFromPotentialSubtypes(allPossibleSubtypes, (IProgressMonitor)buildMonitor);
                }
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            manager.flushZipFiles();
            throw throwable;
        }
        Object var8_10 = null;
        manager.flushZipFiles();
    }

    private void buildForProject(JavaProject project, ArrayList infos, ArrayList units, IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        block20: {
            ICompilationUnit[] compilationUnits;
            IGenericType[] genericTypes;
            int infosSize = infos.size();
            if (infosSize > 0) {
                genericTypes = new IGenericType[infosSize];
                infos.toArray(genericTypes);
            } else {
                genericTypes = new IGenericType[]{};
            }
            int unitsSize = units.size();
            if (unitsSize > 0) {
                compilationUnits = new ICompilationUnit[unitsSize];
                units.toArray(compilationUnits);
            } else {
                compilationUnits = new ICompilationUnit[]{};
            }
            if (infosSize <= 0 && unitsSize <= 0) break block20;
            this.searchableEnvironment = (SearchableEnvironment)project.getSearchableNameEnvironment();
            IType focusType = this.getType();
            this.nameLookup = project.getNameLookup();
            boolean inProjectOfFocusType = focusType != null && focusType.getJavaProject().equals(project);
            NameLookup nameLookup = this.nameLookup;
            synchronized (nameLookup) {
                if (inProjectOfFocusType) {
                    IWorkingCopy[] unitsToLookInside;
                    org.eclipse.jdt.core.ICompilationUnit unitToLookInside = focusType.getCompilationUnit();
                    if (unitToLookInside != null) {
                        int wcLength;
                        int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
                        if (wcLength == 0) {
                            unitsToLookInside = new IWorkingCopy[]{unitToLookInside};
                        } else {
                            unitsToLookInside = new IWorkingCopy[wcLength + 1];
                            unitsToLookInside[0] = unitToLookInside;
                            System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
                        }
                    } else {
                        unitsToLookInside = workingCopies;
                    }
                    this.nameLookup.setUnitsToLookInside(unitsToLookInside);
                }
                try {
                    block21: {
                        block22: {
                            this.hierarchyResolver = new HierarchyResolver(this.searchableEnvironment, project.getOptions(true), this, new DefaultProblemFactory());
                            if (focusType == null) break block21;
                            char[] fullyQualifiedName = focusType.getFullyQualifiedName().toCharArray();
                            ReferenceBinding focusTypeBinding = this.hierarchyResolver.setFocusType(CharOperation.splitOn('.', fullyQualifiedName));
                            if (focusTypeBinding == null) break block22;
                            if (inProjectOfFocusType || (focusTypeBinding.tagBits & 0x8000) <= 0) break block21;
                        }
                        Object var15_15 = null;
                        if (inProjectOfFocusType) {
                            this.nameLookup.setUnitsToLookInside(null);
                        }
                        return;
                    }
                    this.hierarchyResolver.resolve(genericTypes, compilationUnits, monitor);
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    if (inProjectOfFocusType) {
                        this.nameLookup.setUnitsToLookInside(null);
                    }
                    throw throwable;
                }
                Object var15_17 = null;
                if (inProjectOfFocusType) {
                    this.nameLookup.setUnitsToLookInside(null);
                }
            }
        }
    }

    private void buildFromPotentialSubtypes(String[] allPotentialSubTypes, IProgressMonitor monitor) {
        block26: {
            int wcLength;
            IType focusType = this.getType();
            HashMap<String, IWorkingCopy> wcPaths = new HashMap<String, IWorkingCopy>();
            IWorkingCopy[] workingCopies = this.getWokingCopies();
            if (workingCopies != null && (wcLength = workingCopies.length) > 0) {
                String[] newPaths = new String[wcLength];
                int i = 0;
                while (i < wcLength) {
                    IWorkingCopy workingCopy = workingCopies[i];
                    String path = workingCopy.getOriginalElement().getPath().toString();
                    wcPaths.put(path, workingCopy);
                    newPaths[i] = path;
                    ++i;
                }
                int potentialSubtypesLength = allPotentialSubTypes.length;
                String[] stringArray = allPotentialSubTypes;
                allPotentialSubTypes = new String[potentialSubtypesLength + wcLength];
                System.arraycopy(stringArray, 0, allPotentialSubTypes, 0, potentialSubtypesLength);
                System.arraycopy(newPaths, 0, allPotentialSubTypes, potentialSubtypesLength, wcLength);
            }
            int length = allPotentialSubTypes.length;
            Openable focusCU = (Openable)((Object)focusType.getCompilationUnit());
            String focusPath = null;
            if (focusCU != null) {
                focusPath = focusCU.getPath().toString();
                if (length > 0) {
                    String[] stringArray = allPotentialSubTypes;
                    allPotentialSubTypes = new String[length + 1];
                    System.arraycopy(stringArray, 0, allPotentialSubTypes, 0, length);
                    allPotentialSubTypes[length] = focusPath;
                } else {
                    allPotentialSubTypes = new String[]{focusPath};
                }
                ++length;
            }
            Util.sortReverseOrder(allPotentialSubTypes);
            ArrayList infos = new ArrayList();
            ArrayList units = new ArrayList();
            try {
                HandleFactory factory = new HandleFactory(ResourcesPlugin.getWorkspace());
                IJavaProject currentProject = null;
                if (monitor != null) {
                    monitor.beginTask("", length * 2);
                }
                int i = 0;
                while (i < length) {
                    block25: {
                        try {
                            Openable handle;
                            String resourcePath = allPotentialSubTypes[i];
                            if (i > 0 && resourcePath.equals(allPotentialSubTypes[i - 1])) break block25;
                            IWorkingCopy workingCopy = (IWorkingCopy)wcPaths.get(resourcePath);
                            if (workingCopy != null) {
                                handle = (Openable)((Object)workingCopy);
                            } else {
                                Openable openable = handle = resourcePath.equals(focusPath) ? focusCU : factory.createOpenable(resourcePath, this.scope);
                                if (handle == null) break block25;
                            }
                            IJavaProject project = handle.getJavaProject();
                            if (currentProject == null) {
                                currentProject = project;
                                infos = new ArrayList(5);
                                units = new ArrayList(5);
                            } else if (!currentProject.equals(project)) {
                                this.buildForProject((JavaProject)currentProject, infos, units, workingCopies, monitor);
                                currentProject = project;
                                infos = new ArrayList(5);
                                units = new ArrayList(5);
                            }
                            this.addInfoFromElement(handle, infos, units, resourcePath);
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                    ++i;
                }
                try {
                    if (currentProject == null) {
                        currentProject = focusType.getJavaProject();
                        this.addInfosFromType(focusType, infos);
                    }
                    this.buildForProject((JavaProject)currentProject, infos, units, workingCopies, monitor);
                }
                catch (JavaModelException javaModelException) {}
                if (!this.hierarchy.contains(focusType)) {
                    try {
                        currentProject = focusType.getJavaProject();
                        infos = new ArrayList();
                        units = new ArrayList();
                        this.addInfosFromType(focusType, infos);
                        this.buildForProject((JavaProject)currentProject, infos, units, workingCopies, monitor);
                    }
                    catch (JavaModelException javaModelException) {}
                }
                if (!this.hierarchy.contains(focusType)) {
                    this.hierarchy.addRootClass(focusType);
                }
            }
            catch (Throwable throwable) {
                Object var19_22 = null;
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            Object var19_23 = null;
            if (monitor == null) break block26;
            monitor.done();
        }
    }

    protected ICompilationUnit createCompilationUnitFromPath(Openable handle, String osPath) throws JavaModelException {
        ICompilationUnit unit = super.createCompilationUnitFromPath(handle, osPath);
        this.cuToHandle.put(unit, handle);
        return unit;
    }

    private String[] determinePossibleSubTypes(IProgressMonitor monitor) throws JavaModelException, CoreException {
        class PathCollector
        implements IPathRequestor {
            HashSet paths;

            PathCollector() {
                this.paths = new HashSet<E>(10);
            }

            public void acceptPath(String path) {
                this.paths.add(path);
            }
        }
        PathCollector collector = new PathCollector();
        IProject project = this.hierarchy.javaProject().getProject();
        try {
            if (monitor != null) {
                monitor.beginTask("", 800);
            }
            IndexBasedHierarchyBuilder.searchAllPossibleSubTypes(project.getWorkspace(), this.getType(), this.scope, this.binariesFromIndexMatches, collector, 3, monitor);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (monitor != null) {
                monitor.done();
            }
            throw throwable;
        }
        Object var4_7 = null;
        if (monitor != null) {
            monitor.done();
        }
        HashSet paths = collector.paths;
        int length = paths.size();
        String[] result = new String[length];
        int count = 0;
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            result[count++] = (String)iter.next();
        }
        return result;
    }

    protected IType getHandle(IGenericType genericType) {
        if (genericType instanceof HierarchyType) {
            IType type = (IType)this.infoToHandle.get(genericType);
            if (type == null) {
                HierarchyType hierarchyType = (HierarchyType)genericType;
                CompilationUnit unit = (CompilationUnit)this.cuToHandle.get(hierarchyType.originatingUnit);
                ArrayList<char[]> enclosingTypeNames = new ArrayList<char[]>();
                HierarchyType enclosingType = hierarchyType;
                do {
                    enclosingTypeNames.add(enclosingType.name);
                } while ((enclosingType = enclosingType.enclosingType) != null);
                int length = enclosingTypeNames.size();
                char[][] simpleTypeNames = new char[length][];
                enclosingTypeNames.toArray((T[])simpleTypeNames);
                type = unit.getType(new String(simpleTypeNames[length - 1]));
                int i = length - 2;
                while (i >= 0) {
                    type = type.getType(new String(simpleTypeNames[i]));
                    --i;
                }
                this.infoToHandle.put(genericType, type);
            }
            return type;
        }
        return super.getHandle(genericType);
    }

    public static void searchAllPossibleSubTypes(IWorkspace workbench, IType type, IJavaSearchScope scope, final Map binariesFromIndexMatches, final IPathRequestor pathRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaModelException, CoreException {
        final Queue awaitings = new Queue();
        final HashtableOfObject foundSuperNames = new HashtableOfObject(5);
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        IndexSearchAdapter searchRequestor = new IndexSearchAdapter(){

            public void acceptSuperTypeReference(String resourcePath, char[] qualification, char[] typeName, char[] enclosingTypeName, char classOrInterface, char[] superQualification, char[] superTypeName, char superClassOrInterface, int modifiers) {
                pathRequestor.acceptPath(resourcePath);
                int suffix = resourcePath.toLowerCase().indexOf(".class");
                if (suffix != -1) {
                    HierarchyBinaryType binaryType = (HierarchyBinaryType)binariesFromIndexMatches.get(resourcePath);
                    if (binaryType == null) {
                        if (enclosingTypeName == IIndexConstants.ONE_ZERO) {
                            int lastSlash = resourcePath.lastIndexOf(47);
                            if (lastSlash == -1) {
                                return;
                            }
                            int lastDollar = resourcePath.lastIndexOf(36);
                            if (lastDollar == -1) {
                                return;
                            }
                            enclosingTypeName = resourcePath.substring(lastSlash + 1, lastDollar).toCharArray();
                            typeName = resourcePath.substring(lastDollar + 1, suffix).toCharArray();
                        }
                        binaryType = new HierarchyBinaryType(modifiers, qualification, typeName, enclosingTypeName, classOrInterface);
                        binariesFromIndexMatches.put(resourcePath, binaryType);
                    }
                    binaryType.recordSuperType(superTypeName, superQualification, superClassOrInterface);
                }
                if (!foundSuperNames.containsKey(typeName)) {
                    foundSuperNames.put(typeName, typeName);
                    awaitings.add(typeName);
                }
            }
        };
        SuperTypeReferencePattern pattern = new SuperTypeReferencePattern(null, null, 0, true);
        SubTypeSearchJob job = new SubTypeSearchJob(pattern, scope, type, 2, searchRequestor, indexManager);
        pattern.entryResults = new HashMap();
        int ticks = 0;
        awaitings.add(type.getElementName().toCharArray());
        while (awaitings.start <= awaitings.end) {
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                return;
            }
            char[] currentTypeName = awaitings.retrieve();
            if (CharOperation.equals(currentTypeName, IIndexConstants.OBJECT)) {
                currentTypeName = null;
            }
            pattern.superSimpleName = currentTypeName;
            indexManager.performConcurrentJob(job, waitingPolicy, null);
            if (progressMonitor != null && ++ticks <= 800) {
                progressMonitor.worked(1);
            }
            if (currentTypeName == null) break;
        }
        job.closeAll();
        pattern.entryResults = null;
    }

    private static class Queue {
        public char[][] names = new char[10][];
        public int start = 0;
        public int end = -1;

        Queue() {
        }

        public void add(char[] name) {
            if (++this.end == this.names.length) {
                this.end -= this.start;
                this.names = new char[this.end * 2][];
                System.arraycopy(this.names, this.start, this.names, 0, this.end);
                this.start = 0;
            }
            this.names[this.end] = name;
        }

        public char[] retrieve() {
            if (this.start > this.end) {
                return null;
            }
            char[] name = this.names[this.start++];
            if (this.start > this.end) {
                this.start = 0;
                this.end = -1;
            }
            return name;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Queue:\n");
            int i = this.start;
            while (i <= this.end) {
                buffer.append(this.names[i]).append('\n');
                ++i;
            }
            return buffer.toString();
        }
    }
}

