/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMPackage;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.MultiOperation;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.Util;

public class CopyResourceElementsOperation
extends MultiOperation {
    protected ArrayList fRenamedCompilationUnits = null;
    protected Map fDeltasPerProject = new HashMap(1);
    protected DOMFactory fFactory = new DOMFactory();
    protected ArrayList fCreatedElements;

    public CopyResourceElementsOperation(IJavaElement[] resourcesToCopy, IJavaElement[] destContainers, boolean force) {
        super(resourcesToCopy, destContainers, force);
    }

    public CopyResourceElementsOperation(IJavaElement[] resourcesToCopy, IJavaElement destContainer, boolean force) {
        this(resourcesToCopy, new IJavaElement[]{destContainer}, force);
    }

    private IResource[] collectResourcesOfInterest(IPackageFragment source) throws JavaModelException {
        IJavaElement[] children = source.getChildren();
        int childOfInterest = 5;
        if (source.getKind() == 2) {
            childOfInterest = 6;
        }
        ArrayList<IResource> correctKindChildren = new ArrayList<IResource>(children.length);
        int i = 0;
        while (i < children.length) {
            IJavaElement child = children[i];
            if (child.getElementType() == childOfInterest) {
                correctKindChildren.add(child.getResource());
            }
            ++i;
        }
        Object[] nonJavaResources = source.getNonJavaResources();
        int actualNonJavaResourceCount = 0;
        int i2 = 0;
        int max = nonJavaResources.length;
        while (i2 < max) {
            if (nonJavaResources[i2] instanceof IResource) {
                ++actualNonJavaResourceCount;
            }
            ++i2;
        }
        IResource[] actualNonJavaResources = new IResource[actualNonJavaResourceCount];
        int i3 = 0;
        int max2 = nonJavaResources.length;
        int index = 0;
        while (i3 < max2) {
            if (nonJavaResources[i3] instanceof IResource) {
                actualNonJavaResources[index++] = (IResource)nonJavaResources[i3];
            }
            ++i3;
        }
        if (actualNonJavaResourceCount != 0) {
            int correctKindChildrenSize = correctKindChildren.size();
            IResource[] result = new IResource[correctKindChildrenSize + actualNonJavaResourceCount];
            correctKindChildren.toArray(result);
            System.arraycopy(actualNonJavaResources, 0, result, correctKindChildrenSize, actualNonJavaResourceCount);
            return result;
        }
        IResource[] result = new IResource[correctKindChildren.size()];
        correctKindChildren.toArray(result);
        return result;
    }

    private void createNeededPackageFragments(IContainer sourceFolder, IPackageFragmentRoot root, String newFragName, boolean moveFolder) throws JavaModelException {
        IContainer parentFolder = (IContainer)root.getResource();
        JavaElementDelta projectDelta = null;
        String[] names = Util.getTrimmedSimpleNames(newFragName);
        StringBuffer sideEffectPackageName = new StringBuffer();
        char[][] exclusionsPatterns = ((PackageFragmentRoot)root).fullExclusionPatternChars();
        int i = 0;
        while (i < names.length) {
            String subFolderName = names[i];
            sideEffectPackageName.append(subFolderName);
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                if (!moveFolder || i != names.length - 1) {
                    this.createFolder(parentFolder, subFolderName, this.fForce);
                }
                parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                if ((sourceFolder = sourceFolder.getFolder((IPath)new Path(subFolderName))).isReadOnly()) {
                    parentFolder.setReadOnly(true);
                }
                IPackageFragment sideEffectPackage = root.getPackageFragment(sideEffectPackageName.toString());
                if (i < names.length - 1 && !Util.isExcluded((IResource)parentFolder, exclusionsPatterns)) {
                    if (projectDelta == null) {
                        projectDelta = this.getDeltaFor(root.getJavaProject());
                    }
                    projectDelta.added(sideEffectPackage);
                }
                this.fCreatedElements.add(sideEffectPackage);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            sideEffectPackageName.append('.');
            ++i;
        }
    }

    private JavaElementDelta getDeltaFor(IJavaProject javaProject) {
        JavaElementDelta delta = (JavaElementDelta)this.fDeltasPerProject.get(javaProject);
        if (delta == null) {
            delta = new JavaElementDelta(javaProject);
            this.fDeltasPerProject.put(javaProject, delta);
        }
        return delta;
    }

    protected String getMainTaskName() {
        return Util.bind("operation.copyResourceProgress");
    }

    protected void prepareDeltas(IJavaElement sourceElement, IJavaElement destinationElement, boolean isMove) {
        if (Util.isExcluded(sourceElement) || Util.isExcluded(destinationElement)) {
            return;
        }
        IJavaProject destProject = destinationElement.getJavaProject();
        if (isMove) {
            IJavaProject sourceProject = sourceElement.getJavaProject();
            this.getDeltaFor(sourceProject).movedFrom(sourceElement, destinationElement);
            this.getDeltaFor(destProject).movedTo(destinationElement, sourceElement);
        } else {
            this.getDeltaFor(destProject).added(destinationElement);
        }
    }

    private void processCompilationUnitResource(ICompilationUnit source, IPackageFragment dest) throws JavaModelException {
        String newCUName = this.getNewNameFor(source);
        String destName = newCUName != null ? newCUName : source.getElementName();
        String newContent = this.updatedContent(source, dest, newCUName);
        IFile sourceResource = (IFile)(source.isWorkingCopy() ? source.getOriginalElement() : source).getResource();
        IContainer destFolder = (IContainer)dest.getResource();
        IFile destFile = destFolder.getFile((IPath)new Path(destName));
        if (!destFile.equals((Object)sourceResource)) {
            try {
                int flags;
                if (destFile.exists()) {
                    if (this.fForce) {
                        this.deleteResource((IResource)destFile, 2);
                    } else {
                        throw new JavaModelException(new JavaModelStatus(977, org.eclipse.jdt.internal.compiler.util.Util.bind("status.nameCollision", destFile.getFullPath().toString())));
                    }
                }
                int n = flags = this.fForce ? 1 : 0;
                if (this.isMove()) {
                    sourceResource.move(destFile.getFullPath(), flags |= 2, this.getSubProgressMonitor(1));
                } else {
                    if (newContent != null) {
                        flags |= 2;
                    }
                    sourceResource.copy(destFile.getFullPath(), flags, this.getSubProgressMonitor(1));
                }
                this.setAttribute("hasModifiedResource", "true");
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            try {
                if (newContent != null) {
                    String encoding = source.getJavaProject().getOption("org.eclipse.jdt.core.encoding", true);
                    destFile.setContents((InputStream)new ByteArrayInputStream(encoding == null ? newContent.getBytes() : newContent.getBytes(encoding)), this.fForce ? 3 : 2, this.getSubProgressMonitor(1));
                }
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            ICompilationUnit destCU = dest.getCompilationUnit(destName);
            this.prepareDeltas(source, destCU, this.isMove());
            if (newCUName != null) {
                String oldName = source.getElementName();
                oldName = oldName.substring(0, oldName.length() - 5);
                String newName = newCUName;
                newName = newName.substring(0, newName.length() - 5);
                this.prepareDeltas(source.getType(oldName), destCU.getType(newName), this.isMove());
            }
        } else {
            if (!this.fForce) {
                throw new JavaModelException(new JavaModelStatus(977, org.eclipse.jdt.internal.compiler.util.Util.bind("status.nameCollision", destFile.getFullPath().toString())));
            }
            try {
                if (newContent != null) {
                    String encoding = source.getJavaProject().getOption("org.eclipse.jdt.core.encoding", true);
                    destFile.setContents((InputStream)new ByteArrayInputStream(encoding == null ? newContent.getBytes() : newContent.getBytes(encoding)), this.fForce ? 3 : 2, this.getSubProgressMonitor(1));
                }
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
    }

    protected void processDeltas() {
        Iterator deltas = this.fDeltasPerProject.values().iterator();
        while (deltas.hasNext()) {
            this.addDelta((IJavaElementDelta)deltas.next());
        }
    }

    protected void processElement(IJavaElement element) throws JavaModelException {
        IJavaElement dest = this.getDestinationParent(element);
        switch (element.getElementType()) {
            case 5: {
                this.processCompilationUnitResource((ICompilationUnit)element, (IPackageFragment)dest);
                this.fCreatedElements.add(((IPackageFragment)dest).getCompilationUnit(element.getElementName()));
                break;
            }
            case 4: {
                this.processPackageFragmentResource((IPackageFragment)element, (IPackageFragmentRoot)dest, this.getNewNameFor(element));
                break;
            }
            default: {
                throw new JavaModelException(new JavaModelStatus(967, element));
            }
        }
    }

    protected void processElements() throws JavaModelException {
        this.fCreatedElements = new ArrayList(this.fElementsToProcess.length);
        try {
            super.processElements();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fResultElements = new IJavaElement[this.fCreatedElements.size()];
            this.fCreatedElements.toArray(this.fResultElements);
            this.processDeltas();
            throw throwable;
        }
        Object var2_4 = null;
        this.fResultElements = new IJavaElement[this.fCreatedElements.size()];
        this.fCreatedElements.toArray(this.fResultElements);
        this.processDeltas();
    }

    private void processPackageFragmentResource(IPackageFragment source, IPackageFragmentRoot root, String newName) throws JavaModelException {
        try {
            String newFragName = newName == null ? source.getElementName() : newName;
            IPackageFragment newFrag = root.getPackageFragment(newFragName);
            IResource[] resources = this.collectResourcesOfInterest(source);
            boolean shouldMoveFolder = this.isMove() && !newFrag.getResource().exists();
            IFolder srcFolder = (IFolder)source.getResource();
            IPath destPath = newFrag.getPath();
            if (shouldMoveFolder) {
                if (srcFolder.getFullPath().isPrefixOf(destPath)) {
                    shouldMoveFolder = false;
                } else {
                    IResource[] members = srcFolder.members();
                    int i = 0;
                    while (i < members.length) {
                        if (members[i] instanceof IFolder) {
                            shouldMoveFolder = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.createNeededPackageFragments((IContainer)source.getParent().getResource(), root, newFragName, shouldMoveFolder);
            if (shouldMoveFolder) {
                srcFolder.move(destPath, this.fForce, true, this.getSubProgressMonitor(1));
                this.setAttribute("hasModifiedResource", "true");
            } else if (resources.length > 0) {
                IResource destinationResource;
                int max;
                if (this.isRename()) {
                    if (!destPath.equals((Object)source.getPath())) {
                        this.moveResources(resources, destPath);
                    }
                } else if (this.isMove()) {
                    int i = 0;
                    max = resources.length;
                    while (i < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i].getName()));
                        if (destinationResource != null) {
                            if (this.fForce) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new JavaModelException(new JavaModelStatus(977, org.eclipse.jdt.internal.compiler.util.Util.bind("status.nameCollision", destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i;
                    }
                    this.moveResources(resources, destPath);
                } else {
                    int i = 0;
                    max = resources.length;
                    while (i < max) {
                        destinationResource = ResourcesPlugin.getWorkspace().getRoot().findMember(destPath.append(resources[i].getName()));
                        if (destinationResource != null) {
                            if (this.fForce) {
                                this.deleteResource(destinationResource, 2);
                            } else {
                                throw new JavaModelException(new JavaModelStatus(977, org.eclipse.jdt.internal.compiler.util.Util.bind("status.nameCollision", destinationResource.getFullPath().toString())));
                            }
                        }
                        ++i;
                    }
                    this.copyResources(resources, destPath);
                }
            }
            boolean isEmpty = true;
            if (this.isMove()) {
                if (srcFolder.exists()) {
                    IResource[] remaingFiles = srcFolder.members();
                    int i = 0;
                    int length = remaingFiles.length;
                    while (i < length) {
                        IResource file = remaingFiles[i];
                        if (file instanceof IFile) {
                            this.deleteResource(file, 3);
                        } else {
                            isEmpty = false;
                        }
                        ++i;
                    }
                }
                if (isEmpty) {
                    IResource rootResource = destPath.isPrefixOf(srcFolder.getFullPath()) ? newFrag.getResource() : source.getParent().getResource();
                    this.deleteEmptyPackageFragment(source, false, rootResource);
                }
            }
            if (!newFrag.getElementName().equals(source.getElementName())) {
                int i = 0;
                while (i < resources.length) {
                    ICompilationUnit cu;
                    IDOMCompilationUnit domCU;
                    if (resources[i].getName().endsWith(".java") && (domCU = this.fFactory.createCompilationUnit((cu = newFrag.getCompilationUnit(resources[i].getName())).getSource(), cu.getElementName())) != null) {
                        String bufferContents;
                        this.updatePackageStatement(domCU, newFragName);
                        IBuffer buffer = cu.getBuffer();
                        if (buffer != null && (bufferContents = buffer.getContents()) != null) {
                            String domCUContents = domCU.getContents();
                            String cuContents = null;
                            cuContents = domCUContents != null ? Util.normalizeCRs(domCU.getContents(), bufferContents) : bufferContents;
                            buffer.setContents(cuContents);
                            cu.save(null, false);
                        }
                    }
                    ++i;
                }
            }
            this.prepareDeltas(source, newFrag, this.isMove() && isEmpty);
        }
        catch (DOMException dom) {
            throw new JavaModelException(dom, 986);
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException ce) {
            throw new JavaModelException(ce);
        }
    }

    private String updatedContent(ICompilationUnit cu, IPackageFragment dest, String newName) throws JavaModelException {
        String destPackageName;
        String currPackageName = cu.getParent().getElementName();
        if (currPackageName.equals(destPackageName = dest.getElementName()) && newName == null) {
            return null;
        }
        String typeName = cu.getElementName();
        typeName = typeName.substring(0, typeName.length() - 5);
        IDOMCompilationUnit cuDOM = null;
        IBuffer buffer = cu.getBuffer();
        if (buffer == null) {
            return null;
        }
        char[] contents = buffer.getCharacters();
        if (contents == null) {
            return null;
        }
        cuDOM = this.fFactory.createCompilationUnit(contents, typeName);
        this.updateTypeName(cu, cuDOM, cu.getElementName(), newName);
        this.updatePackageStatement(cuDOM, destPackageName);
        return cuDOM.getContents();
    }

    private void updatePackageStatement(IDOMCompilationUnit domCU, String pkgName) throws JavaModelException {
        boolean defaultPackage = pkgName.equals("");
        boolean seenPackageNode = false;
        Enumeration enumeration = domCU.getChildren();
        while (enumeration.hasMoreElements()) {
            IDOMNode node = (IDOMNode)enumeration.nextElement();
            if (node.getNodeType() != 2) continue;
            if (!defaultPackage) {
                node.setName(pkgName);
            } else {
                node.remove();
            }
            seenPackageNode = true;
            break;
        }
        if (!seenPackageNode && !defaultPackage) {
            IDOMPackage pkg = this.fFactory.createPackage("package " + pkgName + ";" + org.eclipse.jdt.internal.compiler.util.Util.LINE_SEPARATOR);
            IDOMNode firstChild = domCU.getFirstChild();
            if (firstChild != null) {
                firstChild.insertSibling(pkg);
            }
        }
    }

    private void updateTypeName(ICompilationUnit cu, IDOMCompilationUnit domCU, String oldName, String newName) throws JavaModelException {
        if (newName != null) {
            if (this.fRenamedCompilationUnits == null) {
                this.fRenamedCompilationUnits = new ArrayList(1);
            }
            this.fRenamedCompilationUnits.add(cu);
            String oldTypeName = oldName.substring(0, oldName.length() - 5);
            String newTypeName = newName.substring(0, newName.length() - 5);
            IType[] types = cu.getTypes();
            int i = 0;
            int max = types.length;
            while (i < max) {
                IDOMNode typeNode;
                IType currentType = types[i];
                if (currentType.getElementName().equals(oldTypeName) && (typeNode = ((JavaElement)((Object)currentType)).findNode(domCU)) != null) {
                    typeNode.setName(newTypeName);
                }
                ++i;
            }
        }
    }

    protected IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fRenamingsList != null && this.fRenamingsList.length != this.fElementsToProcess.length) {
            return new JavaModelStatus(980);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    protected void verify(IJavaElement element) throws JavaModelException {
        int elementType;
        IResource resource;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if (element.isReadOnly() && (this.isRename() || this.isMove())) {
            this.error(976, element);
        }
        if ((resource = element.getResource()) instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
        if ((elementType = element.getElementType()) == 5) {
            if (this.isMove() && ((ICompilationUnit)element).isWorkingCopy()) {
                this.error(967, element);
            }
        } else if (elementType != 4) {
            this.error(967, element);
        }
        JavaElement dest = (JavaElement)this.getDestinationParent(element);
        this.verifyDestination(element, dest);
        if (this.fRenamings != null) {
            this.verifyRenaming(element);
        }
    }
}

