/*
 * Decompiled with CFR 0.152.
 */
package dk.hyperdivision.multisig_hmac;

import dk.hyperdivision.multisig_hmac.Key;
import dk.hyperdivision.multisig_hmac.Signature;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MultisigHMAC {
    protected String PRIMITIVE;
    protected int KEYBYTES;
    protected int BYTES;

    public String getPRIMITIVE() {
        return this.PRIMITIVE;
    }

    public int getKEYBYTES() {
        return this.KEYBYTES;
    }

    public int getBYTES() {
        return this.BYTES;
    }

    public MultisigHMAC(Algorithm alg) {
        switch (alg) {
            case HmacSHA256: {
                this.PRIMITIVE = "HmacSHA256";
                this.KEYBYTES = 64;
                this.BYTES = 32;
                break;
            }
            case HmacSHA512: {
                this.PRIMITIVE = "HmacSHA512";
                this.KEYBYTES = 128;
                this.BYTES = 64;
                break;
            }
            case HmacSHA384: {
                this.PRIMITIVE = "HmacSHA384";
                this.KEYBYTES = 128;
                this.BYTES = 48;
            }
        }
    }

    public Key generate(int index) {
        byte[] keyBytes = new byte[this.KEYBYTES];
        SecureRandom random = new SecureRandom();
        random.nextBytes(keyBytes);
        return new Key(index, keyBytes);
    }

    public Signature sign(Key key, byte[] message) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac HMAC = Mac.getInstance(this.PRIMITIVE);
        SecretKeySpec hmacKey = new SecretKeySpec(key.key, this.PRIMITIVE);
        HMAC.init(hmacKey);
        return new Signature(1 << key.index, HMAC.doFinal(message));
    }

    public Signature combine(List<Signature> signatures) {
        int indexCurrent = 0;
        byte[] signatureCurrent = new byte[this.BYTES];
        for (Signature obj : signatures) {
            indexCurrent ^= obj.index;
            signatureCurrent = this.xorBytes(signatureCurrent, obj.signature);
        }
        return new Signature(indexCurrent, signatureCurrent);
    }

    protected byte[] xorBytes(byte[] a, byte[] b) {
        byte[] c = new byte[this.BYTES];
        for (int i = 0; i < Math.max(a.length, b.length); ++i) {
            c[i] = (byte)(a[i] ^ b[i]);
        }
        return c;
    }

    public boolean verify(List<Key> keys, Signature signatures, byte[] message, int threshold) throws InvalidKeyException, NoSuchAlgorithmException, IllegalArgumentException {
        if (signatures.signature.length != this.BYTES) {
            throw new IllegalArgumentException("Signature must be BYTES long");
        }
        if (message == null) {
            throw new IllegalArgumentException("message must be bytes");
        }
        if (threshold <= 0) {
            throw new IllegalArgumentException("Threshold must be at least 1");
        }
        int bitField = signatures.index;
        int nKeys = MultisigHMAC.popCount(bitField);
        int highestKey = 32 - MultisigHMAC.leadingZeros(bitField);
        if (keys.size() < nKeys || keys.size() < highestKey) {
            throw new IllegalArgumentException("Not enough keys given based on index of the combined-Signature");
        }
        if (nKeys < threshold) {
            return false;
        }
        List<Integer> usedKeys = MultisigHMAC.keyIndexes(bitField);
        byte[] sig = signatures.signature;
        for (Integer usedKey : usedKeys) {
            Key key = keys.get(usedKey);
            Signature KeySig = this.sign(key, message);
            sig = this.xorBytes(sig, KeySig.signature);
            bitField ^= KeySig.index;
        }
        return bitField == 0 && Arrays.equals(sig, new byte[this.BYTES]);
    }

    protected static List<Integer> keyIndexes(int bitField) {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        int i = 0;
        while (bitField > 0) {
            if ((bitField & 1) == 1) {
                keys.add(i);
            }
            bitField >>= 1;
            ++i;
        }
        return keys;
    }

    protected static int popCount(int bitField) {
        return Integer.bitCount(bitField);
    }

    protected static int leadingZeros(int bitField) {
        int n = 32;
        for (int c = 16; c != 0; c >>= 1) {
            int y = bitField >> c;
            if (y == 0) continue;
            n -= c;
            bitField = y;
        }
        return n - bitField;
    }

    public static enum Algorithm {
        HmacSHA256,
        HmacSHA512,
        HmacSHA384;

    }
}

