/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ldap.server.schema.bootstrap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.ldap.common.schema.MatchingRuleUse;
import org.apache.ldap.server.schema.MatchingRuleUseRegistry;
import org.apache.ldap.server.schema.MatchingRuleUseRegistryMonitor;
import org.apache.ldap.server.schema.MatchingRuleUseRegistryMonitorAdapter;

public class BootstrapMatchingRuleUseRegistry
implements MatchingRuleUseRegistry {
    private final Map byName = new HashMap();
    private final Map nameToSchema = new HashMap();
    private MatchingRuleUseRegistryMonitor monitor = new MatchingRuleUseRegistryMonitorAdapter();

    public void setMonitor(MatchingRuleUseRegistryMonitor monitor) {
        this.monitor = monitor;
    }

    public void register(String schema, MatchingRuleUse matchingRuleUse) throws NamingException {
        if (this.byName.containsKey(matchingRuleUse.getName())) {
            NamingException e = new NamingException("matchingRuleUse w/ name " + matchingRuleUse.getName() + " has already been registered!");
            this.monitor.registerFailed(matchingRuleUse, e);
            throw e;
        }
        this.nameToSchema.put(matchingRuleUse.getName(), schema);
        this.byName.put(matchingRuleUse.getName(), matchingRuleUse);
        this.monitor.registered(matchingRuleUse);
    }

    public MatchingRuleUse lookup(String name) throws NamingException {
        if (!this.byName.containsKey(name)) {
            NamingException e = new NamingException("matchingRuleUse w/ name " + name + " not registered!");
            this.monitor.lookupFailed(name, e);
            throw e;
        }
        MatchingRuleUse matchingRuleUse = (MatchingRuleUse)this.byName.get(name);
        this.monitor.lookedUp(matchingRuleUse);
        return matchingRuleUse;
    }

    public boolean hasMatchingRuleUse(String name) {
        return this.byName.containsKey(name);
    }

    public String getSchemaName(String id) throws NamingException {
        if (this.nameToSchema.containsKey(id)) {
            return (String)this.nameToSchema.get(id);
        }
        throw new NamingException("Name " + id + " not found in name to " + "schema name map!");
    }

    public Iterator list() {
        return this.byName.values().iterator();
    }
}

